/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.eclipse.stp.ui.xef.schema.AbstractAnnotatedElement;
import org.eclipse.stp.ui.xef.schema.AnnotatedElement;
import org.eclipse.stp.ui.xef.schema.AnyElement;
import org.eclipse.stp.ui.xef.schema.IContextProvider;
import org.eclipse.stp.ui.xef.schema.SchemaAttribute;
import org.eclipse.stp.ui.xef.schema.SchemaValueComponent;
import org.eclipse.stp.ui.xef.schema.SchemaValueType;
import org.eclipse.stp.ui.xef.schema.ValueType;
import org.eclipse.stp.ui.xef.schema.WidgetStyle;
import org.eclipse.stp.xef.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaElement
extends AbstractAnnotatedElement
implements AnnotatedElement,
SchemaValueComponent,
Comparable {
    final XSElementDeclaration ctx;
    final XSParticle particle;
    final XSModelGroup group;
    private Map<String, Boolean> qualifiers = new HashMap<String, Boolean>();
    private List<List<String>> requires = new ArrayList<List<String>>();
    private Boolean unique = null;
    private AnyElement anySequenceElement;

    SchemaElement(XSElementDeclaration obj, XSParticle part, XSModelGroup grp) {
        this.ctx = obj;
        this.particle = part;
        this.group = grp;
        XSTypeDefinition td = this.ctx.getTypeDefinition();
        if (td instanceof XSComplexTypeDefinition) {
            XSObjectList annotations = ((XSComplexTypeDefinition)td).getAnnotations();
            int i = 0;
            while (annotations != null && i < annotations.getLength()) {
                XSObject annotation = annotations.item(i);
                if (annotation instanceof XSAnnotation) {
                    this.handleAnnotations((XSAnnotation)annotation);
                }
                ++i;
            }
        }
        this.handleAnnotations(this.ctx.getAnnotation());
        if (this.getValueType() != null && this.getValueType().getType() == ValueType.STRING) {
            this.widgetStyles.add(WidgetStyle.MULTILINE);
        }
    }

    @Override
    Document handleAnnotations(XSAnnotation annotation) {
        Document domDoc = super.handleAnnotations(annotation);
        if (this.category == null) {
            this.category = this.getNameSpace();
        }
        if (domDoc == null) {
            return null;
        }
        NodeList qualifierNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "qualifier");
        int i = 0;
        while (i < qualifierNodes.getLength()) {
            Node n = qualifierNodes.item(i);
            String val = SchemaElement.getTextValue(n);
            boolean allowMultiple = "true".equalsIgnoreCase(SchemaElement.getAttributeValue(n, null, "multiple"));
            this.qualifiers.put(val, allowMultiple);
            ++i;
        }
        NodeList requiresNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "requires");
        int i2 = 0;
        while (i2 < requiresNodes.getLength()) {
            ArrayList<String> conjunction = new ArrayList<String>();
            Node n = requiresNodes.item(i2);
            NodeList children = n.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node c = children.item(j);
                if ("http://schemas.eclipse.org/stp/xsd/2006/05/xef".equals(c.getNamespaceURI()) && "element_qname".equals(c.getLocalName())) {
                    conjunction.add(SchemaElement.getTextValue(c));
                }
                ++j;
            }
            if (conjunction.size() > 0) {
                this.requires.add(conjunction);
            }
            ++i2;
        }
        NodeList uniqueNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "unique");
        String u = SchemaElement.getTextValue(uniqueNodes);
        if ("true".equalsIgnoreCase(u)) {
            this.unique = Boolean.TRUE;
        } else if ("false".equalsIgnoreCase(u)) {
            this.unique = Boolean.FALSE;
        }
        return domDoc;
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean isMenu) {
        String dn = super.getDisplayName();
        if (dn == null) {
            dn = !isMenu && this.ctx.getScope() == 1 ? this.toRawString() : this.getName();
        }
        return dn;
    }

    @Override
    public String getName() {
        return this.ctx.getName();
    }

    public String getShortNameSpace() {
        return XMLUtil.inferNamespacePrefix(this.ctx.getNamespace());
    }

    public String getNameSpace() {
        return this.ctx.getNamespace();
    }

    @Override
    public String getFixed() {
        if (this.ctx.getConstraintType() == 2) {
            return this.ctx.getConstraintValue();
        }
        return null;
    }

    @Override
    public String getDefault() {
        if (this.ctx.getConstraintType() == 1) {
            return this.ctx.getConstraintValue();
        }
        return null;
    }

    public Map<String, Boolean> getQualifiers() {
        return this.qualifiers;
    }

    public List<List<String>> getRequires() {
        return this.requires;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public List<SchemaAttribute> getAttributes() {
        LinkedList<SchemaAttribute> l = new LinkedList<SchemaAttribute>();
        XSTypeDefinition td = this.ctx.getTypeDefinition();
        if (td instanceof XSComplexTypeDefinition) {
            XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)td;
            XSObjectList attrs = ctd.getAttributeUses();
            int i = 0;
            while (i < attrs.getLength()) {
                XSObject obj = attrs.item(i);
                if (obj instanceof XSAttributeUse) {
                    XSAttributeUse attr = (XSAttributeUse)obj;
                    SchemaAttribute sa = new SchemaAttribute(attr.getAttrDeclaration());
                    sa.setRequired(attr.getRequired());
                    if (attr.getConstraintType() == 1) {
                        sa.setDefault(attr.getConstraintValue());
                    }
                    if (attr.getConstraintType() == 2) {
                        sa.setFixed(attr.getConstraintValue());
                    }
                    l.add(sa);
                }
                ++i;
            }
        }
        return l;
    }

    public SchemaAttribute getAttribute(String name) {
        for (SchemaAttribute attr : this.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public boolean hasText() {
        XSTypeDefinition type = this.ctx.getTypeDefinition();
        if (type instanceof XSSimpleTypeDefinition) {
            return true;
        }
        if (type instanceof XSComplexTypeDefinition) {
            return ((XSComplexTypeDefinition)type).getContentType() == 1;
        }
        return false;
    }

    public SchemaElement getNestedElement(String name) {
        for (SchemaElement nested : this.getNestedElements(new LinkedList<SchemaElement>())) {
            if (!nested.getName().equals(name)) continue;
            return nested;
        }
        return null;
    }

    public List<SchemaElement> getNestedElements(List<SchemaElement> present) {
        XSTerm groupTerm;
        XSComplexTypeDefinition ctd;
        XSParticle part;
        XSTypeDefinition td = this.ctx.getTypeDefinition();
        if (td instanceof XSComplexTypeDefinition && (part = (ctd = (XSComplexTypeDefinition)td).getParticle()) != null && (groupTerm = part.getTerm()) instanceof XSModelGroup) {
            return this.getNestedElements((XSModelGroup)groupTerm, present);
        }
        return new ArrayList<SchemaElement>(0);
    }

    public List<SchemaElement> getMinimalSisterElementsList(List<SchemaElement> present) {
        LinkedList<SchemaElement> ret = new LinkedList<SchemaElement>();
        if (this.group != null) {
            switch (this.group.getCompositor()) {
                case 1: 
                case 3: {
                    List<SchemaElement> sisters = this.getElements(this.group);
                    for (SchemaElement sister : sisters) {
                        if (sister.equals(this) || sister.particle == null) continue;
                        int pCount = sister.particle.getMinOccurs();
                        for (SchemaElement p : present) {
                            if (!p.equals(sister)) continue;
                            --pCount;
                        }
                        while (pCount > 0) {
                            ret.add(sister);
                            --pCount;
                        }
                    }
                    break;
                }
            }
        }
        return ret;
    }

    public List<SchemaElement> getMinimalSubElementList() {
        XSTerm groupTerm;
        XSComplexTypeDefinition ctd;
        XSParticle particle;
        XSTypeDefinition td = this.ctx.getTypeDefinition();
        if (td instanceof XSComplexTypeDefinition && (particle = (ctd = (XSComplexTypeDefinition)td).getParticle()) != null && (groupTerm = particle.getTerm()) instanceof XSModelGroup) {
            XSModelGroup group = (XSModelGroup)groupTerm;
            switch (group.getCompositor()) {
                case 1: 
                case 3: {
                    List<SchemaElement> availableElements = this.getElements(group);
                    LinkedList<SchemaElement> minimalElements = new LinkedList<SchemaElement>();
                    for (SchemaElement available : availableElements) {
                        if (available.particle == null) continue;
                        int i = 0;
                        while (i < available.particle.getMinOccurs()) {
                            minimalElements.add(available);
                            ++i;
                        }
                    }
                    return minimalElements;
                }
            }
            return new ArrayList<SchemaElement>(0);
        }
        return new ArrayList<SchemaElement>(0);
    }

    private List<SchemaElement> getNestedElements(XSModelGroup group, List<SchemaElement> present) {
        ArrayList<SchemaElement> ret = new ArrayList<SchemaElement>();
        List<SchemaElement> availableElements = this.getElements(group);
        List<XSModelGroup> subGroups = this.getSubGroups(group);
        switch (group.getCompositor()) {
            case 2: {
                ret.addAll(this.getChoiceElements(availableElements, subGroups, present));
                break;
            }
            case 1: {
                ret.addAll(this.getSequenceElements(availableElements, present));
                break;
            }
            case 3: {
                ret.addAll(availableElements);
                break;
            }
        }
        for (XSModelGroup subGroup : subGroups) {
            ret.addAll(this.getNestedElements(subGroup, present));
        }
        return ret;
    }

    private List<SchemaElement> getChoiceElements(List<SchemaElement> availableElements, List<XSModelGroup> subGroups, List<SchemaElement> presentElements) {
        for (XSModelGroup subGroup : subGroups) {
            List<SchemaElement> subElems = this.getAllElements(subGroup);
            for (SchemaElement present : presentElements) {
                if (!subElems.contains(present)) continue;
                subGroups.clear();
                subGroups.add(subGroup);
                return new ArrayList<SchemaElement>();
            }
        }
        for (SchemaElement present : presentElements) {
            if (!availableElements.contains(present)) continue;
            ArrayList<SchemaElement> ret = new ArrayList<SchemaElement>();
            if (present.particle != null && (present.particle.getMaxOccursUnbounded() || this.getElementCount(presentElements, present) < present.particle.getMaxOccurs())) {
                ret.add(present);
            }
            subGroups.clear();
            return ret;
        }
        return availableElements;
    }

    private List<SchemaElement> getSequenceElements(List<SchemaElement> availableElements, List<SchemaElement> presentElements) {
        ArrayList<SchemaElement> l = new ArrayList<SchemaElement>(availableElements.size());
        for (SchemaElement available : availableElements) {
            if (available.particle == null || !available.particle.getMaxOccursUnbounded() && this.getElementCount(presentElements, available) >= available.particle.getMaxOccurs()) continue;
            l.add(available);
        }
        return l;
    }

    private int getElementCount(List<SchemaElement> list, SchemaElement element) {
        int count = 0;
        for (SchemaElement el : list) {
            if (!el.equals(element)) continue;
            ++count;
        }
        return count;
    }

    private List<SchemaElement> getElements(XSModelGroup group) {
        LinkedList<SchemaElement> l = new LinkedList<SchemaElement>();
        XSObjectList list = group.getParticles();
        int i = 0;
        while (i < list.getLength()) {
            XSParticle part;
            XSTerm term;
            XSObject item = list.item(i);
            if (item instanceof XSParticle && (term = (part = (XSParticle)item).getTerm()) instanceof XSElementDeclaration) {
                l.add(new SchemaElement((XSElementDeclaration)term, part, group));
            }
            ++i;
        }
        return l;
    }

    private List<SchemaElement> getAllElements(XSModelGroup group) {
        LinkedList<SchemaElement> l = new LinkedList<SchemaElement>();
        XSObjectList list = group.getParticles();
        int i = 0;
        while (i < list.getLength()) {
            XSObject item = list.item(i);
            if (item instanceof XSParticle) {
                XSParticle part = (XSParticle)item;
                XSTerm term = part.getTerm();
                if (term instanceof XSElementDeclaration) {
                    l.add(new SchemaElement((XSElementDeclaration)term, part, group));
                } else if (term instanceof XSModelGroup) {
                    l.addAll(this.getAllElements((XSModelGroup)term));
                }
            }
            ++i;
        }
        return l;
    }

    private List<XSModelGroup> getSubGroups(XSModelGroup group) {
        LinkedList<XSModelGroup> l = new LinkedList<XSModelGroup>();
        XSObjectList list = group.getParticles();
        int i = 0;
        while (i < list.getLength()) {
            XSParticle part;
            XSTerm term;
            XSObject item = list.item(i);
            if (item instanceof XSParticle && (term = (part = (XSParticle)item).getTerm()) instanceof XSModelGroup) {
                l.add((XSModelGroup)term);
            }
            ++i;
        }
        return l;
    }

    public boolean isSequenceOfAny() {
        XSWildcard wildCard;
        XSTerm subTerm;
        XSObject subPart;
        XSObjectList subPartList;
        XSTerm term;
        XSParticle part;
        if (this.anySequenceElement != null) {
            return !this.anySequenceElement.equals(AnyElement.NO_ANY_ELEMENT);
        }
        XSTypeDefinition type = this.ctx.getTypeDefinition();
        if (type instanceof XSComplexTypeDefinition && !"http://www.w3.org/2001/XMLSchema".equals(type.getNamespace()) && (part = ((XSComplexTypeDefinition)type).getParticle()) != null && (term = part.getTerm()) instanceof XSModelGroup && (subPartList = ((XSModelGroup)term).getParticles()).getLength() == 1 && (subPart = subPartList.item(0)) instanceof XSParticle && (subTerm = ((XSParticle)subPart).getTerm()) instanceof XSWildcard && (wildCard = (XSWildcard)subTerm).getConstraintType() == 1) {
            this.anySequenceElement = new AnyElement(wildCard);
            return true;
        }
        this.anySequenceElement = AnyElement.NO_ANY_ELEMENT;
        return false;
    }

    public AnyElement getAnySequenceElement() {
        if (this.isSequenceOfAny()) {
            return this.anySequenceElement;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchemaElement)) {
            return false;
        }
        SchemaElement se = (SchemaElement)obj;
        return this.ctx.equals(se.ctx);
    }

    public int hashCode() {
        return this.ctx.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private String toRawString() {
        String shortNS = this.getShortNameSpace();
        return shortNS == null ? this.getName() : String.valueOf(shortNS) + ":" + this.getName();
    }

    public int compareTo(Object o) {
        if (o instanceof SchemaElement) {
            return this.getName().compareTo(((SchemaElement)o).getName());
        }
        return 0;
    }

    @Override
    public Object getContextData(IContextProvider contextProvider) {
        return null;
    }

    @Override
    public String[] getContextValues(IContextProvider contextProvider, String dependencyValue) {
        return null;
    }

    @Override
    public String getContextXPath() {
        return null;
    }

    @Override
    public String getExample() {
        return null;
    }

    @Override
    public String getFieldEditorId() {
        return null;
    }

    @Override
    public String getFilterId() {
        return null;
    }

    @Override
    public String getPattern() {
        return null;
    }

    @Override
    public boolean getRequired() {
        return false;
    }

    @Override
    public String getUnits() {
        return null;
    }

    @Override
    public SchemaValueType getValueType() {
        XSSimpleTypeDefinition simpleType;
        XSTypeDefinition def = this.ctx.getTypeDefinition();
        if (def instanceof XSSimpleTypeDefinition) {
            return new SchemaValueType((XSSimpleTypeDefinition)def);
        }
        if (def instanceof XSComplexTypeDefinition && (simpleType = ((XSComplexTypeDefinition)def).getSimpleType()) != null) {
            return new SchemaValueType(simpleType);
        }
        return null;
    }

    @Override
    public void setPattern(String string) {
    }
}

