/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.stp.ui.xef.schema.SchemaAttribute;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.xef.ValidationProblem;
import org.eclipse.stp.xef.util.QNameHelper;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLInstanceElement {
    private static final String DERIVED_PREFIX = "#";
    private static final String DERIVED_POSTFIX = "#";
    private final SchemaElement template;
    private final XMLInstanceElement parent;
    private Element jdomElement;
    private final List<XMLInstanceElement> children = new LinkedList<XMLInstanceElement>();
    private Map<Object, Object> data = new HashMap<Object, Object>(1);
    private Map<String, String> nsMap;

    public XMLInstanceElement(SchemaElement tmpl) {
        this(tmpl, null);
    }

    public XMLInstanceElement(SchemaElement tmpl, XMLInstanceElement par) {
        this(tmpl, par, new Element(tmpl.getName(), tmpl.getShortNameSpace(), tmpl.getNameSpace()));
    }

    XMLInstanceElement(SchemaElement tmpl, XMLInstanceElement par, Element jdomEl) {
        this.template = tmpl;
        this.parent = par;
        this.jdomElement = jdomEl;
        this.nsMap = this.getNamespaceMappings();
    }

    public synchronized void addMinimalSubElements() {
        for (SchemaElement childElement : this.template.getMinimalSubElementList()) {
            XMLInstanceElement child = new XMLInstanceElement(childElement, this);
            child.addMinimalSubElements();
            this.addChildInternal(child);
        }
    }

    public synchronized void addChild(XMLInstanceElement pi, boolean addSiblings) {
        this.addChildInternal(pi);
        LinkedList<SchemaElement> childElems = new LinkedList<SchemaElement>();
        for (XMLInstanceElement c : this.children) {
            childElems.add(c.getTemplate());
        }
        if (addSiblings) {
            List<SchemaElement> requiredSisters = pi.getTemplate().getMinimalSisterElementsList(childElems);
            for (SchemaElement sister : requiredSisters) {
                XMLInstanceElement child = new XMLInstanceElement(sister, this);
                this.addChildInternal(child);
                child.addMinimalSubElements();
            }
        }
    }

    private void addChildInternal(XMLInstanceElement pi) {
        List<SchemaElement> allowed = this.template.getNestedElements(new LinkedList<SchemaElement>());
        int curIdx = allowed.indexOf(pi.getTemplate());
        int curPos = 0;
        int i = 0;
        while (i < this.children.size()) {
            int childIdx = allowed.indexOf(this.children.get(i).getTemplate());
            if (childIdx > curIdx) break;
            curPos = i + 1;
            ++i;
        }
        this.children.add(curPos, pi);
    }

    public synchronized void removeChild(XMLInstanceElement pi) {
        this.children.remove(pi);
    }

    public String getAttribute(String name) {
        return this.jdomElement.getAttributeValue(name);
    }

    public void removeAttribute(String name) {
        this.jdomElement.removeAttribute(name);
    }

    public void setAttribute(String name, String value) {
        this.jdomElement.setAttribute(name, value);
    }

    private Map<String, String> getNamespaceMappings() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Namespace ns : this.getAllAdditionalNamespaces()) {
            if (map.containsKey(ns.getPrefix())) continue;
            map.put(ns.getPrefix(), ns.getURI());
        }
        return map;
    }

    public List getAllAdditionalNamespaces() {
        Vector<Namespace> list = new Vector<Namespace>();
        list.addAll(this.jdomElement.getAdditionalNamespaces());
        XMLInstanceElement instParElem = this.parent;
        while (instParElem != null) {
            Element element = instParElem.jdomElement;
            while (element != null) {
                list.add(Namespace.getNamespace((String)element.getNamespacePrefix(), (String)element.getNamespaceURI()));
                list.addAll(element.getAdditionalNamespaces());
                element = element.getParentElement();
            }
            instParElem = instParElem.parent;
        }
        return list;
    }

    public void addNamespaceDeclaration(String prefix, String uri) {
        if (prefix == null || prefix.length() == 0 || uri == null || uri.length() == 0) {
            return;
        }
        for (Namespace ns : this.jdomElement.getAdditionalNamespaces()) {
            if (!prefix.equals(ns.getPrefix())) continue;
            return;
        }
        this.jdomElement.addNamespaceDeclaration(Namespace.getNamespace((String)prefix, (String)uri));
    }

    public void removeNamespaceDeclaration(String prefix, String uri) {
        if (prefix == null || prefix.length() == 0 || uri == null || uri.length() == 0) {
            return;
        }
        this.jdomElement.removeNamespaceDeclaration(Namespace.getNamespace((String)prefix, (String)uri));
    }

    public String getBasedOnSnippet() {
        return XMLInstanceElement.findBasedOn(this.jdomElement);
    }

    public String getDependencyValue(String path) {
        String retValue = null;
        HashMap<String, String> tmpNsMap = new HashMap<String, String>(this.nsMap);
        Attribute attrib = this.getDependencyAttribute(path);
        if (attrib != null) {
            String[] ns2;
            for (String[] ns2 : attrib.getParent().getAdditionalNamespaces()) {
                tmpNsMap.put(ns2.getPrefix(), ns2.getURI());
            }
            retValue = attrib.getValue();
            if (retValue.contains(":") && tmpNsMap.containsKey((ns2 = retValue.split(":", 2))[0])) {
                retValue = QNameHelper.convertToFullName((String)tmpNsMap.get(ns2[0]), ns2[1]);
            }
        }
        return retValue;
    }

    private Attribute getDependencyAttribute(String path) {
        Attribute retAttrib = null;
        if (path == null) {
            return retAttrib;
        }
        if (path.startsWith("../") && this.parent != null) {
            path = path.substring(3);
            retAttrib = this.parent.getDependencyAttribute(path);
        } else if (path.startsWith("@")) {
            retAttrib = this.jdomElement.getAttribute(path.substring(1));
        } else {
            String elemName = "";
            if (path.contains("/")) {
                String[] elements = path.split("/", 2);
                elemName = elements[0];
                path = elements[1];
            } else {
                elemName = path;
            }
            for (XMLInstanceElement element : this.children) {
                if (!element.getJDOMElement().getName().equals(elemName)) continue;
                retAttrib = element.getDependencyAttribute(path);
            }
        }
        return retAttrib;
    }

    public String getDependencyName(String path) {
        String retName = null;
        Attribute attrib = this.getDependencyAttribute(path);
        if (attrib != null) {
            retName = attrib.getName();
        } else if (path.startsWith("@")) {
            retName = path.substring(1);
        }
        return retName;
    }

    public Object getData(Object key) {
        return this.data.get(key);
    }

    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    static String findBasedOn(Element element) {
        Comment derivedComment = XMLInstanceElement.findBasedOnComment(element);
        if (derivedComment != null) {
            return derivedComment.getText().substring(1, derivedComment.getText().length() - 1);
        }
        return null;
    }

    private static Comment findBasedOnComment(Element element) {
        for (Object obj : element.getContent()) {
            if (!(obj instanceof Comment)) continue;
            Comment comment = (Comment)obj;
            String s = comment.getText();
            if (s.startsWith("#") && s.endsWith("#")) {
                return comment;
            }
            return null;
        }
        return null;
    }

    public void setBasedOnSnippet(String origin) {
        Comment oldDerived = XMLInstanceElement.findBasedOnComment(this.jdomElement);
        if (oldDerived != null) {
            this.jdomElement.removeContent((Content)oldDerived);
        }
        Comment newDerived = new Comment("#" + origin + "#");
        this.jdomElement.addContent(0, (Content)newDerived);
    }

    public String getText() {
        return this.jdomElement.getText();
    }

    public void setText(String text) {
        this.jdomElement.setText(text);
    }

    public void setEmbeddedElements(Collection<Element> elements) {
        this.jdomElement.setContent(elements);
    }

    public String getEmbeddedXML() {
        StringBuilder sb = new StringBuilder();
        for (Element el : this.jdomElement.getChildren()) {
            Format format = Format.getPrettyFormat();
            format.setLineSeparator(System.getProperty("line.separator"));
            sb.append(new XMLOutputter(format).outputString(el));
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public void setEmbeddedXML(String xml) {
        SAXBuilder builder = new SAXBuilder();
        try {
            String xmlText = "<root>" + xml + "</root>";
            Document doc = builder.build((InputStream)new ByteArrayInputStream(xmlText.getBytes()));
            this.jdomElement.removeContent();
            for (Element el : new ArrayList(doc.getRootElement().getChildren())) {
                this.jdomElement.addContent(el.detach());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized List<XMLInstanceElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public XMLInstanceElement getParent() {
        return this.parent;
    }

    public SchemaElement getTemplate() {
        return this.template;
    }

    public String getNamespacePrefix() {
        return this.jdomElement.getNamespacePrefix();
    }

    public Element getJDOMElement() {
        Element cur = (Element)this.jdomElement.clone();
        for (XMLInstanceElement child : this.children) {
            cur.addContent((Content)child.getJDOMElement());
        }
        return cur;
    }

    public void setJDOMElement(Element el) {
        this.jdomElement = el;
    }

    public Map<String, String> getNamespaceMap() {
        return this.nsMap;
    }

    public ValidationProblem validate() {
        if (this.getTemplate() == null) {
            return null;
        }
        for (SchemaAttribute attr : this.getTemplate().getAttributes()) {
            String val;
            if (!attr.getRequired() || (val = this.jdomElement.getAttributeValue(attr.getName())) != null && !"".equals(val)) continue;
            return new ValidationProblem(attr, "Required attribute '" + attr.getDisplayName() + "' not set.", this);
        }
        for (XMLInstanceElement child : this.children) {
            ValidationProblem vp = child.validate();
            if (vp == null) continue;
            return vp;
        }
        return null;
    }

    public String toString() {
        String prefix = this.jdomElement.getNamespacePrefix();
        String name = this.jdomElement.getName();
        return prefix == null || prefix.length() == 0 ? name : String.valueOf(prefix) + ":" + name;
    }

    public String getLabel() {
        String label = null;
        if (this.template != null) {
            label = this.template.getDisplayName();
        }
        if (label == null) {
            label = this.toString();
        }
        return label;
    }
}

