/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.policies;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.AssociationTarget;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.MessageVertex;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.commands.CreateRelationshipCommandEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.MessagingEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.BpmnBaseItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolItemSemanticEditPolicy
extends BpmnBaseItemSemanticEditPolicy {
    @Override
    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        CompoundCommand command = new CompoundCommand();
        View view = (View)this.getHost().getModel();
        Pool pool = (Pool)view.getElement();
        IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)this.getHost().getViewer();
        if (pool != null) {
            PoolItemSemanticEditPolicy.destroyMessagingEdges((Graph)pool, viewer, command);
        }
        command.add(this.getMSLWrapper((ICommand)new DestroyElementCommand(req){

            protected EObject getElementToDestroy() {
                View view = (View)PoolItemSemanticEditPolicy.this.getHost().getModel();
                EAnnotation annotation = view.getEAnnotation("Shortcut");
                if (annotation != null) {
                    return view;
                }
                return super.getElementToDestroy();
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IStatus s = super.doUndo(monitor, info);
                return s;
            }
        }));
        return command;
    }

    @Override
    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (BpmnElementTypes.Association_3003.getId().equals(req.getElementType().getId())) {
            return req.getTarget() == null ? null : this.getCreateCompleteIncomingAssociation3003Command(req);
        }
        if (BpmnElementTypes.MessagingEdge_3002.getId().equals(req.getElementType().getId())) {
            return req.getTarget() == null ? this.getCreateStartOutgoingMessagingEdge3002Command(req) : this.getCreateCompleteIncomingMessagingEdge3002Command(req);
        }
        return super.getCreateRelationshipCommand(req);
    }

    protected Command getCreateCompleteIncomingAssociation3003Command(CreateRelationshipRequest req) {
        if (!(req.getSource() instanceof Artifact)) {
            return UnexecutableCommand.INSTANCE;
        }
        final Artifact element = (Artifact)this.getRelationshipContainer(req.getSource(), BpmnPackage.eINSTANCE.getArtifact(), req.getElementType());
        if (element == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (req.getContainmentFeature() == null) {
            req.setContainmentFeature(BpmnPackage.eINSTANCE.getArtifact_Associations());
        }
        for (Object tempA : element.getAssociations()) {
            if (!(tempA instanceof Association)) continue;
            Association association = (Association)tempA;
            if (!((IGraphicalEditPart)this.getHost()).resolveSemanticElement().equals(association.getTarget())) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return this.getMSLWrapper((ICommand)new CreateIncomingAssociation3003Command(req){

            protected EObject getElementToEdit() {
                return element;
            }
        });
    }

    public static void destroyMessagingEdges(Graph graph, IDiagramGraphicalViewer viewer, CompoundCommand command) {
        TreeMap<Integer, Set<MessagingEdge>> sorted = new TreeMap<Integer, Set<MessagingEdge>>(Collections.reverseOrder());
        PoolItemSemanticEditPolicy.sortMessagesByPosition(sorted, graph);
        Iterator<Set<MessagingEdge>> itt = sorted.values().iterator();
        HashSet<MessagingEdge> alreadyRemoved = new HashSet<MessagingEdge>();
        while (itt.hasNext()) {
            for (MessagingEdge me : itt.next()) {
                IGraphicalEditPart mePart;
                alreadyRemoved.add(me);
                DestroyElementRequest req = new DestroyElementRequest((EObject)me, false);
                List editParts = viewer.findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)me), MessagingEdgeEditPart.class);
                if (editParts.isEmpty() || (mePart = (IGraphicalEditPart)editParts.get(0)) == null) continue;
                command.add(mePart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)req)));
            }
        }
    }

    private static void sortMessagesByPosition(TreeMap<Integer, Set<MessagingEdge>> sorted, Graph graph) {
        for (Vertex v : graph.getVertices()) {
            if (v instanceof Graph) {
                PoolItemSemanticEditPolicy.sortMessagesByPosition(sorted, (Graph)v);
            }
            if (!(v instanceof Activity)) continue;
            Activity a = (Activity)v;
            int i = a.getOrderedMessages().size() - 1;
            while (i >= 0) {
                Set<MessagingEdge> mes = sorted.get(i);
                if (mes == null) {
                    mes = new HashSet<MessagingEdge>();
                    sorted.put(i, mes);
                }
                mes.add((MessagingEdge)a.getOrderedMessages().getValue(i));
                --i;
            }
        }
    }

    protected Command getCreateCompleteIncomingMessagingEdge3002Command(CreateRelationshipRequest req) {
        final BpmnDiagram element = (BpmnDiagram)this.getRelationshipContainer(req.getSource(), BpmnPackage.eINSTANCE.getBpmnDiagram(), req.getElementType());
        if (element == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (req.getContainmentFeature() == null) {
            req.setContainmentFeature(BpmnPackage.eINSTANCE.getBpmnDiagram_Messages());
        }
        return this.getMSLWrapper((ICommand)new CreateIncomingMessagingEdge3002Command(req){

            protected EObject getElementToEdit() {
                return element;
            }
        });
    }

    protected Command getCreateStartOutgoingMessagingEdge3002Command(CreateRelationshipRequest req) {
        return new Command(){};
    }

    private static class CreateIncomingAssociation3003Command
    extends CreateRelationshipCommandEx {
        public CreateIncomingAssociation3003Command(CreateRelationshipRequest req) {
            super(req);
        }

        protected EClass getEClassToEdit() {
            return BpmnPackage.eINSTANCE.getArtifact();
        }

        protected void setElementToEdit(EObject element) {
            throw new UnsupportedOperationException();
        }

        protected EObject doDefaultElementCreation() {
            Association newElement = (Association)super.doDefaultElementCreation();
            if (newElement != null) {
                newElement.setTarget((AssociationTarget)this.getTarget());
                newElement.setSource((Artifact)this.getSource());
            }
            return newElement;
        }
    }

    protected static class CreateIncomingMessagingEdge3002Command
    extends CreateRelationshipCommandEx {
        public CreateIncomingMessagingEdge3002Command(CreateRelationshipRequest req) {
            super(req);
        }

        protected EClass getEClassToEdit() {
            return BpmnPackage.eINSTANCE.getBpmnDiagram();
        }

        protected void setElementToEdit(EObject element) {
            throw new UnsupportedOperationException();
        }

        protected EObject doDefaultElementCreation() {
            MessagingEdge newElement = (MessagingEdge)super.doDefaultElementCreation();
            if (newElement != null) {
                newElement.setTarget((MessageVertex)this.getTarget());
                newElement.setSource((MessageVertex)this.getSource());
            }
            return newElement;
        }

        public boolean canExecute() {
            Identifiable container;
            Activity task;
            Activity target;
            if ((this.getSource() instanceof Pool || this.getTarget() instanceof Pool) && this.getSource() != this.getTarget()) {
                return true;
            }
            if (!(this.getSource() instanceof Activity) || !(this.getTarget() instanceof Activity)) {
                return false;
            }
            Activity source = this.getSource() instanceof Activity ? (Activity)this.getSource() : null;
            Activity activity = target = this.getTarget() instanceof Activity ? (Activity)this.getTarget() : null;
            if (source.equals(target)) {
                return false;
            }
            EList tInMessages = target == null ? ECollections.EMPTY_ELIST : target.getIncomingMessages();
            EList tOutMessages = target == null ? ECollections.EMPTY_ELIST : target.getOutgoingMessages();
            EList sInMessages = source == null ? ECollections.EMPTY_ELIST : source.getIncomingMessages();
            EList sOutMessages = source == null ? ECollections.EMPTY_ELIST : source.getOutgoingMessages();
            for (MessagingEdge element : tInMessages) {
                if (element.getSource() == null || !element.getSource().equals(source)) continue;
                return false;
            }
            Identifiable sContainer = this.getSource() instanceof Pool ? (Identifiable)this.getSource() : (Identifiable)source.eContainer();
            while (!(sContainer instanceof Pool)) {
                sContainer = (Identifiable)sContainer.eContainer();
            }
            Identifiable tContainer = this.getTarget() instanceof Pool ? (Identifiable)this.getTarget() : (Identifiable)target.eContainer();
            while (!(tContainer instanceof Pool)) {
                tContainer = (Identifiable)tContainer.eContainer();
            }
            if (sContainer.equals(tContainer)) {
                return false;
            }
            for (MessagingEdge element : tOutMessages) {
                task = (Activity)element.getTarget();
                container = (Identifiable)task.eContainer();
                while (!(container instanceof Pool)) {
                    container = (Identifiable)container.eContainer();
                }
                if (container.equals(sContainer)) continue;
                return false;
            }
            for (MessagingEdge element : tInMessages) {
                task = (Activity)element.getSource();
                container = (Identifiable)task.eContainer();
                while (!(container instanceof Pool)) {
                    container = (Identifiable)container.eContainer();
                }
                if (container.equals(sContainer)) continue;
                return false;
            }
            for (MessagingEdge element : sOutMessages) {
                task = (Activity)element.getTarget();
                container = (Identifiable)task.eContainer();
                while (!(container instanceof Pool)) {
                    container = (Identifiable)container.eContainer();
                }
                if (container.equals(tContainer)) continue;
                return false;
            }
            for (MessagingEdge element : sInMessages) {
                task = (Activity)element.getSource();
                container = (Identifiable)task.eContainer();
                while (!(container instanceof Pool)) {
                    container = (Identifiable)container.eContainer();
                }
                if (container.equals(tContainer)) continue;
                return false;
            }
            if (target != null) {
                switch (target.getActivityType().getValue()) {
                    case 1: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        return false;
                    }
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 30: 
                    case 31: {
                        break;
                    }
                    case 18: 
                    case 23: {
                        if (!target.getOrderedMessages().isEmpty() && target.getOutgoingMessages().contains(((FeatureMap.Entry)target.getOrderedMessages().get(0)).getValue())) break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (source != null) {
                switch (source.getActivityType().getValue()) {
                    case 1: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        return false;
                    }
                    case 0: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 32: {
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 9: 
                    case 15: {
                        if (!source.getOrderedMessages().isEmpty()) {
                            boolean incomingFirst = source.getIncomingMessages().contains(((FeatureMap.Entry)source.getOrderedMessages().get(0)).getValue());
                            FeatureMap.Entry fentry = (FeatureMap.Entry)source.getOrderedMessages().get(0);
                            MessagingEdge firstMsgOfSource = (MessagingEdge)fentry.getValue();
                            if (incomingFirst && firstMsgOfSource.getSource() == target) break;
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
            return super.canExecute();
        }
    }
}

