/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.dnd.file;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.dnd.AbstractEAnnotationDnDHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileDnDHandler
extends AbstractEAnnotationDnDHandler {
    private IResource file;

    public FileDnDHandler(IResource f) {
        this.file = f;
    }

    public Command getDropCommand(IGraphicalEditPart hoverPart, int index, Point dropLocation) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("projectRelativePath", this.file.getProjectRelativePath().toString());
        return this.createEAnnotationDropCommand(this.createAnnotation("genericFile", details), (EModelElement)hoverPart.resolveSemanticElement());
    }

    public int getItemCount() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getMenuItemImage(IGraphicalEditPart hoverPart, int index) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter((Object)this.file, IWorkbenchAdapter.class);
        if (adapter == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        IResource iResource = this.file;
        synchronized (iResource) {
            if (this.cachedImages.get(this.file) == null) {
                this.cachedImages.put(this.file, adapter.getImageDescriptor((Object)this.file).createImage());
            }
        }
        return (Image)this.cachedImages.get(this.file);
    }

    public String getMenuItemLabel(IGraphicalEditPart hoverPart, int index) {
        EObject element = hoverPart.resolveSemanticElement();
        String suffix = BpmnDiagramMessages.bind((String)BpmnDiagramMessages.FileDnDHandler_On, (Object)this.getShapeLabel((NamedBpmnObject)element));
        String path = this.file.getProjectRelativePath().lastSegment().toString();
        return BpmnDiagramMessages.bind((String)BpmnDiagramMessages.FileDnDHandler_AttachFile, (Object)path, (Object)suffix);
    }

    public int getPriority() {
        return 0;
    }

    protected String getShapeLabel(NamedBpmnObject namedElement) {
        String name;
        String string = name = namedElement.getName() != null && namedElement.getName().length() > 0 ? namedElement.getName() : "";
        if (name.length() > 18) {
            name = String.valueOf(name.substring(0, 12)) + "...";
        }
        if (namedElement instanceof Pool) {
            if (name.indexOf("pool") == -1) {
                return "pool " + name;
            }
            return name;
        }
        if (namedElement instanceof Activity) {
            String shape = ((Activity)namedElement).getActivityType().getName();
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof MessagingEdge) {
            String shape = "message";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof SequenceEdge) {
            String shape = "sequence";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof Diagram) {
            String shape = "diagram";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof TextAnnotation) {
            String shape = "annotation";
            if (name.indexOf(shape) == -1) {
                return BpmnDiagramMessages.bind((String)BpmnDiagramMessages.FileDnDHandler_text, (Object)shape, (Object)name);
            }
            return name;
        }
        if (namedElement instanceof DataObject) {
            String shape = "object";
            if (name.indexOf(shape) == -1) {
                return BpmnDiagramMessages.bind((String)BpmnDiagramMessages.FileDnDHandler_data, (Object)shape, (Object)name);
            }
            return name;
        }
        return name;
    }

    public boolean isEnabled(IGraphicalEditPart hoverPart, int index) {
        if (super.isEnabled(hoverPart, index)) {
            EModelElement modelElement = (EModelElement)hoverPart.resolveSemanticElement();
            IFile f = WorkspaceSynchronizer.getFile((Resource)modelElement.eResource());
            return f.getProject().equals((Object)this.file.getProject());
        }
        return false;
    }
}

