/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.export;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.export.IExportImagePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public class ExportImagePage
extends WizardExportResourcesPage
implements IExportImagePage {
    private Text folderText;
    private boolean folderValid;
    private String folder = "";
    private boolean fileNameValid = false;
    private Text fileNameText;
    private String fileName = "image";
    private Combo imageFormatCombo;
    private ImageFileFormat imageFormat = ImageFileFormat.JPG;

    public ExportImagePage(IStructuredSelection sel) {
        super(BpmnDiagramMessages.ExportImagePage_selectDiagramToExport, sel);
        this.setTitle(BpmnDiagramMessages.ExportImagePage_ExportAsImage);
        this.setDescription(BpmnDiagramMessages.ExportImagePage_text);
    }

    private Composite createComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected void createDestinationGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 3);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(BpmnDiagramMessages.ExportImagePage_ExportFolder);
        this.folderText = new Text(composite, 2048);
        this.folderText.setText(this.folder == null ? "" : this.folder);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportImagePage.this.validateFolderText();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.folderText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText(BpmnDiagramMessages.ExportImagePage_BrowseButton);
        button.setLayoutData((Object)WindowUtil.makeButtonData((Button)button));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportImagePage.this.handleBrowseButtonPressed();
            }
        });
        Label fileNameLabel = new Label(composite, 0);
        fileNameLabel.setText(BpmnDiagramMessages.ExportImagePage_ImageFileName);
        this.fileNameText = new Text(composite, 2048);
        this.fileNameText.setText(String.valueOf(this.fileName) + "." + this.imageFormat.getName().toLowerCase());
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportImagePage.this.validateFileNameText();
            }
        });
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.fileNameText.setLayoutData((Object)gridData);
    }

    public void handleEvent(Event event) {
    }

    protected List getTypesToExport() {
        LinkedList<String> types = new LinkedList<String>();
        types.add("bpmn_diagram");
        return types;
    }

    public List getSelectedResources() {
        return super.getSelectedResources();
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Composite composite = this.createComposite((Composite)optionsGroup, 2);
        Label label = new Label(composite, 0);
        label.setText(BpmnDiagramMessages.ExportImagePage_ImageFormat);
        this.imageFormatCombo = new Combo(composite, 12);
        this.imageFormatCombo.setItems(this.getImageFormatItems());
        this.imageFormatCombo.setText(this.imageFormat.getName());
        this.imageFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportImagePage.this.imageFormat = ImageFileFormat.resolveImageFormat((int)ExportImagePage.this.imageFormatCombo.getSelectionIndex());
                ExportImagePage.this.fileNameText.setText(String.valueOf(ExportImagePage.this.fileName) + "." + ExportImagePage.this.imageFormat.getName().toLowerCase());
                ExportImagePage.this.validateFileNameText();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.imageFormatCombo.setLayoutData((Object)gridData);
    }

    private String[] getImageFormatItems() {
        String[] items = new String[ImageFileFormat.VALUES.length];
        int i = 0;
        while (i < ImageFileFormat.VALUES.length) {
            items[i] = ImageFileFormat.VALUES[i].getName();
            ++i;
        }
        return items;
    }

    private void handleBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        dialog.setMessage(BpmnDiagramMessages.ExportImagePage_ExportImage);
        dialog.setText(BpmnDiagramMessages.ExportImagePage_FolderToExportedImage);
        String dirName = this.folderText.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.folderText.setText(selectedDirectory);
        }
    }

    private void validateFolderText() {
        if (this.folderText.getText().equals("")) {
            this.setMessage(null);
            this.folderValid = false;
            return;
        }
        Path path = new Path("");
        if (!path.isValidPath(this.folderText.getText())) {
            this.setErrorMessage(BpmnDiagramMessages.ExportImagePage_InvalidFolder);
            this.folderValid = false;
            return;
        }
        File file = new File(this.folderText.getText());
        if (!file.exists()) {
            this.setErrorMessage(BpmnDiagramMessages.ExportImagePage_FolderDoesNotExist);
            this.folderValid = false;
            return;
        }
        this.folderValid = true;
        this.folder = this.folderText.getText();
        if (this.fileNameValid) {
            this.setMessage(null);
        } else {
            this.validateFileNameText();
        }
    }

    private void validateFileNameText() {
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(this.fileNameText.getText(), 1);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            this.fileNameValid = false;
            return;
        }
        this.fileNameValid = true;
        IPath filePath = new Path(this.fileNameText.getText()).removeFileExtension();
        this.fileName = filePath.toString();
        if (this.folderValid) {
            this.setMessage(null);
        } else {
            this.validateFolderText();
        }
    }

    protected boolean validateSourceGroup() {
        if (this.getSelectedResources().isEmpty()) {
            this.setErrorMessage(BpmnDiagramMessages.ExportImagePage_NeedToSelectOneDiagram);
            return false;
        }
        for (Object res : this.getSelectedResources()) {
            String ext = ((IResource)res).getFileExtension();
            if ("bpmn_diagram".equals(ext)) continue;
            this.setErrorMessage(BpmnDiagramMessages.ExportImagePage_SelectOneDiagramFile);
            return false;
        }
        if (this.getSelectedResources().size() > 1) {
            this.setErrorMessage(BpmnDiagramMessages.ExportImagePage_cannot_select_more_than_one_diagram);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    public IPath getDestinationPath() {
        Path path = new Path(this.folder);
        String fnWithExtension = String.valueOf(this.fileName) + "." + this.imageFormat.getName().toLowerCase();
        return path.append(fnWithExtension);
    }

    public ImageFileFormat getImageFormat() {
        return this.imageFormat;
    }
}

