/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.activities;

import java.lang.reflect.Field;
import java.util.WeakHashMap;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.stp.bpmn.figures.WrapLabelWithToolTip;
import org.eclipse.stp.bpmn.figures.activities.ActivityFigure;

public class ActivityPainter {
    private static int sequenceEdgeTransparency = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getInt(BpmnDiagramPreferenceInitializer.PREF_MSG_LINE_ALPHA);
    private static int messagingEdgeTransparency = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getInt(BpmnDiagramPreferenceInitializer.PREF_SEQ_LINE_ALPHA);
    private static final Border TOOLTIP_BORDER;
    private static Field graphicsField;
    private static Field zoomField;
    private static WeakHashMap<Graphics, Double> _graphicsPrintingObjectsToZoom;

    static {
        BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(BpmnDiagramPreferenceInitializer.PREF_SEQ_LINE_ALPHA)) {
                    sequenceEdgeTransparency = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getInt(BpmnDiagramPreferenceInitializer.PREF_SEQ_LINE_ALPHA);
                } else if (event.getProperty().equals(BpmnDiagramPreferenceInitializer.PREF_MSG_LINE_ALPHA)) {
                    messagingEdgeTransparency = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getInt(BpmnDiagramPreferenceInitializer.PREF_MSG_LINE_ALPHA);
                }
            }
        });
        TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                Rectangle r = figure.getBounds();
                graphics.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
            }
        };
        _graphicsPrintingObjectsToZoom = new WeakHashMap();
    }

    public static boolean isBPMN11On() {
        return BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("bpmn.1.1.style");
    }

    public static int getSequenceEdgeTransparency() {
        return sequenceEdgeTransparency;
    }

    public static int getMessagingEdgeTransparency() {
        return messagingEdgeTransparency;
    }

    public static void paint(Graphics graphics, ActivityFigure fig) {
        graphics.setBackgroundColor(fig.getBackgroundColor());
        graphics.setForegroundColor(fig.getForegroundColor());
        PrecisionRectangle innerRect = null;
        switch (fig.getActivityType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 30: {
                innerRect = ActivityPainter.paintEventStart(graphics, fig);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: {
                innerRect = ActivityPainter.paintEventIntermediate(graphics, fig);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 32: {
                innerRect = ActivityPainter.paintEventEnd(graphics, fig);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                innerRect = ActivityPainter.paintGateway(graphics, fig);
            }
        }
        switch (fig.getActivityType()) {
            case 2: {
                break;
            }
            case 3: {
                ActivityPainter.paintMessage(graphics, fig, innerRect);
                break;
            }
            case 4: {
                ActivityPainter.paintRule(graphics, fig);
                break;
            }
            case 6: {
                ActivityPainter.paintLink(graphics, fig, innerRect);
                break;
            }
            case 7: {
                if (ActivityPainter.isBPMN11On()) {
                    ActivityPainter.paintPentagon(graphics, fig, innerRect);
                    break;
                }
                ActivityPainter.paintStar(graphics, fig, innerRect);
                break;
            }
            case 5: {
                ActivityPainter.paintTimer(graphics, fig, innerRect);
                break;
            }
            case 12: {
                ActivityPainter.paintCompensation(graphics, fig, innerRect);
                break;
            }
            case 8: {
                break;
            }
            case 11: {
                ActivityPainter.paintError(graphics, fig);
                break;
            }
            case 9: {
                ActivityPainter.paintMessage(graphics, fig, innerRect);
                break;
            }
            case 13: {
                ActivityPainter.paintRule(graphics, fig);
                break;
            }
            case 10: {
                ActivityPainter.paintTimer(graphics, fig, innerRect);
                break;
            }
            case 16: {
                ActivityPainter.paintCancelX(graphics, fig, innerRect);
                break;
            }
            case 14: {
                ActivityPainter.paintLink(graphics, fig, innerRect);
                break;
            }
            case 15: {
                if (ActivityPainter.isBPMN11On()) {
                    ActivityPainter.paintPentagon(graphics, fig, innerRect);
                    break;
                }
                ActivityPainter.paintStar(graphics, fig, innerRect);
                break;
            }
            case 20: {
                ActivityPainter.paintCompensation(graphics, fig, innerRect);
                break;
            }
            case 17: {
                break;
            }
            case 19: {
                ActivityPainter.paintError(graphics, fig);
                break;
            }
            case 18: {
                ActivityPainter.paintMessage(graphics, fig, innerRect);
                break;
            }
            case 21: {
                ActivityPainter.paintTerminate(graphics, fig, innerRect);
                break;
            }
            case 24: {
                ActivityPainter.paintCancelX(graphics, fig, innerRect);
                break;
            }
            case 23: {
                if (ActivityPainter.isBPMN11On()) {
                    ActivityPainter.paintPentagon(graphics, fig, innerRect);
                    break;
                }
                ActivityPainter.paintStar(graphics, fig, innerRect);
                break;
            }
            case 22: {
                ActivityPainter.paintLink(graphics, fig, innerRect);
                break;
            }
            case 25: {
                ActivityPainter.paintGatewayX(graphics, fig, innerRect);
                break;
            }
            case 27: {
                ActivityPainter.paintBoldOval(graphics, fig, innerRect);
                break;
            }
            case 26: {
                if (ActivityPainter.isBPMN11On()) {
                    ActivityPainter.paintBpmn11EvendBasedGateway(graphics, fig, innerRect);
                    break;
                }
                ActivityPainter.paintStar(graphics, fig, innerRect);
                break;
            }
            case 28: {
                ActivityPainter.paintPlus(graphics, fig, innerRect);
                break;
            }
            case 29: {
                ActivityPainter.paintComplex(graphics, fig, innerRect);
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                ActivityPainter.paintSignal(graphics, fig, innerRect);
            }
        }
        if (fig.isLooping()) {
            ActivityPainter.paintLoopInsideFigure(graphics, fig.getBounds(), (IFigure)fig);
        }
    }

    public static void paintPentagon(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        ActivityPainter.paintPentagon(graphics, !fig.isCatching(), innerRect);
    }

    public static void paintPentagon(Graphics graphics, boolean fill, PrecisionRectangle innerRect) {
        double innerWidth = (double)innerRect.width / Math.sqrt(2.0);
        double innerx = (innerRect.preciseWidth - innerWidth) / 2.0;
        PrecisionRectangle rect = new PrecisionRectangle();
        rect.setWidth(innerWidth);
        rect.setHeight(innerWidth - innerWidth / 5.0);
        rect.setX(innerRect.preciseX + innerx);
        rect.setY(innerRect.preciseY + innerx + innerWidth / 10.0);
        PointList pl = new PointList();
        pl.addPoint(new Point(rect.getTopLeft().x, rect.getTopLeft().y + rect.height / 3));
        pl.addPoint(rect.getTop());
        pl.addPoint(new Point(rect.getTopRight().x, rect.getTopRight().y + rect.height / 3));
        pl.addPoint(new Point(rect.getBottomRight().x - rect.width / 6, rect.getBottomRight().y));
        pl.addPoint(new Point(rect.getBottomLeft().x + rect.width / 6, rect.getBottomLeft().y));
        graphics.pushState();
        if (fill) {
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.fillPolygon(pl);
        } else {
            graphics.drawPolygon(pl);
        }
        graphics.popState();
    }

    public static PrecisionRectangle paintGateway(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        int lineWidth = MapModeUtil.getMapMode((IFigure)fig).LPtoDP(2);
        graphics.setLineWidth(lineWidth);
        PrecisionRectangle r = ActivityPainter.calcInnerRectangle(fig.getBounds().getCopy(), lineWidth);
        PointList pointList = new PointList();
        pointList.addPoint(r.x + r.width / 2, r.y);
        pointList.addPoint(r.x + r.width, r.y + r.height / 2);
        pointList.addPoint(r.x + r.width / 2, r.y + r.height);
        pointList.addPoint(r.x, r.y + r.height / 2);
        graphics.fillPolygon(pointList);
        graphics.drawPolygon(pointList);
        graphics.popState();
        return r;
    }

    public static PrecisionRectangle paintEventStart(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle rect = fig.getBounds().getCopy();
        graphics.fillOval(rect);
        graphics.setLineWidth(MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1));
        PrecisionRectangle outerCircle = ActivityPainter.calcInnerRectangle(rect, graphics.getLineWidth());
        PrecisionRectangle precRect = outerCircle.getPreciseCopy();
        ActivityPainter.shrink(precRect, outerCircle.preciseWidth / 12.0, outerCircle.preciseHeight / 12.0);
        outerCircle = precRect.getPreciseCopy();
        ActivityPainter.shrink(outerCircle, -outerCircle.preciseWidth / 12.0, -outerCircle.preciseHeight / 12.0);
        graphics.drawOval((Rectangle)outerCircle);
        graphics.popState();
        return precRect;
    }

    private static PrecisionRectangle calcInnerRectangle(Rectangle rect, int lineWidth) {
        PrecisionRectangle newRect = new PrecisionRectangle(rect);
        double halfLineWidth = (double)lineWidth / 2.0;
        newRect.setX(newRect.preciseX + halfLineWidth);
        newRect.setY(newRect.preciseY + halfLineWidth);
        newRect.setWidth(newRect.preciseWidth - (double)lineWidth);
        newRect.setHeight(newRect.preciseHeight - (double)lineWidth);
        return newRect;
    }

    public static PrecisionRectangle paintEventIntermediate(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle rect = fig.getBounds().getCopy();
        graphics.fillOval(rect);
        graphics.setLineWidth(1);
        PrecisionRectangle outerCircle = ActivityPainter.calcInnerRectangle(rect, graphics.getLineWidth());
        PrecisionRectangle innerCircle = outerCircle.getPreciseCopy();
        double ddW = outerCircle.preciseWidth / 10.0;
        double ddH = outerCircle.preciseHeight / 10.0;
        ActivityPainter.shrink(innerCircle, ddW, ddH);
        graphics.drawOval((Rectangle)innerCircle);
        graphics.drawOval((Rectangle)outerCircle);
        graphics.popState();
        return innerCircle;
    }

    public static PrecisionRectangle paintEventEnd(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        double lineWidth = (double)fig.getBounds().width * ActivityPainter.getAbsoluteScale(graphics) / 10.0;
        graphics.setLineWidth((int)Math.floor(lineWidth));
        PrecisionRectangle outerCircle = new PrecisionRectangle(fig.getBounds());
        ActivityPainter.shrink(outerCircle, lineWidth / 2.0, lineWidth / 2.0);
        graphics.fillOval((Rectangle)outerCircle);
        graphics.drawOval((Rectangle)outerCircle);
        graphics.popState();
        ActivityPainter.shrink(outerCircle, outerCircle.preciseWidth / 10.0, outerCircle.preciseHeight / 10.0);
        return outerCircle;
    }

    public static void paintTerminate(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.darkGray);
        ActivityPainter.shrink(innerRect, innerRect.preciseWidth / 4.5, innerRect.preciseHeight / 4.5, false);
        if ((double)innerRect.width - Math.floor(innerRect.width) >= 0.5) {
            innerRect.x = innerRect.x + 1;
        }
        if ((double)innerRect.height - Math.floor(innerRect.height) >= 0.5) {
            innerRect.y = innerRect.y + 1;
        }
        innerRect.updateInts();
        graphics.fillOval((Rectangle)innerRect);
        graphics.popState();
    }

    public static void paintMessage(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        int lineWidth = MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1);
        ActivityPainter.paintMessage(graphics, innerRect, lineWidth, fig.isCatching());
    }

    public static void paintMessage(Graphics graphics, PrecisionRectangle innerRect, int lineWidth) {
        ActivityPainter.paintMessage(graphics, innerRect, lineWidth, false);
    }

    public static void paintMessage(Graphics graphics, PrecisionRectangle innerRect, int lineWidth, boolean isCatching) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setLineWidth(lineWidth);
        ActivityPainter.shrink(innerRect, innerRect.preciseWidth / 6.0, innerRect.preciseHeight / 4.5);
        if (!isCatching && ActivityPainter.isBPMN11On()) {
            graphics.fillRectangle((Rectangle)innerRect);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setLineWidth(graphics.getLineWidth());
        } else {
            graphics.drawRectangle((Rectangle)innerRect);
        }
        graphics.drawPolyline(new int[]{innerRect.getTopLeft().x, innerRect.getTopLeft().y, innerRect.getCenter().x, innerRect.getCenter().y, innerRect.getTopRight().x, innerRect.getTopRight().y});
        graphics.popState();
    }

    public static void paintCompensation(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        double innerWidth = (double)innerRect.width / Math.sqrt(2.0);
        double innerx = (innerRect.preciseWidth - innerWidth) / 2.0;
        innerRect.setWidth(innerWidth);
        innerRect.setHeight(innerWidth);
        innerRect.setX(innerRect.preciseX + innerx / 2.0);
        innerRect.setY(innerRect.preciseY + innerx);
        int lineWidth = MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1);
        ActivityPainter.paintCompensation(graphics, (Rectangle)innerRect, lineWidth, fig.isCatching());
    }

    public static void paintCompensation(Graphics graphics, Rectangle rect, int lineWidth) {
        ActivityPainter.paintCompensation(graphics, rect, lineWidth, false);
    }

    public static void paintCompensation(Graphics graphics, Rectangle rect, int lineWidth, boolean isCatching) {
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.darkGray);
        graphics.setForegroundColor(ColorConstants.darkGray);
        PointList pl = new PointList(3);
        pl.addPoint(rect.getLeft().getCopy());
        pl.addPoint(rect.getTop().getCopy());
        pl.addPoint(rect.getBottom().getCopy());
        if (isCatching && ActivityPainter.isBPMN11On()) {
            graphics.setLineWidth(2 * lineWidth);
            graphics.drawPolygon(pl);
        } else {
            graphics.fillPolygon(pl);
        }
        pl = new PointList(3);
        pl.addPoint(rect.getCenter());
        pl.addPoint(rect.getTopRight());
        pl.addPoint(rect.getBottomRight());
        if (isCatching && ActivityPainter.isBPMN11On()) {
            graphics.drawPolygon(pl);
        } else {
            graphics.fillPolygon(pl);
        }
        graphics.popState();
    }

    public static void paintTimer(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        int lineWidth = MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1);
        PrecisionRectangle rect = innerRect;
        ActivityPainter.shrink(rect, (double)lineWidth / 2.0, (double)lineWidth / 2.0);
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setLineWidth(lineWidth);
        ActivityPainter.shrink(rect, rect.preciseWidth / 6.0, rect.preciseHeight / 6.0);
        graphics.drawOval((Rectangle)rect);
        ActivityPainter.shrink(rect, (double)lineWidth / 2.0, (double)lineWidth / 2.0);
        double a = rect.preciseWidth / 2.0;
        double b = rect.preciseHeight / 2.0;
        double x0 = rect.preciseX + a;
        double y0 = rect.preciseY + b;
        double RATIO = 0.8;
        int i = 0;
        while (i < 12) {
            int angleGrad = i * 30;
            double x = a * Math.cos(Math.toRadians(angleGrad));
            double y = b * Math.sin(Math.toRadians(angleGrad));
            PrecisionPoint pp1 = new PrecisionPoint(x0 + x * 0.8, y0 + y * 0.8);
            PrecisionPoint pp2 = new PrecisionPoint(x0 + x, y0 + y);
            graphics.drawLine((Point)pp1, (Point)pp2);
            ++i;
        }
        PrecisionPoint center = new PrecisionPoint(x0, y0);
        PrecisionPoint bigHand = new PrecisionPoint(rect.preciseX, rect.preciseY);
        bigHand.preciseX += 11.0 * rect.preciseWidth / 18.0;
        bigHand.preciseY += 3.0 * rect.preciseHeight / 24.0;
        bigHand.updateInts();
        graphics.drawLine((Point)center, (Point)bigHand);
        PrecisionPoint littleHand = new PrecisionPoint(x0, y0);
        littleHand.preciseX += 3.0 * rect.preciseWidth / 10.0;
        littleHand.preciseY -= 1.0 * rect.preciseHeight / 24.0;
        littleHand.updateInts();
        graphics.drawLine((Point)center, (Point)littleHand);
        graphics.popState();
    }

    private static final void shrink(PrecisionRectangle rect, double w, double h) {
        ActivityPainter.shrink(rect, w, h, true);
    }

    private static final void shrink(PrecisionRectangle rect, double w, double h, boolean shouldUpdateInts) {
        rect.setX(rect.preciseX + w);
        rect.setY(rect.preciseY + h);
        rect.setWidth(rect.preciseWidth - 2.0 * w);
        rect.setHeight(rect.preciseHeight - 2.0 * h);
        if (shouldUpdateInts) {
            rect.updateInts();
        }
    }

    public static void paintError(Graphics graphics, ActivityFigure fig) {
        Rectangle rect = fig.getBounds().getCopy();
        rect.shrink(rect.width / 4, rect.height / 4);
        ActivityPainter.paintError(graphics, rect, MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1), fig.isCatching());
    }

    public static void paintError(Graphics graphics, Rectangle rect, int lineWidth) {
        ActivityPainter.paintError(graphics, rect, lineWidth, false);
    }

    public static void paintError(Graphics graphics, Rectangle rect, int lineWidth, boolean isCatching) {
        graphics.pushState();
        graphics.setLineWidth(lineWidth);
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        Point one = rect.getTopLeft().translate(1 * rect.width / 4, 1 * rect.height / 4);
        Point onebis = one.getCopy().translate(1 * rect.width / 7, 1 * rect.height / 7);
        Point two = rect.getTopLeft().translate(3 * rect.width / 4, 3 * rect.height / 4);
        Point twobis = two.getCopy().translate(-1 * rect.width / 7, -1 * rect.height / 7);
        int lineW = (int)Math.floor(rect.height / 8);
        onebis.y += lineW;
        twobis.y -= lineW;
        PointList pl = new PointList(6);
        pl.addPoint(rect.getBottomLeft());
        pl.addPoint(onebis);
        pl.addPoint(two);
        pl.addPoint(rect.getTopRight());
        pl.addPoint(twobis);
        pl.addPoint(one);
        if (isCatching && ActivityPainter.isBPMN11On()) {
            graphics.drawPolygon(pl);
        } else {
            graphics.fillPolygon(pl);
        }
        graphics.popState();
    }

    public static void paintRule(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        Rectangle rect = fig.getBounds().getCopy();
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setLineWidth((int)Math.floor(2 * Math.max(rect.width, rect.height) / 22));
        graphics.drawRectangle(rect.shrink(graphics.getLineWidth() / 2 + rect.width * 12 / 44, graphics.getLineWidth() / 2 + rect.height / 4));
        graphics.setLineWidth((int)Math.floor(Math.max(rect.width, rect.height) / 22));
        rect.shrink(graphics.getLineWidth(), graphics.getLineWidth() * 4);
        int i = 0;
        while (i < 5) {
            graphics.drawLine(rect.getTopLeft().translate(0, i * rect.width / 5), rect.getTopRight().translate(0, i * rect.width / 5));
            ++i;
        }
        graphics.popState();
    }

    public static void paintStar(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        Rectangle rect = fig.getBounds().getCopy();
        graphics.setBackgroundColor(ColorConstants.darkGray);
        graphics.setForegroundColor(ColorConstants.darkGray);
        if (fig.getActivityType() == 26) {
            int lineWidth = 1;
            PrecisionRectangle inner = new PrecisionRectangle((Rectangle)innerRect);
            inner.preciseWidth = 1.414 * (double)rect.width / 2.0;
            inner.preciseHeight = 1.414 * (double)rect.height / 2.0;
            inner.preciseX = (double)rect.x + (double)rect.width * 0.5857864399999999 / 4.0;
            inner.preciseY = (double)rect.y + (double)rect.height * 0.5857864399999999 / 4.0;
            inner.updateInts();
            inner = ActivityPainter.calcInnerRectangle((Rectangle)inner, lineWidth);
            PrecisionRectangle precRect = inner.getPreciseCopy();
            ActivityPainter.shrink(precRect, 2.0 * inner.preciseWidth / 12.0, 2.0 * inner.preciseHeight / 12.0);
            inner = precRect.getPreciseCopy();
            ActivityPainter.shrink(inner, -3.0 * inner.preciseWidth / 24.0, -3.0 * inner.preciseHeight / 24.0);
            graphics.drawOval((Rectangle)precRect);
            graphics.drawOval((Rectangle)inner);
            precRect = ActivityPainter.calcInnerRectangle((Rectangle)precRect, lineWidth);
            ActivityPainter.shrink(precRect, precRect.preciseWidth / 6.0, precRect.preciseHeight / 5.0);
            rect = precRect.getCopy();
        } else {
            rect.shrink(rect.width / 5, rect.height / 4);
        }
        rect.translate(0, -1 * rect.height / 5);
        PointList pl = new PointList(3);
        pl.addPoint(rect.getTop());
        pl.addPoint(rect.getBottomLeft());
        pl.addPoint(rect.getBottomRight());
        graphics.fillPolygon(pl);
        rect.translate(0, 2 * rect.height / 5);
        pl = new PointList(3);
        pl.addPoint(rect.getBottom());
        pl.addPoint(rect.getTopRight());
        pl.addPoint(rect.getTopLeft());
        graphics.fillPolygon(pl);
        graphics.popState();
    }

    static PointList getStarPolygon(double radius, double rotation) {
        PointList pointList = new PointList(10);
        double radius2 = radius * Math.sin(0.3141592653589793) / Math.cos(0.6283185307179586);
        int i = 0;
        while (i < 5) {
            double xAngle = Math.PI * 2 * (double)i / 5.0 + rotation - 1.5707963267948966;
            float x1 = (float)(radius * Math.cos(xAngle));
            float y1 = (float)(radius * Math.sin(xAngle));
            Point point1 = new Point(Math.round(x1), Math.round(y1));
            pointList.addPoint(point1);
            double xAngle2 = xAngle + 0.6283185307179586;
            float x2 = (float)(radius2 * Math.cos(xAngle2));
            float y2 = (float)(radius2 * Math.sin(xAngle2));
            Point point2 = new Point(Math.round(x2), Math.round(y2));
            pointList.addPoint(point2);
            ++i;
        }
        return pointList;
    }

    public static void paintGatewayX(Graphics graphics, ActivityFigure fig, PrecisionRectangle rect) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        double lineWidth = rect.preciseWidth * ActivityPainter.getAbsoluteScale(graphics) / 6.0;
        ActivityPainter.shrink(rect, 3.0 * rect.preciseWidth / 8.0, 3.0 * rect.preciseHeight / 8.0);
        try {
            graphics.setLineCap(3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        graphics.setLineWidth((int)Math.floor(lineWidth * 0.95));
        graphics.drawLine(rect.getTopLeft(), rect.getBottomRight());
        graphics.drawLine(rect.getTopRight(), rect.getBottomLeft());
        graphics.popState();
    }

    public static void paintComplex(Graphics graphics, ActivityFigure fig, PrecisionRectangle rect) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        double lineWidth = rect.preciseWidth * ActivityPainter.getAbsoluteScale(graphics) / 6.0;
        ActivityPainter.shrink(rect, 3.0 * rect.preciseWidth / 9.5, 3.0 * rect.preciseHeight / 9.5);
        graphics.setLineWidth((int)Math.floor(lineWidth * 0.6));
        graphics.drawLine(rect.getTopLeft(), rect.getBottomRight());
        graphics.drawLine(rect.getTopRight(), rect.getBottomLeft());
        ActivityPainter.shrink(rect, 1.2 * rect.preciseWidth, 1.2 * rect.preciseHeight);
        graphics.drawLine(rect.getLeft(), rect.getRight());
        graphics.drawLine(rect.getTop(), rect.getBottom());
        graphics.popState();
    }

    public static void paintCancelX(Graphics graphics, ActivityFigure fig, PrecisionRectangle rect) {
        ActivityPainter.paintCancelX(graphics, rect, MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1), fig.isCatching() && ActivityPainter.isBPMN11On());
    }

    public static void paintCancelX(Graphics graphics, PrecisionRectangle rect, int lineWidth, boolean isCatching) {
        graphics.setLineWidth(lineWidth);
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        double lineW = rect.preciseWidth / 4.0;
        ActivityPainter.shrink(rect, 3.0 * rect.preciseWidth / 15.0, 3.0 * rect.preciseHeight / 15.0);
        if (isCatching) {
            int half = (int)(lineW / 2.0);
            PointList pointList = new PointList();
            pointList.addPoint(rect.getTopLeft().getCopy().translate(-half, half));
            pointList.addPoint(rect.getTopLeft().getCopy().translate(half, -half));
            pointList.addPoint(rect.getTop().getCopy().translate(0, half));
            pointList.addPoint(rect.getTopRight().getCopy().translate(-half, -half));
            pointList.addPoint(rect.getTopRight().getCopy().translate(half, half));
            pointList.addPoint(rect.getRight().getCopy().translate(-half, 0));
            pointList.addPoint(rect.getBottomRight().getCopy().translate(half, -half));
            pointList.addPoint(rect.getBottomRight().getCopy().translate(-half, half));
            pointList.addPoint(rect.getBottom().getCopy().translate(0, -half));
            pointList.addPoint(rect.getBottomLeft().getCopy().translate(half, half));
            pointList.addPoint(rect.getBottomLeft().getCopy().translate(-half, -half));
            pointList.addPoint(rect.getLeft().getCopy().translate(half, 0));
            graphics.drawPolygon(pointList);
        } else {
            graphics.setLineWidth((int)Math.floor(lineW *= ActivityPainter.getAbsoluteScale(graphics)));
            graphics.drawLine(rect.getTopLeft(), rect.getBottomRight());
            graphics.drawLine(rect.getTopRight(), rect.getBottomLeft());
        }
        graphics.popState();
    }

    public static void paintPlus(Graphics graphics, ActivityFigure fig, PrecisionRectangle rect) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        double lineWidth = rect.preciseWidth * ActivityPainter.getAbsoluteScale(graphics) / 6.0;
        ActivityPainter.shrink(rect, 5.0 * rect.preciseWidth / 16.0, 5.0 * rect.preciseHeight / 16.0);
        try {
            graphics.setLineCap(3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        graphics.setLineWidth((int)Math.floor(lineWidth));
        graphics.drawLine(rect.getTop(), rect.getBottom());
        graphics.drawLine(rect.getLeft(), rect.getRight());
        graphics.popState();
    }

    public static void paintLink(Graphics graphics, ActivityFigure fig, PrecisionRectangle rect) {
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.darkGray);
        graphics.setForegroundColor(ColorConstants.darkGray);
        double shrinkX = rect.preciseWidth / 32.0;
        ActivityPainter.shrink(rect, 4.0 * shrinkX, 2.0 * rect.preciseHeight / 14.0);
        double widthOfArrow = shrinkX + rect.preciseX + rect.preciseWidth * 6.0 / 11.0;
        int[] points = new int[]{(int)Math.round(shrinkX + rect.preciseX), (int)Math.round(rect.preciseY + rect.preciseHeight / 5.0), (int)Math.round(widthOfArrow), (int)Math.round(rect.preciseY + rect.preciseHeight / 5.0), (int)Math.round(widthOfArrow), (int)Math.round(rect.preciseY), (int)Math.round(shrinkX + rect.preciseX + rect.preciseWidth), (int)Math.round(rect.preciseY + rect.preciseHeight / 2.0), (int)Math.round(widthOfArrow), (int)Math.round(rect.preciseY + rect.preciseHeight), (int)Math.round(widthOfArrow), (int)Math.round(rect.preciseY + rect.preciseHeight * 4.0 / 5.0), (int)Math.round(shrinkX + rect.preciseX), (int)Math.round(rect.preciseY + rect.preciseHeight * 4.0 / 5.0)};
        if (fig.isCatching()) {
            graphics.drawPolygon(points);
        } else {
            graphics.fillPolygon(points);
        }
        graphics.popState();
    }

    public static void paintBoldOval(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        PrecisionRectangle rect = innerRect;
        graphics.setForegroundColor(ColorConstants.darkGray);
        int orih = rect.height;
        int oriw = rect.width;
        Rectangle rr = rect.getCopy().shrink(11 * oriw / 44, 11 * orih / 44);
        graphics.setLineWidth((int)Math.round(ActivityPainter.getAbsoluteScale(graphics) * (double)rr.width / 8.0));
        graphics.drawOval(rr);
        graphics.popState();
    }

    public static PrecisionRectangle getLoopMarkerBounds(Rectangle figureRect) {
        double RATIO = 5.0;
        double loopHeight = (double)figureRect.height / 5.0;
        double loopWidth = Math.min(loopHeight, (double)figureRect.width);
        double loopX = (double)figureRect.x + ((double)figureRect.width - loopWidth) / 2.0;
        double loopY = (double)(figureRect.y + figureRect.height) - loopHeight;
        PrecisionRectangle bounds = new PrecisionRectangle();
        bounds.setX(loopX);
        bounds.setY(loopY);
        bounds.setWidth(loopWidth);
        bounds.setHeight(loopHeight);
        return bounds;
    }

    public static void paintLoopInsideFigure(Graphics graphics, Rectangle figureRect, IFigure fig) {
        PrecisionRectangle loopRect = ActivityPainter.getLoopMarkerBounds(figureRect);
        ActivityPainter.paintLoop(graphics, loopRect, fig);
    }

    public static void paintLoopMultipleInstance(Graphics graphics, Rectangle loopRect) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        int dx = loopRect.width / 4;
        int dy = loopRect.width / 10;
        PointList pl = new PointList(4);
        pl.addPoint(loopRect.x + dx, loopRect.y + dy);
        pl.addPoint(loopRect.x + 2 * dx, loopRect.y + dy);
        pl.addPoint(loopRect.x + 2 * dx, loopRect.y + 9 * dy);
        pl.addPoint(loopRect.x + dx, loopRect.y + 9 * dy);
        graphics.fillPolygon(pl);
        pl.translate(2 * dx, 0);
        graphics.fillPolygon(pl);
        graphics.popState();
    }

    public static void paintLoop(Graphics graphics, PrecisionRectangle loopRect, IFigure fig) {
        graphics.pushState();
        graphics.setLineWidth(MapModeUtil.getMapMode((IFigure)fig).LPtoDP(2));
        int angleGrad = 30;
        graphics.drawArc((Rectangle)loopRect, -(90 - angleGrad), 360 - 2 * angleGrad);
        double dx = loopRect.preciseWidth / 2.0 * Math.cos(Math.toRadians(90 - angleGrad));
        double dy = loopRect.preciseHeight / 2.0 * Math.sin(Math.toRadians(90 - angleGrad));
        double endX = loopRect.preciseX + loopRect.preciseWidth / 2.0 - dx;
        double endY = loopRect.preciseY + loopRect.preciseHeight / 2.0 + dy;
        double length = endX - loopRect.preciseX;
        PrecisionPoint pp1 = new PrecisionPoint(loopRect.preciseX, endY);
        PrecisionPoint pp2 = new PrecisionPoint(endX, endY);
        graphics.drawLine((Point)pp1, (Point)pp2);
        PrecisionPoint pp3 = new PrecisionPoint(endX, endY - length);
        graphics.drawLine((Point)pp2, (Point)pp3);
        graphics.popState();
    }

    public static IFigure createToolTipFigure(String message) {
        if (message == null || message.length() == 0) {
            return null;
        }
        FlowPage fp = new FlowPage(){

            public Dimension getPreferredSize(int w, int h) {
                Dimension d = super.getPreferredSize(-1, -1);
                if (d.width > 150) {
                    d = super.getPreferredSize(150, -1);
                }
                return d;
            }
        };
        fp.setOpaque(true);
        fp.setBorder(TOOLTIP_BORDER);
        fp.setBackgroundColor(ColorConstants.yellow);
        TextFlow tf = new TextFlow();
        tf.setText(message);
        fp.add((IFigure)tf);
        return fp;
    }

    public static WrapLabelWithToolTip.IToolTipProvider createToolTipProvider(final NamedBpmnObject bpmnObj, final boolean toolTipOnlyWhenTruncated) {
        final boolean isActivity = bpmnObj instanceof Activity;
        return new WrapLabelWithToolTip.IToolTipProvider(){

            public String getToolTipText(boolean currentTextIsTruncated) {
                if (toolTipOnlyWhenTruncated) {
                    if (currentTextIsTruncated) {
                        if (isActivity) {
                            String r = bpmnObj.getName();
                            if (r == null) {
                                return ((Activity)bpmnObj).getActivityType().getName();
                            }
                            return r;
                        }
                        return bpmnObj.getName();
                    }
                    return null;
                }
                if (isActivity) {
                    return bpmnObj.getName();
                }
                return BpmnDiagramMessages.ActivityPainter_unknown_label;
            }
        };
    }

    public static void paintBpmn11EvendBasedGateway(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        PrecisionRectangle ovalCopy = new PrecisionRectangle();
        double fixedDelta = innerRect.preciseWidth / 12.0;
        double delta = (innerRect.preciseWidth * (1.0 - 1.0 / Math.sqrt(2.0)) + fixedDelta) / 2.0;
        ovalCopy.setX(innerRect.preciseX + delta);
        ovalCopy.setY(innerRect.preciseY + delta);
        ovalCopy.setWidth(innerRect.preciseWidth / Math.sqrt(2.0) - fixedDelta);
        ovalCopy.setHeight(ovalCopy.preciseWidth);
        graphics.drawOval((Rectangle)ovalCopy);
        fixedDelta = innerRect.preciseWidth / 6.0;
        delta = (innerRect.preciseWidth * (1.0 - 1.0 / Math.sqrt(2.0)) + fixedDelta) / 2.0;
        ovalCopy.setX(innerRect.preciseX + delta);
        ovalCopy.setY(innerRect.preciseY + delta);
        ovalCopy.setWidth(innerRect.preciseWidth / Math.sqrt(2.0) - fixedDelta);
        ovalCopy.setHeight(ovalCopy.preciseWidth);
        graphics.drawOval((Rectangle)ovalCopy);
        ActivityPainter.paintPentagon(graphics, false, ovalCopy);
    }

    public static void paintSignal(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        double innerWidth = (double)innerRect.width / Math.sqrt(2.0);
        innerWidth = Math.round(innerWidth);
        double innerx = (innerRect.preciseWidth - innerWidth) / 2.0;
        innerRect.setWidth(innerWidth);
        innerRect.setHeight(innerWidth);
        innerRect.setX(innerRect.preciseX + innerx);
        innerRect.setY(innerRect.preciseY + innerx);
        PointList pl = new PointList();
        pl.addPoint(innerRect.getTop().getCopy());
        pl.addPoint(innerRect.getBottomRight().getCopy());
        pl.addPoint(innerRect.getBottomLeft().getCopy());
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setForegroundColor(ColorConstants.black);
        if (fig.isCatching()) {
            graphics.drawPolygon(pl);
        } else {
            graphics.fillPolygon(pl);
        }
        graphics.popState();
    }

    private static void init() {
        if (graphicsField != null) {
            return;
        }
        try {
            graphicsField = org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics.class.getDeclaredField("graphics");
            graphicsField.setAccessible(true);
            zoomField = ScaledGraphics.class.getDeclaredField("zoom");
            zoomField.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static Graphics getWrappedGraphics(org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics scaledGraphics) {
        try {
            return (Graphics)graphicsField.get(scaledGraphics);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static double getZoom(ScaledGraphics scaledGraphics) {
        try {
            return zoomField.getDouble(scaledGraphics);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 1.0 / scaledGraphics.getAbsoluteScale();
    }

    public static double getAbsoluteScale(Graphics graphics) {
        Double zoom = _graphicsPrintingObjectsToZoom.get(graphics);
        double scale = graphics.getAbsoluteScale();
        if (zoom != null) {
            if (zoom == Double.NEGATIVE_INFINITY) {
                return scale;
            }
            return scale / zoom;
        }
        if (scale != 1.0 && graphics instanceof org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics) {
            ActivityPainter.init();
            Graphics wrapped = ActivityPainter.getWrappedGraphics((org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics)graphics);
            if (wrapped instanceof PrinterGraphics) {
                zoom = ActivityPainter.getZoom((ScaledGraphics)((PrinterGraphics)wrapped));
                _graphicsPrintingObjectsToZoom.put(graphics, zoom);
                return scale / zoom;
            }
        }
        _graphicsPrintingObjectsToZoom.put(graphics, Double.NEGATIVE_INFINITY);
        return scale;
    }

    static /* synthetic */ int access$0() {
        return sequenceEdgeTransparency;
    }

    static /* synthetic */ int access$2() {
        return messagingEdgeTransparency;
    }
}

