/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.DiagramColorConstants;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.AssociationEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.MessagingEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.ui.PopupMenuWithDisableSupport;
import org.eclipse.stp.bpmn.dnd.IDnDHandler;
import org.eclipse.stp.bpmn.dnd.IDnDHandler2;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.policies.DnDHandlerDelegateLabelProvider;
import org.eclipse.stp.bpmn.policies.DnDHandlerMenuItemData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnDragDropEditPolicy
extends GraphicalEditPolicy {
    private static final Color disabledFeedbackColor = new Color(null, 255, 64, 64);
    private static WeakHashMap<Object, AdaptedCache> CACHE = new WeakHashMap();
    private EditPolicy previousEditPolicy;
    private IFigure _feedback = null;

    public BpmnDragDropEditPolicy(IGraphicalEditPart part) {
        EditPolicy policy = part.getEditPolicy((Object)"DragDropPolicy");
        if (policy != null) {
            this.previousEditPolicy = policy;
        }
    }

    public boolean understandsRequest(Request request) {
        boolean b = "drop_objects".equals(request.getType());
        b = b && request instanceof DropObjectsRequest && !((DropObjectsRequest)request).getObjects().isEmpty();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command getCommand(Request request) {
        if (!this.understandsRequest(request)) {
            if (this.previousEditPolicy != null) {
                return this.previousEditPolicy.getCommand(request);
            }
            return null;
        }
        final DropObjectsRequest dropRequest = (DropObjectsRequest)request;
        List<IDnDHandler> dndHandlers = null;
        DropObjectsRequest dropObjectsRequest = dropRequest;
        synchronized (dropObjectsRequest) {
            AdaptedCache cache = CACHE.get(dropRequest.getObjects().iterator().next());
            if (cache != null && cache.size != dropRequest.getObjects().size()) {
                cache = null;
            }
            Object adapted = null;
            if (cache == null) {
                adapted = BpmnDragDropEditPolicy.retrieveDnDHandlers(dropRequest.getObjects());
                Collections.sort(adapted, new Comparator<IDnDHandler>(){

                    @Override
                    public int compare(IDnDHandler o1, IDnDHandler o2) {
                        int p2;
                        int p1 = o1 instanceof IDnDHandler2 ? ((IDnDHandler2)o1).getPriority((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost()) : o1.getPriority();
                        int n = p2 = o2 instanceof IDnDHandler2 ? ((IDnDHandler2)o2).getPriority((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost()) : o2.getPriority();
                        if (p1 > p2) {
                            return -1;
                        }
                        if (p1 < p2) {
                            return 1;
                        }
                        return 0;
                    }
                });
                cache = new AdaptedCache();
                cache.result = new ArrayList<IDnDHandler>((Collection<IDnDHandler>)adapted);
                cache.size = dropRequest.getObjects().size();
                CACHE.put(dropRequest.getObjects().iterator().next(), cache);
            } else {
                adapted = new ArrayList<IDnDHandler>(cache.result);
            }
            dndHandlers = adapted;
        }
        if (dndHandlers == null || dndHandlers.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean isEnabled = false;
        for (IDnDHandler handler : dndHandlers) {
            int i = 0;
            while (i < handler.getItemCount()) {
                isEnabled = isEnabled || handler.isEnabled((IGraphicalEditPart)this.getHost(), i);
                ++i;
            }
        }
        if (!isEnabled) {
            dropRequest.setRequiredDetail(0);
        } else {
            dropRequest.setRequiredDetail(1);
        }
        final List<IDnDHandler> handlers = dndHandlers;
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), BpmnDiagramMessages.BpmnDragDropEditPolicy_command_name, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                PopupMenuCommand popupCmd;
                block9: {
                    IGraphicalEditPart gHost = (IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost();
                    DnDHandlerDelegateLabelProvider provider = new DnDHandlerDelegateLabelProvider(gHost);
                    ArrayList<DnDHandlerMenuItemData> items = new ArrayList<DnDHandlerMenuItemData>();
                    for (IDnDHandler handler : handlers) {
                        int itemCount = handler instanceof IDnDHandler2 ? ((IDnDHandler2)handler).getItemCount(gHost) : handler.getItemCount();
                        int i = 0;
                        while (i < itemCount) {
                            DnDHandlerMenuItemData data = new DnDHandlerMenuItemData(handler, i, gHost);
                            data.handler = handler;
                            data.index = i++;
                            items.add(data);
                        }
                    }
                    PopupMenuWithDisableSupport popupMenu = new PopupMenuWithDisableSupport(items, (ILabelProvider)provider, dropRequest.getLocation(), BpmnDragDropEditPolicy.this.getHost().getViewer());
                    popupCmd = new PopupMenuCommand("", new Shell(), (PopupMenu)popupMenu);
                    popupCmd.execute(monitor, info);
                    if (popupCmd.getCommandResult().getStatus().getSeverity() == 0 && popupCmd.getCommandResult().getReturnValue() != null) break block9;
                    CACHE.clear();
                    CommandResult commandResult = popupCmd.getCommandResult();
                    CACHE.clear();
                    return commandResult;
                }
                try {
                    try {
                        DnDHandlerMenuItemData winner = (DnDHandlerMenuItemData)popupCmd.getCommandResult().getReturnValue();
                        Command co = winner.handler.getDropCommand((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost(), winner.index, dropRequest.getLocation().getCopy());
                        if (co != null) {
                            co.execute();
                        }
                        for (IDnDHandler handler : handlers) {
                            handler.dispose();
                        }
                    }
                    catch (Exception e) {
                        Status st = new Status(4, "org.eclipse.stp.bpmn.diagram", 0, e.getMessage(), (Throwable)e);
                        BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)st);
                        CACHE.clear();
                    }
                }
                catch (Throwable throwable) {
                    CACHE.clear();
                    throw throwable;
                }
                CACHE.clear();
                return CommandResult.newOKCommandResult();
            }
        };
        return new ICommandProxy((ICommand)command);
    }

    private Command getAnnotationsDropCommand(final List<EAnnotation> annotations) {
        ICommandProxy co = new ICommandProxy((ICommand)new AbstractTransactionalCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), BpmnDiagramMessages.BpmnDragDropEditPolicy_annotation_drop_command, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject element = ((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost()).resolveSemanticElement();
                for (EAnnotation ann : annotations) {
                    SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)ann, (Object)EcorePackage.eINSTANCE.getEAnnotation_EModelElement(), (Object)element).execute();
                }
                return CommandResult.newOKCommandResult();
            }
        });
        return co;
    }

    static List<IDnDHandler> retrieveDnDHandlers(List objects) {
        ArrayList<IDnDHandler> dndHandlers = new ArrayList<IDnDHandler>();
        for (Object dropped : objects) {
            if (dropped instanceof IDnDHandler) {
                dndHandlers.add((IDnDHandler)dropped);
                continue;
            }
            HashMap factories = ((AdapterManager)Platform.getAdapterManager()).getFactories();
            Iterable<Class> cls = BpmnDragDropEditPolicy.computeClassOrder(dropped.getClass());
            for (Class c : cls) {
                List clfactories = (List)factories.get(c.getName());
                if (clfactories == null) continue;
                for (Object f : clfactories) {
                    Object adapted;
                    IAdapterFactory factory = (IAdapterFactory)f;
                    if (f instanceof IAdapterFactoryExt) {
                        IAdapterFactoryExt fext = (IAdapterFactoryExt)f;
                        boolean foundIt = false;
                        String[] stringArray = fext.getAdapterNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String adapter = stringArray[n2];
                            if (adapter.equals(IDnDHandler.class.getName())) {
                                foundIt = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!foundIt) continue;
                        try {
                            fext.loadFactory(true);
                        }
                        catch (Throwable e) {
                            System.err.println("Unable to load a BPMNAdapter factory: " + e.getMessage() + " for " + c.getName());
                        }
                    }
                    if ((adapted = factory.getAdapter(dropped, IDnDHandler.class)) instanceof IDnDHandler) {
                        dndHandlers.add((IDnDHandler)adapted);
                        continue;
                    }
                    if (!(adapted instanceof List)) continue;
                    for (Object ad : (List)adapted) {
                        if (!(ad instanceof IDnDHandler)) continue;
                        dndHandlers.add((IDnDHandler)ad);
                    }
                }
            }
        }
        return dndHandlers;
    }

    private static Iterable<Class> computeClassOrder(Class droppedClass) {
        Class[] cls = ((AdapterManager)Platform.getAdapterManager()).computeClassOrder(droppedClass);
        LinkedList<Class> res = new LinkedList<Class>();
        Class[] classArray = cls;
        int n = cls.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.getPackage() != Object.class.getPackage() && c.getPackage() != Serializable.class.getPackage() && c.getPackage() != Field.class.getPackage()) {
                res.add(c);
            }
            ++n2;
        }
        return res;
    }

    private Point getBalloonPosition(Point referencePoint) {
        Point lastRePointForBalloonPosition = referencePoint.getCopy();
        ((GraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)lastRePointForBalloonPosition);
        Point thePoint = new Point();
        thePoint.setLocation(referencePoint);
        this.getHostFigure().translateToAbsolute((Translatable)thePoint);
        this.getHostFigure().translateToRelative((Translatable)thePoint);
        Control ctrl1 = this.getHost().getViewer().getControl();
        if (ctrl1 instanceof FigureCanvas) {
            FigureCanvas figureCanvas = (FigureCanvas)ctrl1;
            Viewport vp = figureCanvas.getViewport();
            Rectangle vpRect = vp.getClientArea();
            Rectangle rcBounds = this.getHostFigure().getBounds().getCopy();
            this.getHostFigure().translateToAbsolute((Translatable)rcBounds);
            this.getHostFigure().translateToRelative((Translatable)rcBounds);
            thePoint.y += vpRect.y;
            thePoint.x += vpRect.x;
        }
        return thePoint;
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.understandsRequest(request)) {
            return this.getHost();
        }
        if (this.previousEditPolicy != null) {
            return this.previousEditPolicy.getTargetEditPart(request);
        }
        return null;
    }

    public void showTargetFeedback(Request request) {
        if (this.understandsRequest(request)) {
            if (this._feedback == null) {
                Command co = this.getCommand(request);
                this._feedback = this.createFeedback(co != null && co.canExecute() && ((DropObjectsRequest)request).getRequiredDetail() != 0);
            }
            Rectangle bounds = ((IGraphicalEditPart)this.getHost()).getFigure().getBounds().getCopy();
            this.getFeedbackLayer().add(this._feedback);
            if (!(this.getHost() instanceof MessagingEdgeEditPart || this.getHost() instanceof SequenceEdgeEditPart || this.getHost() instanceof AssociationEditPart)) {
                bounds.expand(3, 3);
            }
            ((IGraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)bounds);
            this._feedback.translateToRelative((Translatable)bounds);
            this._feedback.setBounds(bounds);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this._feedback != null && this._feedback.getParent() != null) {
            this._feedback.getParent().remove(this._feedback);
        }
        this._feedback = null;
    }

    protected IFigure createFeedback(boolean executable) {
        if ((IGraphicalEditPart)this.getHost() instanceof MessagingEdgeEditPart || (IGraphicalEditPart)this.getHost() instanceof SequenceEdgeEditPart || (IGraphicalEditPart)this.getHost() instanceof AssociationEditPart) {
            Connection conn = (Connection)((ConnectionEditPart)this.getHost()).getFigure();
            PolylineConnectionEx feedback = null;
            if ((IGraphicalEditPart)this.getHost() instanceof MessagingEdgeEditPart) {
                feedback = new MessagingEdgeEditPart.ConnectionMessageFigure((MessagingEdgeEditPart)this.getHost()){

                    public void paintFigure(Graphics graphics) {
                        graphics.setAlpha(ActivityPainter.getMessagingEdgeTransparency() / 2);
                        super.paintFigure(graphics);
                    }
                };
            } else if ((IGraphicalEditPart)this.getHost() instanceof SequenceEdgeEditPart) {
                SequenceEdgeEditPart sequenceEdgeEditPart = (SequenceEdgeEditPart)this.getHost();
                ((Object)((Object)sequenceEdgeEditPart)).getClass();
                feedback = new SequenceEdgeEditPart.EdgeFigure(sequenceEdgeEditPart, true){

                    public void paintFigure(Graphics graphics) {
                        graphics.setAlpha(ActivityPainter.getSequenceEdgeTransparency() / 2);
                        super.paintFigure(graphics);
                    }
                };
            } else if ((IGraphicalEditPart)this.getHost() instanceof AssociationEditPart) {
                feedback = new AssociationEditPart.ConnectionAssociationFigure((AssociationEditPart)this.getHost()){

                    public void paintFigure(Graphics graphics) {
                        graphics.setAlpha(127);
                        super.paintFigure(graphics);
                    }
                };
            }
            PointList pl = conn.getPoints().getCopy();
            ZoomManager zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
            pl.performScale(zoom.getZoom());
            feedback.setPoints(pl);
            Rectangle rect = conn.getBounds().getCopy();
            feedback.setBounds(rect);
            feedback.setForegroundColor(executable ? DiagramColorConstants.lightBlue : disabledFeedbackColor);
            feedback.setLineWidth(3);
            feedback.setSmoothness(32);
            feedback.setConnectionRouter(conn.getConnectionRouter());
            return feedback;
        }
        RoundedRectangle feedback = new RoundedRectangle();
        feedback.setFill(false);
        feedback.setLineWidth(3);
        feedback.setForegroundColor(executable ? DiagramColorConstants.lightBlue : disabledFeedbackColor);
        return feedback;
    }

    private static class AdaptedCache {
        public List<IDnDHandler> result;
        public int size;

        private AdaptedCache() {
        }
    }
}

