/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Group;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.commands.ElementTypeEx;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.Group2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.GroupEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;
import org.eclipse.stp.bpmn.tools.ActivityResizeTracker;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizableActivityEditPolicy
extends ResizableShapeEditPolicyEx {
    @Override
    protected Handle createHandle(GraphicalEditPart owner, int direction) {
        return new ActivityResizeHandle(owner, direction);
    }

    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle)handle;
            h.setDragTracker((DragTracker)new TaskDragEditPartsTrackerEx((IGraphicalEditPart)this.getHost()));
        }
    }

    @Override
    protected Command getAutoSizeCommand(Request request) {
        IGraphicalEditPart nameEp;
        EObject semantic = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        Object type = ElementTypeRegistry.getInstance().getElementType(semantic);
        if (semantic instanceof Activity) {
            type = ElementTypeEx.wrap(type, ((Activity)semantic).getActivityType().getName());
        }
        Dimension size = BpmnShapesDefaultSizes.getDefaultSize(type).getCopy();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Rectangle rect = new Rectangle(this.getHostFigure().getBounds().getLocation().getCopy(), size);
        if ((ActivityType.VALUES_EVENTS.contains(((Activity)semantic).getActivityType()) || ActivityType.VALUES_GATEWAYS.contains(((Activity)semantic).getActivityType())) && (nameEp = ((IGraphicalEditPart)this.getHost()).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001))) == null) {
            nameEp = ((IGraphicalEditPart)this.getHost()).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4002));
        }
        SetBoundsCommand resizeCommand = new SetBoundsCommand(editingDomain, "", (IAdaptable)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getHost()), rect);
        return new ICommandProxy((ICommand)resizeCommand);
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            final ChangeBoundsRequest change = (ChangeBoundsRequest)request;
            final IGraphicalEditPart nameEp = (IGraphicalEditPart)change.getEditParts().iterator().next();
            SetBoundsCommand resize = new SetBoundsCommand(editingDomain, BpmnDiagramMessages.ResizableActivityEditPolicy_command_name, (IAdaptable)nameEp, change.getSizeDelta()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    nameEp.getFigure().setSize(nameEp.getFigure().getSize().getCopy().expand(change.getSizeDelta()));
                    return super.doExecuteWithResult(monitor, info);
                }
            };
            ChangeBoundsRequest selfResize = new ChangeBoundsRequest((Object)"resize");
            selfResize.setEditParts(this.getHost());
            selfResize.setSizeDelta(change.getSizeDelta().getCopy());
            CompoundCommand compound = new CompoundCommand();
            compound.add((Command)new ICommandProxy((ICommand)resize));
            compound.add(super.getCommand((Request)selfResize));
            return compound;
        }
        return super.getCommand(request);
    }

    static List<Group> findContainingGroups(ChangeBoundsRequest request, IGraphicalEditPart host) {
        Rectangle rect = host.getFigure().getBounds().getCopy();
        host.getFigure().translateToAbsolute((Translatable)rect);
        rect.resize(request.getSizeDelta());
        rect.translate(request.getMoveDelta());
        return ResizableActivityEditPolicy.findContainingGroups(rect, host.getViewer());
    }

    static List<Group> findContainingGroups(Rectangle rect, EditPartViewer viewer) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Object o : viewer.getVisualPartMap().keySet()) {
            EditPart p = (EditPart)viewer.getVisualPartMap().get(o);
            if (!(p instanceof GroupEditPart) && !(p instanceof Group2EditPart)) continue;
            IGraphicalEditPart part = (IGraphicalEditPart)p;
            Rectangle bounds = part.getFigure().getBounds().getCopy();
            part.getFigure().translateToAbsolute((Translatable)bounds);
            if (!bounds.contains(rect)) continue;
            groups.add((Group)part.resolveSemanticElement());
        }
        return groups;
    }

    static List<Lane> findContainingLanes(ChangeBoundsRequest request, IGraphicalEditPart host) {
        Rectangle rect = host.getFigure().getBounds().getCopy();
        host.getFigure().translateToAbsolute((Translatable)rect);
        rect.resize(request.getSizeDelta());
        rect.translate(request.getMoveDelta());
        return ResizableActivityEditPolicy.findContainingLanes(rect, host.getViewer());
    }

    static List<Lane> findContainingLanes(Rectangle activity, EditPartViewer viewer) {
        ArrayList<Lane> lanes = new ArrayList<Lane>();
        int actUpper = activity.y;
        int actLower = activity.y + activity.height;
        for (Object o : viewer.getVisualPartMap().keySet()) {
            EditPart p = (EditPart)viewer.getVisualPartMap().get(o);
            if (!(p instanceof LaneEditPart)) continue;
            IGraphicalEditPart part = (IGraphicalEditPart)p;
            Rectangle lane = part.getFigure().getBounds().getCopy();
            part.getFigure().translateToAbsolute((Translatable)lane);
            int laneUpper = lane.y;
            int laneLower = lane.y + lane.height;
            if (!(laneUpper <= actUpper && laneLower > actUpper || laneLower < actLower && laneUpper > actUpper) && (laneUpper >= actLower || laneLower < actLower)) continue;
            lanes.add((Lane)part.resolveSemanticElement());
        }
        return lanes;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        CompoundCommand compound = new CompoundCommand();
        compound.add(super.getMoveCommand(request));
        compound.add((Command)new ICommandProxy((ICommand)new SetGroupsCommand(ResizableActivityEditPolicy.findContainingGroups(request, (IGraphicalEditPart)this.getHost()), (Activity)((IGraphicalEditPart)this.getHost()).resolveSemanticElement())));
        compound.add((Command)new ICommandProxy((ICommand)new SetLanesCommand(ResizableActivityEditPolicy.findContainingLanes(request, (IGraphicalEditPart)this.getHost()), (Activity)((IGraphicalEditPart)this.getHost()).resolveSemanticElement())));
        return compound;
    }

    public Command getResizeCommand(ChangeBoundsRequest request) {
        CompoundCommand compound = new CompoundCommand();
        compound.add(super.getResizeCommand(request));
        compound.add((Command)new ICommandProxy((ICommand)new SetGroupsCommand(ResizableActivityEditPolicy.findContainingGroups(request, (IGraphicalEditPart)this.getHost()), (Activity)((IGraphicalEditPart)this.getHost()).resolveSemanticElement())));
        compound.add((Command)new ICommandProxy((ICommand)new SetLanesCommand(ResizableActivityEditPolicy.findContainingLanes(request, (IGraphicalEditPart)this.getHost()), (Activity)((IGraphicalEditPart)this.getHost()).resolveSemanticElement())));
        return compound;
    }

    protected static class ActivityResizeHandle
    extends ResizableShapeEditPolicyEx.ResizeHandleEx {
        public ActivityResizeHandle(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected DragTracker createDragTracker() {
            return new ActivityResizeTracker(this.getOwner(), this.cursorDirection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetGroupsCommand
    extends AbstractTransactionalCommand {
        private List<Group> _groups;
        private Activity _activity;
        private CreateViewAndElementRequest _request;

        public SetGroupsCommand(List<Group> groups, Activity activity) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)activity), BpmnDiagramMessages.ResizableActivityEditPolicy_lanes_command_name, SetGroupsCommand.getWorkspaceFiles((EObject)activity));
            this._groups = groups;
            this._activity = activity;
        }

        public SetGroupsCommand(List<Group> groups, CreateViewAndElementRequest request, EObject container) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)container), BpmnDiagramMessages.ResizableActivityEditPolicy_groups_command_name, SetGroupsCommand.getWorkspaceFiles((EObject)container));
            this._groups = groups;
            this._request = request;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this._request != null) {
                this._activity = (Activity)this._request.getViewAndElementDescriptor().getCreateElementRequestAdapter().resolve();
            }
            ArrayList<Group> toRemove = new ArrayList<Group>();
            ArrayList<Group> groups = new ArrayList<Group>(this._groups);
            for (Group a : this._activity.getGroups()) {
                if (groups.remove(a)) continue;
                toRemove.add(a);
            }
            this._activity.getGroups().removeAll(toRemove);
            this._activity.getGroups().addAll(groups);
            return CommandResult.newOKCommandResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetLanesCommand
    extends AbstractTransactionalCommand {
        private Activity activity;
        private List<Lane> lanes;
        private CreateViewAndElementRequest request;

        public SetLanesCommand(List<Lane> lanes, Activity activity) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)activity), BpmnDiagramMessages.ResizableActivityEditPolicy_groups_command_name, SetLanesCommand.getWorkspaceFiles((EObject)activity));
            this.activity = activity;
            this.lanes = lanes;
        }

        public SetLanesCommand(List<Lane> lanes, CreateViewAndElementRequest request, EObject container) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)container), BpmnDiagramMessages.ResizableActivityEditPolicy_groups_command_name, SetLanesCommand.getWorkspaceFiles((EObject)container));
            this.request = request;
            this.lanes = lanes;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.request != null) {
                this.activity = (Activity)this.request.getViewAndElementDescriptor().getCreateElementRequestAdapter().resolve();
            }
            ArrayList<Lane> toRemove = new ArrayList<Lane>();
            ArrayList<Lane> lanes = new ArrayList<Lane>(this.lanes);
            for (Lane a : this.activity.getLanes()) {
                if (lanes.remove(a)) continue;
                toRemove.add(a);
            }
            this.activity.getLanes().removeAll(toRemove);
            this.activity.getLanes().addAll(lanes);
            return CommandResult.newOKCommandResult();
        }
    }
}

