/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.handles.RelativeHandleLocator;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.handles.SquareHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.commands.ElementTypeEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.ui.RoundedSchemeBorder;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;
import org.eclipse.stp.bpmn.figures.FeedbackShape;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResizableShapeEditPolicyEx
extends ResizableShapeEditPolicy {
    protected ZoomManager _zoom;
    private static final String IS_OVER_LAPPING = "IsOverLapping";
    private static final String OTHER_SELECTED_EDITPARTS = "OtherSelectedEditParts";
    private static final String IS_CHANGING_SCOPE = "ChangingScope";

    public void activate() {
        super.activate();
        this._zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
    }

    public void deactivate() {
        super.deactivate();
        this._zoom = null;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure f = this.getHostFigure();
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy().expand(RoundedSchemeBorder.INSETS));
        f.translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        if (request.getSizeDelta().height != 0 || request.getSizeDelta().width != 0) {
            rect.resize(request.getSizeDelta());
            Dimension max = f.getMaximumSize().getCopy();
            Dimension min = f.getMinimumSize().getCopy();
            min.height -= 50;
            double zoom = this._zoom.getZoom();
            min.scale(zoom);
            max.scale(zoom);
            IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
            min.height = mmode.LPtoDP(min.height);
            min.width = mmode.LPtoDP(min.width);
            max.height = mmode.LPtoDP(max.height);
            max.width = mmode.LPtoDP(max.width);
            if (min.width > rect.width) {
                if ((request.getResizeDirection() & 8) != 0) {
                    rect.x += (int)Math.floor((double)(rect.width - min.width) * zoom);
                }
                rect.width = min.width;
            } else if (max.width < rect.width) {
                if ((request.getResizeDirection() & 8) != 0) {
                    rect.x -= (int)Math.floor((double)(rect.width - max.width) * zoom);
                }
                rect.width = max.width;
            }
            if (min.height > rect.height) {
                if ((request.getResizeDirection() & 1) != 0) {
                    rect.y += (int)Math.floor((double)(rect.height - min.height) * zoom);
                }
                rect.height = min.height;
            } else if (max.height < rect.height) {
                if ((request.getResizeDirection() & 1) != 0) {
                    rect.y -= (int)Math.floor((double)(rect.height - max.height) * zoom);
                }
                rect.height = max.height;
            }
        }
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
        this.updateFeedbackWithOverlappingAreas((FeedbackShape)feedback, request);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        FeedbackShape r = new FeedbackShape();
        r.setBounds(this.getInitialFeedbackBounds());
        this.addFeedback((IFigure)r);
        return r;
    }

    protected FeedbackShape getDragSourceFeedbackFigureCasted() {
        return (FeedbackShape)super.getDragSourceFeedbackFigure();
    }

    protected void updateFeedbackWithOverlappingAreas(FeedbackShape feedback, ChangeBoundsRequest request) {
        Rectangle absBounds = feedback.getBounds().getCopy();
        feedback.translateToAbsolute((Translatable)absBounds);
        Rectangle sibAbsBounds = new Rectangle();
        ArrayList<Object> overlaps = null;
        HashSet<Object> selectedEditParts = new HashSet<Object>(request.getEditParts());
        Collection<? extends EditPart> otherEPs = ResizableShapeEditPolicyEx.getOtherSelectedEditParts((Request)request);
        if (otherEPs != null) {
            selectedEditParts.addAll(otherEPs);
        }
        for (Object ep : request.getEditParts()) {
            if (!(ep instanceof SubProcessSubProcessBodyCompartmentEditPart)) continue;
            selectedEditParts.add(((SubProcessSubProcessBodyCompartmentEditPart)((Object)ep)).getParent());
        }
        boolean isChangingScope = ResizableShapeEditPolicyEx.isChangingScopeRequest((Request)request);
        if (!isChangingScope && this.getHost().getParent() instanceof SubProcessSubProcessBodyCompartmentEditPart && !selectedEditParts.contains(this.getHost().getParent()) && !selectedEditParts.contains(((SubProcessSubProcessBodyCompartmentEditPart)this.getHost().getParent()).getParent())) {
            SubProcessSubProcessBodyCompartmentEditPart spCompartment = (SubProcessSubProcessBodyCompartmentEditPart)this.getHost().getParent();
            sibAbsBounds.setBounds(((HandleBounds)((SubProcessEditPart)spCompartment.getParent()).getFigure()).getHandleBounds());
            spCompartment.getCompartmentFigure().translateToAbsolute((Translatable)sibAbsBounds);
            sibAbsBounds.intersect(absBounds);
            if (sibAbsBounds.height != absBounds.height || sibAbsBounds.width != absBounds.width) {
                if (overlaps == null) {
                    overlaps = new ArrayList();
                }
                if (sibAbsBounds.height == 0 || sibAbsBounds.width == 0) {
                    overlaps.clear();
                    overlaps.add(feedback.getBounds().getCopy());
                    feedback.setOverlappingBounds(overlaps);
                    this.setIsOverlapping(request, overlaps != null);
                    return;
                }
                if (absBounds.x < sibAbsBounds.x) {
                    Rectangle leftColumn = new Rectangle(absBounds.x, absBounds.y, sibAbsBounds.x - absBounds.x, absBounds.height);
                    feedback.translateToRelative((Translatable)leftColumn);
                    overlaps.add(leftColumn);
                }
                if (absBounds.y < sibAbsBounds.y) {
                    Rectangle topColumn = new Rectangle(absBounds.x, absBounds.y, absBounds.width, sibAbsBounds.y - absBounds.y);
                    feedback.translateToRelative((Translatable)topColumn);
                    overlaps.add(topColumn);
                }
                if (absBounds.x + absBounds.width > sibAbsBounds.x + sibAbsBounds.width) {
                    Rectangle rightColumn = new Rectangle(sibAbsBounds.x + sibAbsBounds.width, absBounds.y, absBounds.x + absBounds.width - sibAbsBounds.x - sibAbsBounds.width, absBounds.height);
                    feedback.translateToRelative((Translatable)rightColumn);
                    overlaps.add(rightColumn);
                }
                if (absBounds.y + absBounds.height > sibAbsBounds.y + sibAbsBounds.height) {
                    Rectangle bottomColumn = new Rectangle(absBounds.x, sibAbsBounds.y + sibAbsBounds.height, absBounds.width, absBounds.y + absBounds.height - sibAbsBounds.y - sibAbsBounds.height);
                    feedback.translateToRelative((Translatable)bottomColumn);
                    overlaps.add(bottomColumn);
                }
            }
        }
        List children = this.getHost().getParent().getChildren();
        for (Object child : children) {
            if (selectedEditParts.contains(child) || !(child instanceof ActivityEditPart) && !(child instanceof SubProcessEditPart) || child instanceof SubProcessEditPart && isChangingScope) continue;
            TaskDragEditPartsTrackerEx.setBoundsForOverlapComputation((IGraphicalEditPart)child, sibAbsBounds);
            sibAbsBounds.intersect(absBounds);
            if (sibAbsBounds.width == 0 || sibAbsBounds.height == 0) continue;
            if (overlaps == null) {
                overlaps = new ArrayList<Rectangle>();
            }
            feedback.translateToRelative((Translatable)sibAbsBounds);
            overlaps.add(sibAbsBounds.getCopy());
        }
        if (request.getSizeDelta() != null && (request.getSizeDelta().height != 0 || request.getSizeDelta().width != 0) && this.getHost() instanceof SubProcessEditPart && !((SubProcessEditPart)this.getHost()).getPrimaryShape().isCollapsed()) {
            absBounds.crop(SubProcessEditPart.INSETS);
            SubProcessSubProcessBodyCompartmentEditPart body = (SubProcessSubProcessBodyCompartmentEditPart)((IGraphicalEditPart)this.getHost()).getChildBySemanticHint("5002");
            if (body != null) {
                for (Object child : body.getChildren()) {
                    if (selectedEditParts.contains(child) || !(child instanceof ActivityEditPart) && !(child instanceof SubProcessEditPart)) continue;
                    TaskDragEditPartsTrackerEx.setBoundsForOverlapComputation((IGraphicalEditPart)child, sibAbsBounds);
                    if (absBounds.contains(sibAbsBounds)) continue;
                    if (overlaps == null) {
                        overlaps = new ArrayList();
                    }
                    feedback.translateToRelative((Translatable)sibAbsBounds);
                    overlaps.add(sibAbsBounds.getCopy());
                }
            }
        }
        feedback.setOverlappingBounds(overlaps);
        this.setIsOverlapping(request, overlaps != null && !overlaps.isEmpty());
    }

    public static boolean isOverlappingRequest(Request request) {
        return request.getExtendedData() != null && request.getExtendedData().containsKey(IS_OVER_LAPPING);
    }

    public static boolean isChangingScopeRequest(Request request) {
        return request.getExtendedData() != null && Boolean.TRUE.equals(request.getExtendedData().get(IS_CHANGING_SCOPE));
    }

    public static void setIsChangingScope(boolean changingScope, Request request) {
        HashMap<String, Boolean> data = request.getExtendedData();
        if (changingScope) {
            if (data == null) {
                data = new HashMap<String, Boolean>();
            }
            data.put(IS_CHANGING_SCOPE, changingScope);
        } else if (data != null) {
            data.remove(IS_CHANGING_SCOPE);
        }
    }

    public static Collection<? extends EditPart> getOtherSelectedEditParts(Request request) {
        return request.getExtendedData() != null ? (Collection)request.getExtendedData().get(OTHER_SELECTED_EDITPARTS) : null;
    }

    public static void setOtherSelectedEditParts(Collection<? extends EditPart> otherSelectedEPs, Request request) {
        HashMap<String, Collection<? extends EditPart>> data = request.getExtendedData();
        if (otherSelectedEPs != null && !otherSelectedEPs.isEmpty()) {
            if (data == null) {
                data = new HashMap<String, Collection<? extends EditPart>>();
            }
            data.put(OTHER_SELECTED_EDITPARTS, otherSelectedEPs);
        } else if (data != null) {
            data.remove(OTHER_SELECTED_EDITPARTS);
        }
    }

    protected final void setIsOverlapping(ChangeBoundsRequest request, boolean isOverlapping) {
        HashMap<String, Boolean> extendedData = request.getExtendedData();
        if (isOverlapping) {
            if (extendedData == null) {
                extendedData = new HashMap<String, Boolean>();
            }
            extendedData.put(IS_OVER_LAPPING, Boolean.TRUE);
        } else if (extendedData != null) {
            extendedData.remove(IS_OVER_LAPPING);
        }
    }

    protected List createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        int directions = this.getResizeDirections();
        if (directions == 0) {
            NonResizableHandleKit.addHandles((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list);
        } else if (directions != -1) {
            ResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list);
            if ((directions & 0x10) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
            }
            if ((directions & 0x14) == 20) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)20);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)20);
            }
            if ((directions & 4) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
            }
            if ((directions & 0xC) == 12) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)12);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)12);
            }
            if ((directions & 8) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
            }
            if ((directions & 9) == 9) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)9);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)9);
            }
            if ((directions & 1) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
            }
            if ((directions & 0x11) == 17) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)17);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)17);
            }
        } else {
            this.addHandles((GraphicalEditPart)this.getHost(), list);
        }
        return list;
    }

    private void addHandles(GraphicalEditPart part, List<Handle> handles) {
        ResizableHandleKit.addMoveHandle((GraphicalEditPart)part, handles);
        MoveHandle moveHandle = (MoveHandle)handles.get(0);
        moveHandle.setBorder(null);
        this.safeAddHandle(handles, this.createHandle(part, 16));
        this.safeAddHandle(handles, this.createHandle(part, 20));
        this.safeAddHandle(handles, this.createHandle(part, 4));
        this.safeAddHandle(handles, this.createHandle(part, 12));
        this.safeAddHandle(handles, this.createHandle(part, 8));
        this.safeAddHandle(handles, this.createHandle(part, 9));
        this.safeAddHandle(handles, this.createHandle(part, 1));
        this.safeAddHandle(handles, this.createHandle(part, 17));
    }

    private void safeAddHandle(List<Handle> handles, Handle handleOrNull) {
        if (handleOrNull != null) {
            handles.add(handleOrNull);
        }
    }

    protected abstract Handle createHandle(GraphicalEditPart var1, int var2);

    protected Command getAutoSizeCommand(Request request) {
        EObject semantic = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (semantic == null) {
            return super.getAutoSizeCommand(request);
        }
        Object type = ElementTypeRegistry.getInstance().getElementType(semantic);
        if (semantic instanceof Activity) {
            type = ElementTypeEx.wrap(type, ((Activity)semantic).getActivityType().getName());
        }
        Dimension size = BpmnShapesDefaultSizes.getDefaultSize(type).getCopy();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Rectangle rect = new Rectangle(this.getHostFigure().getBounds().getLocation().getCopy(), size);
        SetBoundsCommand resizeCommand = new SetBoundsCommand(editingDomain, "", (IAdaptable)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getHost()), rect);
        return new ICommandProxy((ICommand)resizeCommand);
    }

    protected static abstract class ResizeHandleEx
    extends SquareHandle {
        protected int cursorDirection;

        public ResizeHandleEx(GraphicalEditPart owner, int direction) {
            this.setOwner(owner);
            this.setLocator((Locator)new RelativeHandleLocator(owner.getFigure(), direction));
            this.setCursor(Cursors.getDirectionalCursor((int)direction, (boolean)owner.getFigure().isMirrored()));
            this.cursorDirection = direction;
        }

        protected abstract DragTracker createDragTracker();

        public void paintFigure(Graphics g) {
            Rectangle r = this.getBounds();
            r.shrink(1, 1);
            try {
                g.setBackgroundColor(ColorConstants.white);
                g.fillOval(r.x, r.y, r.width, r.height);
                g.setForegroundColor(ColorConstants.black);
                g.drawOval(r.x, r.y, r.width, r.height);
            }
            finally {
                r.expand(1, 1);
            }
        }
    }
}

