/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.internal.ui.rulers.GuideEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;
import org.eclipse.swt.graphics.Cursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleShapesMoveTool
extends SimpleDragTracker {
    private static final Rectangle SINGLETON = new Rectangle();
    private IFigure guideline;
    private Integer _initialPosition;
    private Integer _initPosNoZoom;
    private List<IGraphicalEditPart> _movingShapes = Collections.emptyList();
    private List<IGraphicalEditPart> _subProcesses = Collections.emptyList();
    private IGraphicalEditPart _container;

    public MultipleShapesMoveTool() {
        this.guideline = new GuideEditPart.GuideLineFigure();
        this.guideline.setVisible(false);
    }

    protected void eraseSourceFeedback() {
        if (this.guideline.getParent() != null) {
            this.guideline.getParent().remove(this.guideline);
        }
        if (this._container != null) {
            this._container.eraseSourceFeedback(this.getSourceRequest());
        }
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts(Collections.emptyList());
        request.setSizeDelta(new Dimension(0, 0));
        request.setMoveDelta(new Point(0, 0));
        for (IGraphicalEditPart part : this._movingShapes) {
            part.eraseSourceFeedback((Request)request);
        }
        ChangeBoundsRequest spRequest = new ChangeBoundsRequest((Object)"resize");
        spRequest.setEditParts(Collections.emptyList());
        spRequest.setSizeDelta(new Dimension(0, 0));
        spRequest.setMoveDelta(new Point(0, 0));
        for (IGraphicalEditPart sp : this._subProcesses) {
            sp.eraseSourceFeedback((Request)spRequest);
        }
    }

    protected Command getCommand() {
        if (this._container == null) {
            return null;
        }
        CompoundCommand command = new CompoundCommand(BpmnDiagramMessages.MultipleShapesMoveTool_command_name);
        TransactionalEditingDomain editingDomain = this._container.getEditingDomain();
        Point moveDelta = ((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta().getCopy();
        Dimension spSizeDelta = new Dimension(moveDelta.x, moveDelta.y);
        ZoomManager zoomManager = ((DiagramRootEditPart)this.getCurrentViewer().getRootEditPart()).getZoomManager();
        spSizeDelta.scale(1.0 / zoomManager.getZoom());
        command.add(this._container.getCommand(this.getSourceRequest()));
        for (IGraphicalEditPart sp : this._subProcesses) {
            Dimension spDim = sp.getFigure().getBounds().getSize().getCopy();
            spDim.expand(spSizeDelta);
            SetBoundsCommand setBounds = new SetBoundsCommand(editingDomain, BpmnDiagramMessages.MultipleShapesMoveTool_resizing, (IAdaptable)sp, spDim);
            command.add((Command)new ICommandProxy((ICommand)setBounds));
        }
        return command;
    }

    protected String getCommandName() {
        return "move children";
    }

    protected int getCurrentPositionZoomed() {
        Point pt = this.getLocation();
        ((IGraphicalEditPart)((IDiagramGraphicalViewer)this.getCurrentViewer()).getRootEditPart().getChildren().get(0)).getFigure().translateToRelative((Translatable)pt);
        return pt.x;
    }

    protected int getCurrentPosition() {
        int position = this.getCurrentPositionZoomed();
        ZoomManager zoomManager = ((DiagramRootEditPart)this.getCurrentViewer().getRootEditPart()).getZoomManager();
        if (zoomManager != null) {
            position = (int)Math.round((double)position * zoomManager.getZoom());
        }
        return position;
    }

    protected String getDebugName() {
        return "Multiple Shape Horizontal Move";
    }

    protected Cursor getDefaultCursor() {
        if (this.isMoveValid()) {
            return SharedCursors.SIZEWE;
        }
        if (this.getState() == 4) {
            return SharedCursors.SIZEWE;
        }
        return SharedCursors.ARROW;
    }

    private boolean isMoveValid() {
        if (this.getCurrentViewer() == null || this.getCurrentInput() == null) {
            return true;
        }
        EditPart obj = this.getCurrentViewer().findObjectAt(this.getCurrentInput().getMouseLocation());
        return obj instanceof IGraphicalEditPart && ((IGraphicalEditPart)obj).resolveSemanticElement() instanceof Graph;
    }

    public boolean handleButtonDown(int button) {
        EditPart underMouse = this.getCurrentViewer().findObjectAt(this.getCurrentInput().getMouseLocation());
        if (!(underMouse instanceof IGraphicalEditPart)) {
            return true;
        }
        this.stateTransition(1, 4);
        this._initialPosition = this.getCurrentPosition();
        this._initPosNoZoom = this.getCurrentPositionZoomed();
        this._container = this.findPool(underMouse);
        ArrayList<IGraphicalEditPart> rightChildren = new ArrayList<IGraphicalEditPart>();
        ArrayList<IGraphicalEditPart> subProcesses = new ArrayList<IGraphicalEditPart>();
        if (this._container != null && this._container.resolveSemanticElement() instanceof Pool) {
            List children = null;
            if (this._container instanceof PoolEditPart) {
                PoolPoolCompartmentEditPart compartment = (PoolPoolCompartmentEditPart)((PoolEditPart)this._container).getChildBySemanticHint(BpmnVisualIDRegistry.getType(5001));
                children = compartment.getChildren();
            } else if (this._container instanceof PoolPoolCompartmentEditPart) {
                children = ((PoolPoolCompartmentEditPart)this._container).getChildren();
            }
            if (children == null) {
                throw new IllegalArgumentException("The part " + this._container + " did not contain elements");
            }
            for (Object child : children) {
                if (!(child instanceof ShapeNodeEditPart)) continue;
                TaskDragEditPartsTrackerEx.setBoundsForOverlapComputation((IGraphicalEditPart)child, SINGLETON);
                ((DiagramEditPart)this.getCurrentViewer().getContents()).getFigure().translateToRelative((Translatable)SINGLETON);
                if (MultipleShapesMoveTool.SINGLETON.x > this._initPosNoZoom) {
                    rightChildren.add((IGraphicalEditPart)child);
                    continue;
                }
                if (!(child instanceof SubProcessEditPart) || MultipleShapesMoveTool.SINGLETON.x >= this._initPosNoZoom || MultipleShapesMoveTool.SINGLETON.x + MultipleShapesMoveTool.SINGLETON.width <= this._initPosNoZoom) continue;
                this.addEnclosedChildren((IGraphicalEditPart)child, rightChildren, subProcesses, this._initPosNoZoom);
            }
        }
        this._movingShapes = rightChildren;
        this._subProcesses = subProcesses;
        this.updateSourceRequest();
        this.showSourceFeedback();
        return true;
    }

    private void addEnclosedChildren(IGraphicalEditPart sp, List<IGraphicalEditPart> rightChildren, List<IGraphicalEditPart> subProcesses, int curPosNoZoom) {
        subProcesses.add(sp);
        SubProcessSubProcessBodyCompartmentEditPart compartment = (SubProcessSubProcessBodyCompartmentEditPart)sp.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002));
        List children = compartment.getChildren();
        for (Object child : children) {
            TaskDragEditPartsTrackerEx.setBoundsForOverlapComputation((IGraphicalEditPart)child, SINGLETON);
            ((DiagramEditPart)this.getCurrentViewer().getContents()).getFigure().translateToRelative((Translatable)SINGLETON);
            if (MultipleShapesMoveTool.SINGLETON.x > curPosNoZoom) {
                rightChildren.add((IGraphicalEditPart)child);
                continue;
            }
            if (!(child instanceof SubProcessEditPart) || MultipleShapesMoveTool.SINGLETON.x >= curPosNoZoom || MultipleShapesMoveTool.SINGLETON.x + MultipleShapesMoveTool.SINGLETON.width <= curPosNoZoom) continue;
            this.addEnclosedChildren((IGraphicalEditPart)child, rightChildren, subProcesses, curPosNoZoom);
        }
    }

    private IGraphicalEditPart findPool(Object part) {
        if (part instanceof IGraphicalEditPart) {
            if (((IGraphicalEditPart)part).resolveSemanticElement() instanceof Pool) {
                return (IGraphicalEditPart)part;
            }
            return this.findPool(((IGraphicalEditPart)part).getParent());
        }
        return null;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.setCurrentCommand(this.getCommand());
            this.executeCurrentCommand();
        }
        this.eraseSourceFeedback();
        this._movingShapes = Collections.EMPTY_LIST;
        this._initialPosition = null;
        this.setState(1);
        this._container = null;
        return true;
    }

    protected boolean movedPastThreshold() {
        return true;
    }

    protected void showSourceFeedback() {
        if (this._container == null) {
            return;
        }
        if (this.guideline.getParent() == null) {
            this.addFeedback(this.guideline);
        }
        Rectangle bounds = Rectangle.SINGLETON.getCopy();
        bounds.x = this.getCurrentPosition();
        Rectangle containerBounds = this._container.getFigure().getBounds().getCopy();
        this._container.getFigure().translateToAbsolute((Translatable)containerBounds);
        ((DiagramEditPart)this.getCurrentViewer().getContents()).getFigure().translateToRelative((Translatable)containerBounds);
        bounds.y = containerBounds.y;
        bounds.width = 1;
        bounds.height = containerBounds.height;
        this.guideline.setBounds(bounds);
        this.guideline.setVisible(this.getState() == 4);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setMoveDelta(((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta());
        request.setSizeDelta(new Dimension(0, 0));
        request.setEditParts(this._movingShapes);
        ResizableShapeEditPolicyEx.setOtherSelectedEditParts(this._subProcesses, (Request)request);
        for (IGraphicalEditPart part : this._movingShapes) {
            part.showSourceFeedback((Request)request);
        }
        ChangeBoundsRequest spRequest = new ChangeBoundsRequest((Object)"resize");
        Point moveDelta = ((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta().getCopy();
        Dimension spSizeDelta = new Dimension(moveDelta.x, moveDelta.y);
        spRequest.setSizeDelta(spSizeDelta);
        spRequest.setMoveDelta(new Point(0, 0));
        spRequest.setEditParts(this._subProcesses);
        ResizableShapeEditPolicyEx.setOtherSelectedEditParts(this._movingShapes, (Request)spRequest);
        for (IGraphicalEditPart sp : this._subProcesses) {
            sp.showSourceFeedback((Request)spRequest);
        }
    }

    protected Request createSourceRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)this.getCommandName());
        request.setSizeDelta(new Dimension(0, 0));
        return request;
    }

    protected void updateSourceRequest() {
        super.updateSourceRequest();
        int moved = this.getCurrentPosition() - this._initialPosition;
        ((ChangeBoundsRequest)this.getSourceRequest()).setMoveDelta(new Point(moved, 0));
        ((ChangeBoundsRequest)this.getSourceRequest()).setEditParts(this._movingShapes);
    }
}

