/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.tools.ActivityResizeTracker;
import org.eclipse.swt.SWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolResizeTracker
extends ActivityResizeTracker {
    public PoolResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    @Override
    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension dragDelta = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        int direction = this.getResizeDirection();
        List parts = this.getOperationSet();
        request.setConstrainedResize(false);
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        GraphicalEditPart owner = this.getOwner();
        PrecisionRectangle sourceRect = this.getSourceRectangle();
        SnapToHelper snapToHelper = this.getSnapToHelper();
        List<PoolEditPart> siblings = this.collectPoolEditParts(parts);
        if (siblings != null && (direction == 16 || direction == 8)) {
            for (PoolEditPart s : siblings) {
                if (parts.contains((Object)s)) continue;
                parts.add(s);
            }
        }
        boolean northernResize = (request.getResizeDirection() & 1) != 0;
        Dimension minSize = this.getMinPoolSize(parts, northernResize);
        Dimension siblingsMinSize = this.getMinPoolSize(siblings, northernResize);
        Dimension figureSize = owner.getFigure().getSize();
        RootEditPart rootEditPart = owner.getRoot();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart rootSc = (ScalableFreeformRootEditPart)rootEditPart;
            double zoom = rootSc.getZoomManager().getZoom();
            minSize.scale(zoom);
            siblingsMinSize.scale(zoom);
            figureSize.scale(zoom);
            Point pt = ((Viewport)rootSc.getFigure()).getViewLocation();
            figureSize.performTranslate(-pt.x, -pt.y);
            minSize.performTranslate(-pt.x, -pt.y);
            siblingsMinSize.performTranslate(-pt.x, -pt.y);
        }
        if ((direction & 1) != 0 && parts.size() < 2) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.height > figureSize.height - 2 * dragDelta.height) {
                    dragDelta.height = (figureSize.height - minSize.height) / 2;
                }
                resizeDelta.height -= dragDelta.height;
            } else if (minSize.height > figureSize.height - dragDelta.height) {
                dragDelta.height = figureSize.height - minSize.height;
            }
            moveDelta.y += dragDelta.height;
            resizeDelta.height -= dragDelta.height;
        }
        if ((direction & 4) != 0 && parts.size() < 2) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.height > figureSize.height + 2 * dragDelta.height) {
                    dragDelta.height = -(figureSize.height - minSize.height) / 2;
                }
                moveDelta.y -= dragDelta.height;
                resizeDelta.height += dragDelta.height;
            } else if (minSize.height > figureSize.height + dragDelta.height) {
                dragDelta.height = -(figureSize.height - minSize.height);
            }
            resizeDelta.height += dragDelta.height;
        }
        if ((direction & 8) != 0) {
            if (siblingsMinSize.width > figureSize.width - dragDelta.width) {
                dragDelta.width = figureSize.width - siblingsMinSize.width;
            }
            moveDelta.x += dragDelta.width;
            resizeDelta.width -= dragDelta.width;
        }
        if ((direction & 0x10) != 0) {
            if (siblingsMinSize.width > figureSize.width + dragDelta.width) {
                dragDelta.width = -(figureSize.width - siblingsMinSize.width);
            }
            resizeDelta.width += dragDelta.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(parts);
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && snapToHelper != null) {
            PrecisionRectangle rect = sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                }
                result.updateInts();
            }
            moveDelta.x = 16 - this.getSourceRectangle().x;
            PrecisionPoint preciseMove = new PrecisionPoint(moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }

    private List<PoolEditPart> collectPoolEditParts(List selectedParts) {
        for (Object part : selectedParts) {
            if (!(part instanceof PoolEditPart)) continue;
            ArrayList<PoolEditPart> res = new ArrayList<PoolEditPart>();
            PoolEditPart p = (PoolEditPart)((Object)part);
            for (Object child : p.getParent().getChildren()) {
                if (!(child instanceof PoolEditPart)) continue;
                res.add((PoolEditPart)((Object)child));
            }
            return res;
        }
        return null;
    }

    private Dimension getMinPoolSize(List parts, boolean north) {
        Dimension result = new Dimension(200, 50);
        if (parts == null) {
            return result;
        }
        int i = 0;
        while (i < parts.size()) {
            if (parts.get(i) instanceof PoolEditPart) {
                PoolEditPart pool = (PoolEditPart)((Object)parts.get(i));
                IGraphicalEditPart poolCompartment = pool.getChildBySemanticHint(Integer.toString(5001));
                int nameWidth = poolCompartment.getFigure().getBounds().x + 1;
                Point minChildLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
                Dimension maxRoomOfChildren = new Dimension(0, 0);
                for (Object ep : poolCompartment.getChildren()) {
                    if (!(ep instanceof IGraphicalEditPart) || ep instanceof LaneEditPart) continue;
                    IFigure figure = ((IGraphicalEditPart)ep).getFigure();
                    Rectangle bounds = figure.getBounds();
                    maxRoomOfChildren.height = Math.max(bounds.y + bounds.height, maxRoomOfChildren.height);
                    maxRoomOfChildren.width = Math.max(bounds.x + bounds.width, maxRoomOfChildren.width);
                    minChildLocation.x = Math.min(bounds.x, minChildLocation.x);
                    minChildLocation.y = Math.min(bounds.y, minChildLocation.y);
                }
                maxRoomOfChildren.expand(PoolPoolCompartmentEditPart.INSETS.getWidth(), PoolPoolCompartmentEditPart.INSETS.getHeight() + 2);
                minChildLocation.x -= PoolPoolCompartmentEditPart.INSETS.getWidth();
                minChildLocation.y -= PoolPoolCompartmentEditPart.INSETS.getHeight() + 2;
                if (!north) {
                    result.height = Math.max(maxRoomOfChildren.height, result.height);
                    result.width = Math.max(maxRoomOfChildren.width + nameWidth, result.width);
                } else {
                    result.height = Math.max(poolCompartment.getFigure().getBounds().height - minChildLocation.y, result.height);
                    result.width = Math.max(poolCompartment.getFigure().getBounds().width - minChildLocation.x, result.width);
                }
            }
            ++i;
        }
        return result;
    }
}

