/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.MessageVertex;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;
import org.eclipse.swt.graphics.Cursor;

public class TaskDragEditPartsTrackerEx
extends DragEditPartsTrackerEx {
    private static final boolean DO_FIX_LOCATION_TO_AVOID_OVERLAP = false;
    private static final boolean DO_CACHE_LAST_EXECUTABLE_COMMAND = false;
    private int _srcHalfHeight = 0;
    private int _srcHalfWidth = 0;
    private int dLeft = -1;
    private int dRight;
    private int dTop;
    private int dBottom;
    private EObject _sourceModel;
    private Rectangle _tmp = new Rectangle();
    private Rectangle _tmp2 = new Rectangle();
    private static int MAX_DELTA_FROM_LAST_EXECUTABLE_POSITION = 32;
    private static final int _FLAG_SOURCE_FEEDBACK = 256;

    public TaskDragEditPartsTrackerEx(IGraphicalEditPart sourceEditPart) {
        super((EditPart)sourceEditPart);
        Rectangle srcBounds = sourceEditPart.getFigure().getBounds();
        this._sourceModel = sourceEditPart.getPrimaryView().getElement();
        if (srcBounds.height > 0) {
            this._srcHalfHeight = srcBounds.height / 2;
        }
        if (srcBounds.width > 0) {
            this._srcHalfWidth = srcBounds.width / 2;
        }
    }

    private boolean isReparentEnabled() {
        if (this.getTargetEditPart() == null) {
            return false;
        }
        IGraphicalEditPart source = (IGraphicalEditPart)this.getSourceEditPart();
        if (source.resolveSemanticElement() instanceof Activity) {
            Activity a = (Activity)source.resolveSemanticElement();
            if (!a.getIncomingEdges().isEmpty() || !a.getOutgoingEdges().isEmpty()) {
                return false;
            }
            Pool targetPool = this.getPool(((IGraphicalEditPart)this.getTargetEditPart()).resolveSemanticElement());
            if (targetPool == null) {
                return false;
            }
            for (Object msg : a.getOutgoingMessages()) {
                MessageVertex target = ((MessagingEdge)msg).getTarget();
                if (!targetPool.equals(this.getPool(target))) continue;
                return false;
            }
            for (Object msg : a.getIncomingMessages()) {
                MessageVertex src = ((MessagingEdge)msg).getSource();
                if (!targetPool.equals(this.getPool(src))) continue;
                return false;
            }
        } else if (source.resolveSemanticElement() instanceof Artifact) {
            return this.getTargetEditPart() != this.getSourceEditPart().getParent() && this.getTargetEditPart() != null;
        }
        return this.getCurrentInput().isShiftKeyDown();
    }

    private Pool getPool(Object elt) {
        if (elt instanceof Pool) {
            return (Pool)elt;
        }
        if (elt instanceof Activity && ((Activity)elt).getEventHandlerFor() != null) {
            return this.getPool(((Activity)elt).getEventHandlerFor());
        }
        if (elt instanceof Vertex) {
            return this.getPool(((Vertex)elt).getGraph());
        }
        return null;
    }

    protected boolean isMove() {
        boolean isMove = !this.isReparentEnabled();
        return isMove;
    }

    protected boolean isCloneActive() {
        return false;
    }

    protected Command getCommand() {
        if (this.isReparentEnabled()) {
            Request request = this.getTargetRequest();
            if (this.getTargetEditPart() != null) {
                request.setType((Object)"add children");
                Command command = this.getTargetEditPart().getCommand(request);
                return command;
            }
            return UnexecutableCommand.INSTANCE;
        }
        Command res = super.getCommand();
        return res;
    }

    public static void setBoundsForOverlapComputation(IGraphicalEditPart ep, Rectangle result) {
        if (ep instanceof ActivityEditPart) {
            IFigure fig = ((ActivityEditPart)ep).getHandleBoundsFigure();
            result.setBounds(fig.getBounds());
            fig.translateToAbsolute((Translatable)result);
            return;
        }
        if (ep instanceof SubProcessEditPart) {
            SubProcessEditPart sep = (SubProcessEditPart)ep;
            SubProcessEditPart.SubProcessFigure f = sep.getPrimaryShape();
            result.setBounds(f.getHandleBounds());
            f.translateToAbsolute((Translatable)result);
        } else {
            result.setBounds(ep.getFigure().getBounds());
            ep.getFigure().translateToAbsolute((Translatable)result);
        }
    }

    protected Point getLocation() {
        this.isMove();
        return super.getLocation();
    }

    private void computeSourceDistanceFromBorders() {
        if (this.dLeft != -1) {
            return;
        }
        this._tmp.setBounds(((IGraphicalEditPart)this.getSourceEditPart()).getFigure().getBounds());
        ((IGraphicalEditPart)this.getSourceEditPart()).getFigure().translateToAbsolute((Translatable)this._tmp);
        Point start = this.getStartLocation();
        this.dLeft = start.x - this._tmp.x;
        this.dRight = this._tmp.x + this._tmp.width - start.x;
        this.dTop = start.y - this._tmp.y;
        this.dBottom = this._tmp.y + this._tmp.height - start.y;
    }

    protected void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.showSourceFeedback(this.getTargetRequest());
            ++i;
        }
        this.setFlag(256, true);
    }

    protected Cursor calculateCursor() {
        Command command = this.getCurrentCommand();
        if (command == null || !command.canExecute()) {
            return this.getDisabledCursor();
        }
        if (this.isInState(4) || this.isInState(32)) {
            if (this.isMove()) {
                return SharedCursors.HAND;
            }
            if (this.isReparentEnabled()) {
                return SharedCursors.CURSOR_TREE_MOVE;
            }
        }
        return super.calculateCursor();
    }

    protected void executeCurrentCommand() {
        Command curCommand = this.getCurrentCommand();
        if (curCommand != null && curCommand.canExecute()) {
            this.executeCommand(curCommand);
        }
        this.setCurrentCommand(null);
    }

    protected void updateTargetRequest() {
        super.updateTargetRequest();
        if (this.isReparentEnabled()) {
            ResizableShapeEditPolicyEx.setIsChangingScope(true, this.getTargetRequest());
        }
    }
}

