/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.stp.common.validator.core.BaseValidationObject;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.IValidationObjectFactory;
import org.eclipse.stp.common.validator.core.ValidationObjectID;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.core.impl.ISchemaDocumentFactory;
import org.eclipse.stp.common.validator.core.impl.XMLCatalogImpl;
import org.eclipse.stp.common.validator.exception.ConfigurationException;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaDocumentFactoryImpl
implements ISchemaDocumentFactory,
IValidationObjectFactory,
XMLEntityResolver,
LSResourceResolver {
    private static final Logger LOG = Logger.getLogger(SchemaDocumentFactoryImpl.class);
    private static final String WSDL11_SCHEMA_RES_PATH = "conf/wsdl.xsd";
    private static final String SOPWARE_SDX20_RES_PATH = "conf/wsdl-sdx.xsd";
    private static final String SOPWARE_DOC_RES_PATH = "conf/documentation.xsd";
    private static final String SOPWARE_SPDX20_RES_PATH = "conf/wsdl-spdx.xsd";
    private static final String WS_POLICY_RES_PATH = "conf/ws-policy.xsd";
    private static final String WSS_WSSECURITY_RES_PATH = "conf/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final String WSS_WSSECURITY_EXT_RES_PATH = "conf/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String SOPWARE_ASSERTIONS_RES_PATH = "conf/SOPAssertions_21.xsd";
    private static final String SOPWARE_PARTICIPANT_POLICY_RES_PATH = "conf/ParticipantPolicy_21.xsd";
    private static final String XML_SCHEMA_DTD_RES_PATH = "conf/XMLSchema.dtd";
    private static final String XML_SCHEMA_DTD_DATATYPES_RES_PATH = "conf/datatypes.dtd";
    private static final String PARTNER_LINK_RES_PATH = "conf/partner-link.xsd";
    private static final String JMS_TRANSPORT_RES_PATH = "conf/wsdl-jms.xsd";
    private static final String SOAP_TRANSPORT_RES_PATH = "conf/wsdl-soap.xsd";
    private static final String EMPTY_SCHEMA_RES_PATH = "conf/emptyschema.xsd";
    private static SchemaDocumentFactoryImpl instance = null;
    private XMLCatalogImpl catalog = new XMLCatalogImpl();

    private SchemaDocumentFactoryImpl() {
        this.initializeCatalog();
    }

    public static ISchemaDocumentFactory getInstance() {
        if (instance == null) {
            instance = new SchemaDocumentFactoryImpl();
        }
        return instance;
    }

    public URL lookupCatalog(String schemaURI) {
        return this.catalog.resolveCatalogEntry(schemaURI);
    }

    private void initializeCatalog() {
        this.addSchema("http://schemas.xmlsoap.org/wsdl/", WSDL11_SCHEMA_RES_PATH);
        this.addSchema("http://types.sopware.org/service/ServiceDescription/2.0", SOPWARE_SDX20_RES_PATH);
        this.addSchema("http://types.sopware.org/service/Documentation/1.0", SOPWARE_DOC_RES_PATH);
        this.addSchema("http://types.sopware.org/service/ServiceProviderDescription/1.0", SOPWARE_SPDX20_RES_PATH);
        this.addSchema("http://www.w3.org/2006/07/ws-policy", WS_POLICY_RES_PATH);
        this.addSchema("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", WSS_WSSECURITY_RES_PATH);
        this.addSchema("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", WSS_WSSECURITY_EXT_RES_PATH);
        this.addSchema("http://types.sopware.org/qos/SOPAssertions/1.1", SOPWARE_ASSERTIONS_RES_PATH);
        this.addSchema("http://types.sopware.org/qos/ParticipantPolicy/1.1", SOPWARE_PARTICIPANT_POLICY_RES_PATH);
        this.addSchema("-//W3C//DTD XMLSCHEMA 200102//EN", XML_SCHEMA_DTD_RES_PATH);
        this.addSchema("datatypes", XML_SCHEMA_DTD_DATATYPES_RES_PATH);
        this.addSchema("http://schemas.xmlsoap.org/ws/2003/05/partner-link/", PARTNER_LINK_RES_PATH);
        this.addSchema("http://schemas.xmlsoap.org/wsdl/soap/", SOAP_TRANSPORT_RES_PATH);
        this.addSchema("http://schemas.xmlsoap.org/wsdl/jms/", JMS_TRANSPORT_RES_PATH);
        this.addSchema("EMPTY_SCHEMA", EMPTY_SCHEMA_RES_PATH);
    }

    private void addSchema(String uri, String location) {
        URL schemaURL = this.getClass().getClassLoader().getResource(location);
        if (schemaURL != null) {
            this.catalog.addCatalogEntry(uri, schemaURL);
        } else {
            LOG.error((Object)("Unable to retrieve the [" + uri + "]"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IValidationObject getSchemaObject(URI schemaURI, IValidationContext context) throws ContextInitializationException, ConfigurationException {
        IValidationObject schemaObject = null;
        ValidationObjectID schemaObjectID = null;
        QName schemaQName = new QName(schemaURI.toString(), "");
        URL resolvedSchema = this.catalog.resolveCatalogEntry(schemaURI.toString());
        if (resolvedSchema != null) {
            URI resolvedURI = null;
            try {
                resolvedURI = new URI(resolvedSchema.toExternalForm());
            }
            catch (URISyntaxException e) {
                LOG.error((Object)("Unable to remap the resolved URL: " + e.getMessage()), (Throwable)e);
                throw new ContextInitializationException("Unable to remap the resolved URL: " + e.getMessage(), e);
            }
            schemaObjectID = new ValidationObjectID(resolvedSchema.getFile(), schemaQName, resolvedURI, ValidationObjectTypeEnum.XSD_TYPE);
            if (schemaObjectID == null) throw new ContextInitializationException("Unable to initialize schema object registered in XML Catalog");
            return this.createObject(schemaObjectID);
        }
        schemaObjectID = new ValidationObjectID(schemaURI.toString(), schemaQName, schemaURI, ValidationObjectTypeEnum.XSD_TYPE);
        IValidationContext nestedSchemaContext = context.getNestedValidationContext(schemaObjectID);
        if (nestedSchemaContext == null) throw new ContextInitializationException("Unable to initialize schema object from nested context");
        return nestedSchemaContext.getObject();
    }

    public IValidationObject createObject(ValidationObjectID objID) throws ContextInitializationException {
        InputStream is = null;
        try {
            is = objID.getURI().toURL().openStream();
        }
        catch (IOException e) {
            throw new ContextInitializationException("Unable to access the schema document contents stream", e);
        }
        return new BaseValidationObject(objID, is);
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xmlResID) throws XNIException, IOException {
        String schemaURI = xmlResID.getNamespace();
        XMLInputSource xmlInputSource = null;
        LOG.debug((Object)("The entity resolver is asked for [" + schemaURI + "] schema"));
        URL resolvedSchema = this.catalog.resolveCatalogEntry(schemaURI);
        if (resolvedSchema != null) {
            xmlInputSource = new XMLInputSource(xmlResID.getPublicId(), resolvedSchema.toExternalForm(), xmlResID.getBaseSystemId());
        }
        return xmlInputSource;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        DOMInputImpl lsInput = null;
        URL resolvedSchema = null;
        resolvedSchema = namespaceURI != null ? this.catalog.resolveCatalogEntry(namespaceURI) : this.catalog.resolveCatalogEntry(publicId);
        if (resolvedSchema != null) {
            lsInput = new DOMInputImpl(publicId, resolvedSchema.toExternalForm(), baseURI);
        } else {
            LOG.error((Object)("Resource namespaceURI=[" + namespaceURI + "], publicId=[" + publicId + "] cannot be resolved"));
        }
        return lsInput;
    }
}

