/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.sca.transform;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.util.ScaResourceFactoryImpl;

public class SCAModelReader {
    public DocumentRoot loadSCAModel(URI uri) {
        DocumentRoot docRoot = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.osoa.org/xmlns/sca/1.0", (Object)ScaPackage.eINSTANCE);
        Resource resource = null;
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException exception) {
            System.out.println("Problem loading " + uri);
            exception.printStackTrace();
        }
        docRoot = (DocumentRoot)resource.getContents().get(0);
        return docRoot;
    }

    private void printSCADocumentContents(DocumentRoot docRoot) {
        Composite composite = docRoot.getComposite();
        System.out.println("Composite: " + composite.getName());
        for (Service service : composite.getService()) {
            System.out.println("  service: " + service.getName());
        }
        for (Reference ref : composite.getReference()) {
            System.out.println("  ref: " + ref.getName());
        }
        for (Component comp : composite.getComponent()) {
            System.out.println("  * component: " + comp.getName());
            for (ComponentService service : comp.getService()) {
                System.out.println("  * \tservice: " + service.getName());
            }
            for (ComponentReference ref : comp.getReference()) {
                System.out.println("  * \tref: " + ref.getName());
            }
        }
        System.out.println("DONE.");
    }

    private void printEMFResourceContents(Resource resource) {
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject obj = (EObject)iterator.next();
            System.out.println("EMF Object: " + obj.eClass().getName() + " : " + obj.eContents());
        }
    }
}

