/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.stp.im.runtime.ComboProviderValuesProxy;
import org.eclipse.stp.im.runtime.IComboProviderValues;
import org.eclipse.stp.im.runtime.IExpression;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.IService;
import org.eclipse.stp.im.runtime.IServiceBinding;
import org.eclipse.stp.im.runtime.RuntimeDescriptorProxy;
import org.eclipse.stp.im.util.ImLogger;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImRuntimeActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.stp.im.runtime";
    public static final String RUNTIME_DESCRIPTOR_TAG = "runtime-descriptor";
    public static final String COMBO_PROVIDER_VALUES_TAG = "combo-values-provider";
    private static Map<String, RuntimeDescriptorProxy> runtimeDescriptorProxies = null;
    private static Map<String, String> runtimeNameToId = null;
    private static List<String> runtimeNames = null;
    private static Map<String, IRuntime> instantiatedRuntime = null;
    private static Map<String, ComboProviderValuesProxy> comboProviderValuesProxies = null;
    private static Map<String, IComboProviderValues> instantiatedComboProvidersValues = null;
    private static ImRuntimeActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ImRuntimeActivator getDefault() {
        return plugin;
    }

    public static void initRuntimeProxies() {
        if (runtimeDescriptorProxies != null && runtimeNames != null && runtimeNameToId != null) {
            return;
        }
        try {
            IExtensionRegistry extensionPointRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionPointRegistry.getExtensionPoint(PLUGIN_ID, "runtimedescriptor");
            IExtension[] extensions = extensionPoint.getExtensions();
            runtimeDescriptorProxies = new HashMap<String, RuntimeDescriptorProxy>();
            runtimeNames = new ArrayList<String>();
            runtimeNameToId = new HashMap<String, String>();
            instantiatedRuntime = new HashMap<String, IRuntime>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    RuntimeDescriptorProxy proxy = ImRuntimeActivator.parseRuntimeDescriptorProxy(configElements[j]);
                    if (proxy != null) {
                        runtimeDescriptorProxies.put(proxy.getId(), proxy);
                        runtimeNames.add(proxy.getName());
                        runtimeNameToId.put(proxy.getName(), proxy.getId());
                    }
                    ++j;
                }
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            ImLogger.error((String)PLUGIN_ID, (String)t.getMessage(), (Throwable)t);
            runtimeDescriptorProxies = null;
            runtimeNames = null;
            runtimeNameToId = null;
            return;
        }
    }

    public static void initComboProviderValuesProxies() {
        if (comboProviderValuesProxies != null) {
            return;
        }
        try {
            IExtensionRegistry extensionPointRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionPointRegistry.getExtensionPoint(PLUGIN_ID, "combovaluesprovider");
            IExtension[] extensions = extensionPoint.getExtensions();
            comboProviderValuesProxies = new HashMap<String, ComboProviderValuesProxy>();
            instantiatedComboProvidersValues = new HashMap<String, IComboProviderValues>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    ComboProviderValuesProxy proxy = ImRuntimeActivator.parseComboProviderValuesProxies(configElements[j]);
                    if (proxy != null) {
                        comboProviderValuesProxies.put(proxy.getName(), proxy);
                    }
                    ++j;
                }
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            ImLogger.error((String)PLUGIN_ID, (String)t.getMessage(), (Throwable)t);
            comboProviderValuesProxies = null;
            instantiatedComboProvidersValues = null;
            return;
        }
    }

    private static ComboProviderValuesProxy parseComboProviderValuesProxies(IConfigurationElement configElement) {
        if (!configElement.getName().equals(COMBO_PROVIDER_VALUES_TAG)) {
            return null;
        }
        try {
            return new ComboProviderValuesProxy(configElement);
        }
        catch (Exception e) {
            ImLogger.error((String)PLUGIN_ID, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static RuntimeDescriptorProxy parseRuntimeDescriptorProxy(IConfigurationElement configElement) {
        if (!configElement.getName().equals(RUNTIME_DESCRIPTOR_TAG)) {
            return null;
        }
        try {
            return new RuntimeDescriptorProxy(configElement);
        }
        catch (Exception e) {
            ImLogger.error((String)PLUGIN_ID, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static IRuntime getRuntime(String runtimeId) {
        ImRuntimeActivator.initRuntimeProxies();
        IRuntime runtime = instantiatedRuntime.get(runtimeId);
        if (runtime == null) {
            RuntimeDescriptorProxy proxy = runtimeDescriptorProxies.get(runtimeId);
            runtime = proxy.getRuntime();
            IRuntime runtimeExtension = null;
            for (RuntimeDescriptorProxy rdProxy : runtimeDescriptorProxies.values()) {
                if (!Boolean.valueOf(rdProxy.getIsRuntimeExtension()).booleanValue() || !rdProxy.getIdExtendedRuntime().equalsIgnoreCase(runtimeId)) continue;
                runtimeExtension = instantiatedRuntime.get(rdProxy.getId());
                if (runtimeExtension == null) {
                    runtimeExtension = rdProxy.getRuntime();
                    instantiatedRuntime.put(rdProxy.getId(), runtimeExtension);
                }
                for (IServiceBinding aServiceBinding : runtimeExtension.getServiceBindings().values()) {
                    runtime.getServiceBindings().put(aServiceBinding.getName(), aServiceBinding);
                }
                for (IService aService : runtimeExtension.getServices()) {
                    runtime.getServices().add(aService);
                }
                for (IExpression aExpression : runtimeExtension.getExpressions()) {
                    runtime.getExpressions().add(aExpression);
                }
                for (String comboProviderName : runtimeExtension.getComboProviders().keySet()) {
                    runtime.getComboProviders().put(comboProviderName, runtimeExtension.getComboProviders().get(comboProviderName));
                }
                for (String runtimeDndPropertyKey : runtimeExtension.getDnDMatchingProperties().keySet()) {
                    runtime.getDnDMatchingProperties().put(runtimeDndPropertyKey, runtimeExtension.getDnDMatchingProperties().get(runtimeDndPropertyKey));
                }
                runtime.addRuntimeSpecificForExtension(rdProxy.getId(), runtimeExtension.getRuntimeSpecific());
            }
            instantiatedRuntime.put(runtimeId, runtime);
        }
        return runtime;
    }

    public static List<IComboProviderValues> getExternalPluginsComboProviderValues(String comboName) {
        ImRuntimeActivator.initComboProviderValuesProxies();
        ComboProviderValuesProxy comboProviderValuesProxy = null;
        ArrayList<IComboProviderValues> foundComboProviderValues = new ArrayList<IComboProviderValues>();
        IComboProviderValues aComboProviderValues = null;
        for (String name : comboProviderValuesProxies.keySet()) {
            comboProviderValuesProxy = comboProviderValuesProxies.get(name);
            if (!comboProviderValuesProxy.getTargetCombo().equalsIgnoreCase(comboName)) continue;
            aComboProviderValues = instantiatedComboProvidersValues.get(name);
            if (aComboProviderValues == null) {
                aComboProviderValues = comboProviderValuesProxy.getComboProviderValue();
                instantiatedComboProvidersValues.put(name, aComboProviderValues);
            }
            foundComboProviderValues.add(aComboProviderValues);
        }
        return foundComboProviderValues;
    }

    public static String getIdForRuntimeName(String runtimeName) {
        ImRuntimeActivator.initRuntimeProxies();
        return runtimeNameToId.get(runtimeName);
    }

    public static String[] getRuntimeNames() {
        ImRuntimeActivator.initRuntimeProxies();
        String[] resultingNames = null;
        ArrayList<String> arrRuntimeNames = new ArrayList<String>();
        String runtimeName = null;
        String runtimeId = null;
        RuntimeDescriptorProxy runtimeProxy = null;
        int i = 0;
        while (i < runtimeNames.size()) {
            runtimeName = runtimeNames.get(i);
            runtimeId = runtimeNameToId.get(runtimeName);
            runtimeProxy = runtimeDescriptorProxies.get(runtimeId);
            if (!Boolean.valueOf(runtimeProxy.getIsRuntimeExtension()).booleanValue()) {
                arrRuntimeNames.add(runtimeName);
            }
            ++i;
        }
        resultingNames = new String[arrRuntimeNames.size()];
        resultingNames = arrRuntimeNames.toArray(resultingNames);
        return resultingNames;
    }
}

