/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.model.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.stp.policy.model.All;
import org.eclipse.stp.policy.model.Assertion;
import org.eclipse.stp.policy.model.ExactlyOne;
import org.eclipse.stp.policy.model.PolicyComponent;
import org.eclipse.stp.policy.model.PolicyComposite;
import org.eclipse.stp.policy.model.impl.AllImpl;
import org.eclipse.stp.policy.model.impl.AssertionImpl;
import org.eclipse.stp.policy.model.impl.EditorDOMHelper;
import org.eclipse.stp.policy.model.impl.ExactlyOneImpl;
import org.eclipse.stp.policy.model.impl.PolicyProvider;
import org.eclipse.stp.policy.model.impl.PolicyReferenceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicyCompositeImpl
implements PolicyComposite {
    private Element element;

    public Element getElement() {
        return this.element;
    }

    protected void setElement(Element element) {
        this.element = element;
    }

    @Override
    public List<PolicyComponent> getPolicyComponents() {
        ArrayList<PolicyComponent> children = new ArrayList<PolicyComponent>();
        if (this.element != null) {
            NodeList nl = this.element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getNodeType() == 1) {
                    if (node.getLocalName().equals("ExactlyOne")) {
                        children.add(new ExactlyOneImpl((Element)node));
                    } else if (node.getLocalName().equals("All")) {
                        children.add(new AllImpl((Element)node));
                    } else if (node.getLocalName().equals("PolicyReference")) {
                        children.add(new PolicyReferenceImpl((Element)node));
                    } else {
                        children.add(new AssertionImpl((Element)node));
                    }
                }
                ++i;
            }
        }
        return children;
    }

    @Override
    public boolean isEmpty() {
        return this.getPolicyComponents().isEmpty();
    }

    @Override
    public Assertion createAssertion(QName name) {
        PolicyProvider provider = new PolicyProvider(this.getElement().getOwnerDocument());
        Element element = provider.createElement(this.getElement(), name);
        EditorDOMHelper.formatNewElement(element);
        AssertionImpl assertion = new AssertionImpl(element);
        return assertion;
    }

    @Override
    public All createAll() {
        All all = AllImpl.create(this.getElement());
        return all;
    }

    @Override
    public ExactlyOne createExactlyOne() {
        ExactlyOne exactlyOne = ExactlyOneImpl.create(this.getElement());
        return exactlyOne;
    }

    @Override
    public void removePolicyComponent(PolicyComponent component) {
        if (component instanceof PolicyCompositeImpl) {
            EditorDOMHelper.removeNodeAndWhitespace(((PolicyCompositeImpl)component).getElement());
        } else if (component instanceof AssertionImpl) {
            EditorDOMHelper.removeNodeAndWhitespace(((AssertionImpl)component).getElement());
        }
    }

    @Override
    public void serialize(Element parentElement) {
        PolicyProvider provider = new PolicyProvider(parentElement.getOwnerDocument());
        Element element = provider.createElement(parentElement, this.getNodeName());
        for (PolicyComponent component : this.getPolicyComponents()) {
            component.serialize(element);
        }
    }

    protected abstract QName getNodeName();

    public boolean equals(Object obj) {
        if (obj instanceof PolicyCompositeImpl) {
            return this.element.equals(((PolicyCompositeImpl)obj).element);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.element.hashCode();
    }
}

