/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.policy.model.Policy;
import org.eclipse.stp.policy.model.PolicyContainer;
import org.eclipse.stp.policy.model.impl.PolicyImpl;
import org.eclipse.stp.policy.wtp.common.utils.BaseException;
import org.eclipse.stp.policy.wtp.common.utils.DOMProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyContainerImpl
implements PolicyContainer {
    private Document document;
    private List<Policy> children = null;

    public PolicyContainerImpl(Document document) {
        this.document = document;
    }

    public PolicyContainerImpl(IFile filePolicy) throws BaseException {
        if (filePolicy != null && filePolicy.exists()) {
            try {
                DOMProvider providerPolicy = new DOMProvider(filePolicy.getContents());
                this.document = providerPolicy.getDocument();
            }
            catch (BaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public List<Policy> getPolicies() {
        if (this.children == null) {
            this.children = new ArrayList<Policy>();
            this.extractPolicyElements(this.document.getChildNodes());
        }
        return this.children;
    }

    private void extractPolicyElements(NodeList nl) {
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (PolicyImpl.isValidRootElement(element)) {
                    this.children.add(new PolicyImpl(element));
                } else {
                    this.extractPolicyElements(element.getChildNodes());
                }
            }
            ++i;
        }
    }
}

