/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.integration;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.policy.common.editors.IPolicyDetailCallback;
import org.eclipse.stp.policy.common.editors.IPolicyDetailEditorInput;
import org.eclipse.stp.policy.wtp.editor.Activator;
import org.eclipse.stp.policy.wtp.editor.Logger;
import org.eclipse.stp.policy.wtp.editor.preferences.ProjectSettings;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.URLSchemaProvider;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyDetailEditorInput
implements IPolicyDetailEditorInput {
    private String name;
    private IProject project;
    private InputStream stream;
    private IPolicyDetailCallback callback;
    private ISchemaProvider schemaProvider;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final URL[] defaultSchemas = new URL[]{Activator.findPath("/conf/schemas/SOPAssertions_21.xsd"), Activator.findPath("/conf/schemas/ws-policy.xsd"), Activator.findPath("/conf/schemas/oasis-200401-wss-wssecurity-secext-1.0.xsd"), Activator.findPath("/conf/schemas/oasis-200401-wss-wssecurity-utility-1.0.xsd"), Activator.findPath("/conf/schemas/xml.xsd"), Activator.findPath("/conf/schemas/xmldsig-core-schema.xsd")};

    public PolicyDetailEditorInput(String name, InputStream stream, IProject project, IPolicyDetailCallback callback) {
        this.name = name;
        this.project = project;
        this.stream = stream;
        this.callback = callback;
        try {
            ProjectSettings settings = ProjectSettings.getSettings(this.getProject());
            ArrayList<URL> schemas = new ArrayList<URL>(Arrays.asList(defaultSchemas));
            IFolder folder = project.getFolder(settings.getSchemasPath());
            if (folder != null && folder.exists()) {
                IResource[] members = folder.members();
                int i = 0;
                while (i < members.length) {
                    IFile file;
                    if (members[i].getType() == 1 && (file = (IFile)members[i]).getFileExtension().equalsIgnoreCase("xsd")) {
                        schemas.add(file.getLocationURI().toURL());
                    }
                    ++i;
                }
            }
            this.schemaProvider = new URLSchemaProvider(schemas.toArray(new URL[schemas.size()]), new XMLSnippet[0]);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        this.properties.put("TITLE", name);
    }

    public IPolicyDetailCallback getCallback() {
        return this.callback;
    }

    public IProject getProject() {
        return this.project;
    }

    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ISchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolicyDetailEditorInput) {
            return this.callback.equals(((PolicyDetailEditorInput)obj).callback);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.callback.hashCode();
    }
}

