/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.properties.sections;

import org.eclipse.stp.policy.wtp.editor.Messages;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PlatformUI;

public class SectionHelper {
    public static final String VALUE_CLEAR = Messages.SectionHelper_VALUE_CLEAR;
    public static final String MESSAGE_CLEARED = Messages.SectionHelper_MESSAGE_CLEARED;
    public static final String MESSAGE_INVALID_VALUE = Messages.SectionHelper_MESSAGE_INVALID_VALUE;
    public static final String MESSAGE_MANDATORY = Messages.SectionHelper_MESSAGE_MANDATORY;
    public static final String MESSAGE_FORBIDDEN = Messages.SectionHelper_MESSAGE_FORBIDDEN;
    public static final String MESSAGE_RANGE_0_9 = Messages.SectionHelper_MESSAGE_RANGE_0_9;
    private static final GridData gdFill = new GridData(4, 0, true, false);
    private static final ToolTip tooltipError = new ToolTip(SectionHelper.getActiveShell(), 4097);
    private static final ToolTip tooltipInfo = new ToolTip(SectionHelper.getActiveShell(), 4098);
    private static final GridData gdLabel = new GridData(120, -1);

    static {
        tooltipError.setAutoHide(false);
    }

    private SectionHelper() {
    }

    public static final GridData getFillGridData() {
        return gdFill;
    }

    public static final GridData getLabelGridData() {
        return gdLabel;
    }

    public static final Shell getActiveShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static final void showErrorTooltip(String text, Point location) {
        tooltipError.setLocation(location);
        tooltipError.setText(Messages.ParticipantPolicyModel_ERROR);
        tooltipError.setMessage(text);
        tooltipError.setVisible(true);
    }

    public static final void showErrorTooltip(String text, Control control) {
        SectionHelper.showErrorTooltip(text, SectionHelper.getTooltipLocation(control));
    }

    public static final void hideErrorTooltip() {
        tooltipError.setVisible(false);
    }

    public static final void showInfoTooltip(String text, Point location) {
        tooltipInfo.setLocation(location);
        tooltipInfo.setText(text);
        tooltipInfo.setVisible(true);
    }

    public static final void showInfoTooltip(String text, Control control) {
        SectionHelper.showInfoTooltip(text, SectionHelper.getTooltipLocation(control));
    }

    private static final Point getTooltipLocation(Control control) {
        return control.getParent().toDisplay(control.getLocation());
    }

    public static final Point getCaretLocation(CCombo ccombo) {
        GC gc = new GC((Drawable)ccombo);
        Point pt = ccombo.getSelection();
        String text = ccombo.getText().substring(0, pt.x);
        Point ptExtent = gc.textExtent(text);
        pt = SectionHelper.getTooltipLocation((Control)ccombo);
        pt.x += ptExtent.x;
        pt.y += ccombo.getTextHeight();
        return pt;
    }

    public static final Point getCaretLocation(Text text) {
        Point ptCaret = text.getCaretLocation();
        Point pt = SectionHelper.getTooltipLocation((Control)text);
        pt.x += ptCaret.x;
        pt.y += text.getLineHeight();
        return pt;
    }

    public static final void adaptComposite(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        layout.marginRight = 50;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
    }
}

