/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.extensions;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.JavaImplementation;
import org.eclipse.stp.sca.JavaInterface;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.Wire;
import org.eclipse.stp.sca.common.internal.provisional.builder.ScaAbstractValidationExtension;
import org.eclipse.stp.sca.common.java.Messages;
import org.eclipse.stp.sca.common.java.classloader.ScaJdtClassLoader;
import org.eclipse.stp.sca.common.java.utils.JDTUtils;
import org.eclipse.stp.sca.common.utils.ResourceUtils;
import org.eclipse.stp.sca.introspection.IntrospectionUtils;
import org.eclipse.stp.sca.introspection.metadata.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaJavaBuilderExtension
extends ScaAbstractValidationExtension {
    private File scaFile;
    private IJavaProject javaProject;
    private Map<String, JavaToCompositeElement> classNameToJavaElt;
    private Map<Component, String> componentNameToJavaImpl;
    private List<JavaCompatibilityElement> promotes;
    private List<JavaCompatibilityElement> impls;
    private List<JavaCompatibilityElement> wires;

    public boolean initialize(DocumentRoot documentRoot, File scaFile) {
        IFile f = ResourceUtils.getIFile((File)scaFile);
        if (f == null) {
            return false;
        }
        this.scaFile = scaFile;
        this.javaProject = JDTUtils.getJavaProject(f.getProject());
        if (this.javaProject == null) {
            return false;
        }
        this.classNameToJavaElt = new HashMap<String, JavaToCompositeElement>();
        this.componentNameToJavaImpl = new HashMap<Component, String>();
        this.impls = new ArrayList<JavaCompatibilityElement>();
        this.wires = new ArrayList<JavaCompatibilityElement>();
        this.promotes = new ArrayList<JavaCompatibilityElement>();
        this.buildJavaRelations(documentRoot, this.javaProject);
        return true;
    }

    private void buildJavaRelations(DocumentRoot documentRoot, IJavaProject javaProject) {
        JavaCompatibilityElement jce;
        JavaToCompositeElement jtc;
        Composite c = documentRoot.getComposite();
        if (c == null) {
            return;
        }
        for (Service s : c.getService()) {
            if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
            jtc = new JavaToCompositeElement();
            jtc._class = ((JavaInterface)s.getInterface()).getInterface();
            jtc.eobject = s.getInterface();
            this.classNameToJavaElt.put(jtc._class, jtc);
            if (s.getPromote2() == null || s.getPromote2().getInterface() == null || !(s.getPromote2().getInterface() instanceof JavaInterface)) continue;
            jce = new JavaCompatibilityElement();
            jce._superClass.add(jtc._class);
            jce._class = ((JavaInterface)s.getPromote2().getInterface()).getInterface();
            this.promotes.add(jce);
        }
        for (Wire w : c.getWire()) {
            JavaCompatibilityElement jce2 = new JavaCompatibilityElement();
            if (w.getSource2() != null && w.getSource2().getInterface() != null && w.getSource2().getInterface() instanceof JavaInterface) {
                jce2._superClass.add(((JavaInterface)w.getSource2().getInterface()).getInterface());
            }
            if (w.getTarget2() != null && w.getTarget2().getInterface() != null && w.getTarget2().getInterface() instanceof JavaInterface) {
                jce2._class = ((JavaInterface)w.getTarget2().getInterface()).getInterface();
            }
            if (jce2._class == null || jce2._superClass == null) continue;
            this.wires.add(jce2);
        }
        for (Reference r : c.getReference()) {
            if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
            jtc = new JavaToCompositeElement();
            jtc._class = ((JavaInterface)r.getInterface()).getInterface();
            jtc.eobject = r.getInterface();
            this.classNameToJavaElt.put(jtc._class, jtc);
            if (r.getPromote2() == null || r.getPromote2().getInterface() == null || !(r.getPromote2().getInterface() instanceof JavaInterface)) continue;
            jce = new JavaCompatibilityElement();
            jce._class = jtc._class;
            jce._superClass.add(((JavaInterface)r.getPromote2().getInterface()).getInterface());
            this.promotes.add(jce);
        }
        for (Component comp : c.getComponent()) {
            JavaCompatibilityElement jceComponent = new JavaCompatibilityElement();
            if (comp.getImplementation() != null && comp.getImplementation() instanceof JavaImplementation) {
                JavaToCompositeElement jtcComponent = new JavaToCompositeElement();
                jtcComponent.isInterface = false;
                jtcComponent._class = ((JavaImplementation)comp.getImplementation()).getClass_();
                jtcComponent.eobject = comp.getImplementation();
                this.classNameToJavaElt.put(jtcComponent._class, jtcComponent);
                jceComponent._class = jtcComponent._class;
                this.componentNameToJavaImpl.put(comp, jtcComponent._class);
            }
            for (ComponentService s : comp.getService()) {
                if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
                JavaToCompositeElement jtcService = new JavaToCompositeElement();
                jtcService._class = ((JavaInterface)s.getInterface()).getInterface();
                jtcService.eobject = s.getInterface();
                this.classNameToJavaElt.put(jtcService._class, jtcService);
                jceComponent._superClass.add(jtcService._class);
            }
            this.impls.add(jceComponent);
            for (ComponentReference r : comp.getReference()) {
                if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
                JavaToCompositeElement jtc2 = new JavaToCompositeElement();
                jtc2._class = ((JavaInterface)r.getInterface()).getInterface();
                jtc2.eobject = r.getInterface();
                this.classNameToJavaElt.put(jtc2._class, jtc2);
                if (r.getTarget2() == null || r.getTarget2().getInterface() == null || !(r.getTarget2().getInterface() instanceof JavaInterface)) continue;
                JavaCompatibilityElement jce3 = new JavaCompatibilityElement();
                jce3._class = ((JavaInterface)r.getTarget2().getInterface()).getInterface();
                jce3._superClass.add(jtc2._class);
                this.wires.add(jce3);
            }
        }
    }

    public Map<Diagnostic, File> validateInterfaceCompatibilityInPromotes() {
        HashMap<Diagnostic, File> result = new HashMap<Diagnostic, File>();
        for (JavaCompatibilityElement jce : this.promotes) {
            JavaToCompositeElement elt = this.classNameToJavaElt.get(jce._class);
            if (elt == null || !elt.isInClassPath || this.isEqual(jce._class, jce._superClass)) continue;
            List<String> notImplemented = JDTUtils.implementsOrExtendsAll(this.javaProject, jce._class, jce._superClass);
            for (String ni : notImplemented) {
                String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_17, (Object[])new Object[]{jce._class, ni});
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, "", 0, msg, new Object[]{elt.eobject});
                result.put((Diagnostic)diagnostic, this.scaFile);
            }
        }
        return result;
    }

    public Map<Diagnostic, File> validateInterfaceCompatibilityInWires() {
        HashMap<Diagnostic, File> result = new HashMap<Diagnostic, File>();
        for (JavaCompatibilityElement jce : this.wires) {
            JavaToCompositeElement elt = this.classNameToJavaElt.get(jce._class);
            if (elt == null || !elt.isInClassPath || this.isEqual(jce._class, jce._superClass)) continue;
            List<String> notImplemented = JDTUtils.implementsOrExtendsAll(this.javaProject, jce._class, jce._superClass);
            for (String ni : notImplemented) {
                String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_3, (Object[])new Object[]{jce._class, ni});
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, "", 0, msg, new Object[]{elt.eobject});
                result.put((Diagnostic)diagnostic, this.scaFile);
            }
        }
        return result;
    }

    public Map<Diagnostic, File> validateInterfaceImplementations() {
        HashMap<Diagnostic, File> result = new HashMap<Diagnostic, File>();
        for (JavaCompatibilityElement jce : this.impls) {
            JavaToCompositeElement elt = this.classNameToJavaElt.get(jce._class);
            if (elt == null || !elt.isInClassPath || this.isEqual(jce._class, jce._superClass)) continue;
            List<String> notImplemented = JDTUtils.implementsOrExtendsAll(this.javaProject, jce._class, jce._superClass);
            for (String ni : notImplemented) {
                String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_30, (Object[])new Object[]{jce._class, ni});
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, "", 0, msg, new Object[]{elt.eobject});
                result.put((Diagnostic)diagnostic, this.scaFile);
            }
        }
        return result;
    }

    public Map<Diagnostic, File> validateOthers() {
        return Collections.emptyMap();
    }

    public Map<Diagnostic, File> validatePreRequisites() {
        HashMap<Diagnostic, File> result = new HashMap<Diagnostic, File>();
        for (JavaToCompositeElement jtc : this.classNameToJavaElt.values()) {
            if (jtc._class == null) {
                String msg = Messages.ScaBuilderJavaExtension_7;
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, "", 0, msg, new Object[]{jtc.eobject});
                result.put((Diagnostic)diagnostic, this.scaFile);
                continue;
            }
            try {
                BasicDiagnostic diagnostic;
                String msg;
                Diagnostic diag = JDTUtils.validateJavaTypeName(jtc._class, jtc.eobject);
                if (diag != null) {
                    result.put(diag, this.scaFile);
                    continue;
                }
                IType iType = this.javaProject.findType(jtc._class);
                if (iType == null) {
                    msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_22, (Object)jtc._class);
                    diagnostic = new BasicDiagnostic(2, "", 0, msg, new Object[]{jtc.eobject});
                    result.put((Diagnostic)diagnostic, this.scaFile);
                    continue;
                }
                jtc.isInClassPath = true;
                if (jtc.isInterface) {
                    if (iType.isInterface()) continue;
                    msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_13, (Object)jtc._class);
                    diagnostic = new BasicDiagnostic(4, "", 0, msg, new Object[]{jtc.eobject});
                    result.put((Diagnostic)diagnostic, this.scaFile);
                    continue;
                }
                if (iType.isClass()) continue;
                msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_25, (Object)jtc._class);
                diagnostic = new BasicDiagnostic(4, "", 0, msg, new Object[]{jtc.eobject});
                result.put((Diagnostic)diagnostic, this.scaFile);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Map<Diagnostic, File> validateReferencesInImplementations() {
        HashMap<Diagnostic, File> result = new HashMap<Diagnostic, File>();
        ScaJdtClassLoader scaCl = new ScaJdtClassLoader(this.javaProject, ((Object)((Object)this)).getClass().getClassLoader());
        for (Map.Entry<Component, String> entry : this.componentNameToJavaImpl.entrySet()) {
            if (!this.classNameToJavaElt.get((Object)entry.getValue()).isInClassPath) continue;
            try {
                Class implClass = scaCl.loadClass(entry.getValue());
                MetaData md = new MetaData(implClass);
                AccessibleObject[] objects = md.getAllAnnotatedMethodsAndFields(org.osoa.sca.annotations.Reference.class);
                ArrayList<String> javaReferences = new ArrayList<String>();
                AccessibleObject[] accessibleObjectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleObject o = accessibleObjectArray[n2];
                    String refName = IntrospectionUtils.getReferenceName((AccessibleObject)o);
                    javaReferences.add(refName);
                    ++n2;
                }
                for (ComponentReference cr : entry.getKey().getReference()) {
                    if (javaReferences.contains(cr.getName())) continue;
                    String msg = "The reference \"" + cr.getName() + "\" is declared in the composite but cannot be found in the implementation " + "\"" + entry.getValue() + "\".";
                    BasicDiagnostic diagnostic = new BasicDiagnostic(4, "", 0, msg, new Object[]{cr});
                    result.put((Diagnostic)diagnostic, this.scaFile);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean isEqual(String className, List<String> superClassNames) {
        return superClassNames.size() == 1 && superClassNames.get(0).equals(className);
    }

    private class JavaCompatibilityElement {
        String _class;
        List<String> _superClass = new ArrayList<String>();

        private JavaCompatibilityElement() {
        }
    }

    private class JavaToCompositeElement {
        String _class;
        boolean isInterface = true;
        boolean isInClassPath = false;
        EObject eobject;

        private JavaToCompositeElement() {
        }
    }
}

