/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.provider.ScaItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaDependencyVertex {
    private File file;
    private QName name;
    private List<QName> includes = new ArrayList<QName>();
    private boolean isValidEmfFile = true;
    private Resource resource;

    protected ScaDependencyVertex(File file) {
        this.file = file;
        this.loadResource();
    }

    private void loadResource() {
        try {
            Resource resource = this.getEmfResource();
            if (resource == null) {
                return;
            }
            DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
            if (root.getComposite() != null) {
                this.name = new QName(root.getComposite().getTargetNamespace(), root.getComposite().getName());
                if (root.getInclude() != null && root.getInclude().getName() != null) {
                    this.name = new QName(root.getInclude().getName().getNamespaceURI(), root.getInclude().getName().getLocalPart());
                }
            } else {
                this.isValidEmfFile = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Resource getEmfResource() {
        if (this.resource == null && this.isValidEmfFile) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new ScaItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            BasicCommandStack commandStack = new BasicCommandStack();
            AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
            try {
                URI uri = URI.createFileURI((String)this.file.getAbsolutePath());
                this.resource = editingDomain.getResourceSet().getResource(uri, true);
            }
            catch (Exception e) {
                this.isValidEmfFile = false;
                e.printStackTrace();
            }
        }
        return this.resource;
    }

    public File getFile() {
        return this.file;
    }

    public QName getName() {
        return this.name;
    }

    public List<QName> getIncludes() {
        return this.includes;
    }

    public boolean isValidEmfFile() {
        return this.isValidEmfFile;
    }
}

