/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.sca.common.ScaCommonPlugin;
import org.eclipse.stp.sca.common.internal.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ComponentTypeCreationWizard
extends Wizard
implements INewWizard {
    private CTCreationPage page;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private IFile createdFile;
    public static final String CT_EXTENSION = "componentType";
    public static final String CT_BASIC_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<sca:componentType\n\txmlns=\"http://www.osoa.org/xmlns/sca/1.0\"\n\txmlns:sca=\"http://www.osoa.org/xmlns/sca/1.0\">\n\n</sca:componentType>";

    public void addPages() {
        this.page = new CTCreationPage("MainPage", this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            this.createdFile = this.page.createNewFile();
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)this.createdFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                String editorId = this.workbench.getEditorRegistry().getDefaultEditor(this.createdFile.getFullPath().toString()).getId();
                page.openEditor((IEditorInput)new FileEditorInput(this.createdFile), editorId);
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Messages.ComponentTypeCreationWizard_8, (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common", Messages.ComponentTypeCreationWizard_0, (Throwable)e);
            ScaCommonPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        this.setWindowTitle(Messages.ComponentTypeCreationWizard_9);
        ImageDescriptor desc = ScaCommonPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stp.sca.common", (String)"icons/wizban/ComponentTypeBanner.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public class CTCreationPage
    extends WizardNewFileCreationPage {
        private String selectionName;

        public CTCreationPage(String pageName, IStructuredSelection selection) {
            int index;
            String fileName;
            super(pageName, selection);
            this.selectionName = "";
            this.setFileExtension(ComponentTypeCreationWizard.CT_EXTENSION);
            this.setTitle(Messages.ComponentTypeCreationWizard_7);
            this.setDescription(Messages.ComponentTypeCreationWizard_6);
            if (selection != null && selection.getFirstElement() != null && selection.getFirstElement() instanceof IFile && !(fileName = ((IFile)selection.getFirstElement()).getName()).endsWith(".componentType") && (index = fileName.lastIndexOf(46)) > 0) {
                this.selectionName = fileName.substring(0, index);
            }
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            String initialName = this.selectionName.trim();
            initialName = initialName.length() > 0 ? String.valueOf(initialName) + "." + ComponentTypeCreationWizard.CT_EXTENSION : "default.componentType";
            this.setFileName(initialName);
            boolean pageEnabled = this.validatePage();
            this.setErrorMessage(null);
            this.setPageComplete(pageEnabled);
        }

        protected boolean validatePage() {
            boolean valid = super.validatePage();
            String name = this.getFileName();
            int dotPosition = name.lastIndexOf(46);
            String string = name = dotPosition >= 0 ? name.substring(0, dotPosition) : name;
            if (valid && name.length() == 0) {
                this.setErrorMessage(Messages.ComponentTypeCreationWizard_12);
                valid = false;
            }
            this.setPageComplete(valid);
            return valid;
        }

        protected InputStream getInitialContents() {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(ComponentTypeCreationWizard.CT_BASIC_TEMPLATE.getBytes());
            return inputStream;
        }
    }
}

