/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFilterUtils<T extends IResource> {
    public List<T> filterAllowedResources(Collection<T> resourcesToFilter, Collection<IFolder> foldersToSkip) {
        if (resourcesToFilter.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (IResource res : resourcesToFilter) {
            IPath resPath = res.getProjectRelativePath();
            boolean resIsInFolder = false;
            for (IFolder projectFolder : foldersToSkip) {
                IPath folderPath = projectFolder.getProjectRelativePath();
                if (!folderPath.isPrefixOf(resPath)) continue;
                resIsInFolder = true;
                break;
            }
            if (resIsInFolder) continue;
            result.add(res);
        }
        return result;
    }
}

