/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.extension.edit.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.BaseReference;
import org.eclipse.stp.sca.BaseService;
import org.eclipse.stp.sca.Binding;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.Interface;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.diagram.extension.edit.part.BindingInformation;
import org.eclipse.stp.sca.diagram.extension.edit.part.ElementInformation;
import org.eclipse.stp.sca.diagram.extension.edit.part.ElementInformationRegistry;
import org.eclipse.stp.sca.diagram.extension.edit.part.ElementType;
import org.eclipse.stp.sca.diagram.extension.edit.part.ImplementationInformation;
import org.eclipse.stp.sca.diagram.extension.edit.part.InterfaceInformation;
import org.eclipse.stp.sca.diagram.part.ScaNodeDescriptor;

class Utils {
    Utils() {
    }

    public static List getSemanticReferenceBindingChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseReference modelElement = (BaseReference)containerView.getElement();
        return Utils.getSemanticElementChildrenList(modelElement.getBinding(), viewObject, ElementType.BINDING);
    }

    public static List getSemanticServiceBindingChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseService modelElement = (BaseService)containerView.getElement();
        return Utils.getSemanticElementChildrenList(modelElement.getBinding(), viewObject, ElementType.BINDING);
    }

    private static List getSemanticElementChildrenList(EList elements, View viewObject, ElementType type) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (Binding childElement : elements) {
            for (ElementInformation bindingInformation : ElementInformationRegistry.getInstance().getAllElementInformations(type)) {
                int visualID = bindingInformation.getVisualIDRegistry().getNodeVisualID(viewObject, (EObject)childElement);
                if (visualID != bindingInformation.getVisualID()) continue;
                list.add(new ScaNodeDescriptor((EObject)childElement, visualID).getModelElement());
            }
        }
        return list;
    }

    public static Boolean isOrphanedBinding(Collection semanticChildren, View view, EditPart editPart) {
        for (ElementInformation bindingInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.BINDING)) {
            if (org.eclipse.stp.sca.diagram.extension.edit.part.Utils.getVisualID(view) != bindingInformation.getVisualID()) continue;
            return new Boolean(!semanticChildren.contains(view.getElement()) || org.eclipse.stp.sca.diagram.extension.edit.part.Utils.getVisualID(view) != bindingInformation.getVisualIDRegistry().getNodeVisualID((View)editPart.getModel(), view.getElement()));
        }
        return null;
    }

    public static ICommand getCreateReferenceBindingCommand(CreateElementRequest req) {
        for (ElementInformation bindingInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.BINDING)) {
            if (bindingInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseReference_Binding());
            }
            return ((BindingInformation)bindingInformation).createReferenceBindingCommand(req);
        }
        return null;
    }

    public static ICommand getCreateServiceBindingCommand(CreateElementRequest req) {
        for (ElementInformation bindingInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.BINDING)) {
            if (bindingInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseService_Binding());
            }
            return ((BindingInformation)bindingInformation).createServiceBindingCommand(req);
        }
        return null;
    }

    public static List getSemanticReferenceInterfaceChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseReference modelElement = (BaseReference)containerView.getElement();
        return Utils.getSemanticInterfaceChildrenList(modelElement.getInterface(), viewObject);
    }

    public static List getSemanticServiceInterfaceChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseService modelElement = (BaseService)containerView.getElement();
        return Utils.getSemanticInterfaceChildrenList(modelElement.getInterface(), viewObject);
    }

    private static List getSemanticInterfaceChildrenList(Interface interfacee, View viewObject) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (ElementInformation interfaceInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.INTERFACE)) {
            int visualID = interfaceInformation.getVisualIDRegistry().getNodeVisualID(viewObject, (EObject)interfacee);
            if (visualID != interfaceInformation.getVisualID()) continue;
            list.add(new ScaNodeDescriptor((EObject)interfacee, visualID).getModelElement());
        }
        return list;
    }

    public static Boolean isOrphanedInterface(Collection semanticChildren, View view, EditPart editPart) {
        for (ElementInformation interfaceInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.INTERFACE)) {
            if (org.eclipse.stp.sca.diagram.extension.edit.part.Utils.getVisualID(view) != interfaceInformation.getVisualID()) continue;
            return new Boolean(!semanticChildren.contains(view.getElement()) || org.eclipse.stp.sca.diagram.extension.edit.part.Utils.getVisualID(view) != interfaceInformation.getVisualIDRegistry().getNodeVisualID((View)editPart.getModel(), view.getElement()));
        }
        return null;
    }

    public static ICommand getCreateReferenceInterfaceCommand(CreateElementRequest req) {
        for (ElementInformation interfaceInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.INTERFACE)) {
            if (interfaceInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseReference_Interface());
            }
            return ((InterfaceInformation)interfaceInformation).createReferenceInterfaceCommand(req);
        }
        return null;
    }

    public static ICommand getCreateServiceInterfaceCommand(CreateElementRequest req) {
        for (ElementInformation interfaceInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.INTERFACE)) {
            if (interfaceInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseService_Interface());
            }
            return ((InterfaceInformation)interfaceInformation).createServiceInterfaceCommand(req);
        }
        return null;
    }

    public static List getSemanticComponentImplementationChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        Component modelElement = (Component)containerView.getElement();
        return Utils.getSemanticImplementationChildrenList(modelElement.getImplementation(), viewObject);
    }

    private static List getSemanticImplementationChildrenList(Implementation implementation, View viewObject) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (ElementInformation implementationInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.IMPLEMENTATION)) {
            int visualID = implementationInformation.getVisualIDRegistry().getNodeVisualID(viewObject, (EObject)implementation);
            if (visualID != implementationInformation.getVisualID()) continue;
            list.add(new ScaNodeDescriptor((EObject)implementation, visualID).getModelElement());
        }
        return list;
    }

    public static Boolean isOrphanedImplementation(Collection semanticChildren, View view, EditPart editPart) {
        for (ElementInformation implementationInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.IMPLEMENTATION)) {
            if (org.eclipse.stp.sca.diagram.extension.edit.part.Utils.getVisualID(view) != implementationInformation.getVisualID()) continue;
            return new Boolean(!semanticChildren.contains(view.getElement()) || org.eclipse.stp.sca.diagram.extension.edit.part.Utils.getVisualID(view) != implementationInformation.getVisualIDRegistry().getNodeVisualID((View)editPart.getModel(), view.getElement()));
        }
        return null;
    }

    public static ICommand getCreateComponentImplementationCommand(CreateElementRequest req) {
        for (ElementInformation implementationInformation : ElementInformationRegistry.getInstance().getAllElementInformations(ElementType.IMPLEMENTATION)) {
            if (implementationInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getComponent_Implementation());
            }
            return ((ImplementationInformation)implementationInformation).createImplementationCommand(req);
        }
        return null;
    }
}

