/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.edit.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.xml.type.internal.QName;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stp.sca.edit.provider.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameEditorDialog
extends Dialog {
    private ILabelProvider labelProvider;
    private IContentProvider contentProvider;
    private QName currentValue;
    private List<String> choiceOfValues;
    private QName result;
    private Combo namespaces;
    private Text namespace;
    private Text localPart;

    public QNameEditorDialog(Shell parent, ILabelProvider labelProvider, QName currentValue, List<String> choiceOfValues) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.labelProvider = labelProvider;
        this.choiceOfValues = choiceOfValues;
        this.currentValue = currentValue;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(Collections.emptyList());
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.currentValue != null) {
            shell.setText("QName: " + this.currentValue.toString());
            shell.setImage(this.labelProvider.getImage((Object)this.currentValue));
        }
        shell.setSize(500, 180);
        Rectangle rect = shell.getDisplay().getClientArea();
        Point size = shell.getSize();
        int x = (rect.width - size.x) / 2;
        int y = (rect.height - size.y) / 2;
        shell.setLocation(new Point(x, y));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        contents.setLayout((Layout)new GridLayout(2, false));
        Label currentSelectedNamespace = new Label(contents, 0);
        currentSelectedNamespace.setText(Messages.getString("QNameEditorDialog.0"));
        this.namespace = new Text(contents, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.namespace.setLayoutData((Object)gridData);
        if (this.currentValue != null) {
            this.namespace.setText(this.currentValue.getNamespaceURI());
        }
        Label choiceLabel = new Label(contents, 0);
        choiceLabel.setText(Messages.getString("QNameEditorDialog.1"));
        this.namespaces = new Combo(contents, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.namespaces.setLayoutData((Object)gridData);
        if (this.choiceOfValues != null && !this.choiceOfValues.isEmpty()) {
            this.namespaces.setItems(this.choiceOfValues.toArray(new String[1]));
        }
        Label localPartLabel = new Label(contents, 0);
        localPartLabel.setText(Messages.getString("QNameEditorDialog.2"));
        this.localPart = new Text(contents, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.localPart.setLayoutData((Object)gridData);
        if (this.currentValue != null) {
            this.localPart.setText(this.currentValue.getLocalPart());
        }
        this.localPart.setFocus();
        this.namespaces.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = QNameEditorDialog.this.namespaces.getSelectionIndex();
                QNameEditorDialog.this.namespace.setText(QNameEditorDialog.this.namespaces.getItem(index));
            }
        });
        return contents;
    }

    protected void okPressed() {
        this.result = this.localPart.getText() == null || "".equals(this.localPart.getText()) ? null : new QName(this.namespace.getText(), this.localPart.getText(), null);
        super.okPressed();
    }

    protected void cancelPressed() {
        this.result = this.currentValue;
        super.cancelPressed();
    }

    public boolean close() {
        this.contentProvider.dispose();
        return super.close();
    }

    public QName getResult() {
        return this.result;
    }
}

