/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class AbstractResources {
    private static final Logger LOG = Logger.getLogger(AbstractResources.class.getName());
    private static final String IMAGE_FOLDER_RELATIVE_PATH = "icons/";

    protected AbstractResources() {
    }

    public static final String getString(ResourceBundle bundle, String key) {
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static final String[] getStringArray(ResourceBundle bundle, String key) {
        ArrayList<String> values = new ArrayList<String>();
        String value = AbstractResources.getString(bundle, key);
        if (value != null && !value.equals("") && !value.equals(key)) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token == null || token.equals("")) continue;
                values.add(token);
            }
        }
        return values.toArray(new String[0]);
    }

    public static final String getFromMsgFormat(ResourceBundle bundle, String strKey, String strConcatValues, boolean fValuesIsKey) {
        String strMsg = AbstractResources.getString(bundle, strKey);
        String strConcat = null;
        strConcat = fValuesIsKey ? AbstractResources.getString(bundle, strConcatValues) : strConcatValues;
        Object[] aObj = null;
        if (strConcat != null) {
            StringTokenizer st = new StringTokenizer(strConcat, ",");
            aObj = new Object[st.countTokens()];
            int x = -1;
            while (st.hasMoreTokens()) {
                aObj[++x] = st.nextToken();
            }
        }
        if (aObj != null && aObj.length > 0) {
            return MessageFormat.format(strMsg, aObj);
        }
        return strMsg;
    }

    public static final ImageDescriptor getImageDescriptor(Bundle bundle, String imageName) {
        URL url = AbstractResources.getImageUrl(bundle, imageName);
        return url != null ? ImageDescriptor.createFromURL((URL)url) : ImageDescriptor.getMissingImageDescriptor();
    }

    public static final URL getImageUrl(Bundle bundle, String imageName) {
        if (bundle == null) {
            return null;
        }
        try {
            URL baseURL = bundle.getEntry("/");
            return new URL(baseURL, IMAGE_FOLDER_RELATIVE_PATH + imageName);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "image URL invalid (image probably missing)", e);
            return null;
        }
    }
}

