/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;

public class XEFEditorURIResolverExtension
implements URIResolverExtension,
ISelectionListener {
    private static volatile int counter = 0;
    private Map<String, String> uriMap = Collections.synchronizedMap(new HashMap());
    XMLProviderEditorInput xmlProviderEditorInput;

    public XEFEditorURIResolverExtension() {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        if (d != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
                    ISelectionService ss = aww.getSelectionService();
                    ss.addSelectionListener((ISelectionListener)XEFEditorURIResolverExtension.this);
                }
            });
        }
    }

    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        String schema;
        String uri = this.uriMap.get(publicId);
        if (uri != null) {
            return uri;
        }
        XMLProviderEditorInput xei = this.xmlProviderEditorInput;
        if (xei != null && (schema = xei.getSchemaProvider().getSchema(publicId)) != null) {
            IProject project = xei.getProject();
            IFile tempFile = project.getFile(".xsd.tmp" + System.currentTimeMillis() + "_" + counter++ + ".xsd");
            tempFile.getLocation().toFile().deleteOnExit();
            try {
                tempFile.create((InputStream)new ByteArrayInputStream(schema.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                String storedUri = tempFile.getLocationURI().toString();
                this.uriMap.put(publicId, storedUri);
                return storedUri;
            }
            catch (CoreException e) {
                Status st = new Status(2, "org.eclipse.stp.xef", 0, "Problem resolving schema for namespace: " + publicId, (Throwable)e);
                XefPlugin.getDefault().getLog().log((IStatus)st);
            }
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        XefEditor xed;
        IEditorInput ei;
        if (part instanceof XefEditor && (ei = (xed = (XefEditor)part).getEditorInput()) instanceof XMLProviderEditorInput) {
            XMLProviderEditorInput xei = (XMLProviderEditorInput)ei;
            this.setXMLProviderEditorInput(xei);
        }
    }

    void setXMLProviderEditorInput(XMLProviderEditorInput xei) {
        this.xmlProviderEditorInput = xei;
    }
}

