/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.jdom.input.SAXBuilder;

public class XMLEditDialog
extends Dialog {
    static boolean interactive = true;
    private final String rootName;
    private final String initialXML;
    private String xml;
    protected StyledText xmlTxt;
    SourceViewer sourceViewer;

    public XMLEditDialog(Shell shell, String initial) {
        this(shell, initial, null);
    }

    public XMLEditDialog(Shell shell, String initial, String multiRootName) {
        super(shell);
        this.setShellStyle(67696);
        this.initialXML = initial;
        this.rootName = multiRootName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Enter XML");
        newShell.setMinimumSize(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        SourceViewer sourceViewer = this.createViewer(composite);
        this.xmlTxt = (StyledText)sourceViewer.getControl();
        this.xmlTxt.setLayoutData((Object)new GridData(1808));
        this.xmlTxt.setText(this.initialXML);
        return composite;
    }

    private SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationXML();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        return this.doCreateViewer(parent, (SourceViewerConfiguration)sourceViewerConfiguration);
    }

    private SourceViewer doCreateViewer(Composite parent, SourceViewerConfiguration viewerConfiguration) {
        StructuredTextViewer viewer = null;
        String contentTypeID = "org.eclipse.core.runtime.xml";
        viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentTypeID);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        viewer.configure(viewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    public String getXML() {
        return this.xml;
    }

    protected void okPressed() {
        SAXBuilder builder = new SAXBuilder();
        String toParse = this.rootName != null ? "<" + this.rootName + ">" + this.xmlTxt.getText() + "</" + this.rootName + ">" : this.xmlTxt.getText();
        try {
            builder.build((InputStream)new ByteArrayInputStream(toParse.getBytes()));
            this.xml = this.xmlTxt.getText();
            super.okPressed();
        }
        catch (Exception e) {
            if (interactive) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error parsing XML", (String)("There was an error parsing the XML: " + e.getMessage()));
            }
            this.xml = null;
        }
    }
}

