/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityConstrainedFlowLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityDirectionType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.edit.policies.LaneCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.LaneGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.LaneItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.activities.LaneFigure;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizableLaneEditPolicy;

public class LaneEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 2007;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public LaneEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new LaneItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new LaneGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new LaneCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        RectangleFigure primaryShape0 = new RectangleFigure();
        primaryShape0.setFill(false);
        primaryShape0.setOutline(false);
        this.primaryShape = primaryShape0;
        return this.primaryShape;
    }

    public RectangleFigure getPrimaryShape() {
        return (RectangleFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        LaneFigure nodePlateFigure = new LaneFigure(-1, -1);
        return nodePlateFigure;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            GravityConstrainedFlowLayout layout = new GravityConstrainedFlowLayout();
            layout.setGravity(GravityDirectionType.WEST);
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4007));
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart targetEditPart = request instanceof CreateRequest ? this.getParent() : super.getTargetEditPart(request);
        return targetEditPart;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableLaneEditPolicy();
    }
}

