/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Flags;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;

public class SOAObjectTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(SOAObjectTests.class);
    }

    public SOAObjectTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SCAPackage pack = SCAPackage.eINSTANCE;
        SOAObjectTests.assertNotNull((Object)pack);
    }

    public void testFlags() {
        SCAFactory fact = SCAFactory.eINSTANCE;
        Property prop = fact.createProperty();
        SOAObjectTests.assertTrue((prop.getFlags() == 0 ? 1 : 0) != 0);
        EntryPoint ep = fact.createEntryPoint();
        ExternalService es = fact.createExternalService();
        Service serv = fact.createService();
        Reference ref = fact.createReference();
        SOAObjectTests.assertTrue((boolean)Flags.isPossibleWireSource((int)ep.getFlags()));
        SOAObjectTests.assertTrue((boolean)Flags.isPossibleWireSource((int)ref.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isPossibleWireSource((int)es.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isPossibleWireSource((int)serv.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isPossibleWireSource((int)prop.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isPossibleWireTarget((int)ep.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isPossibleWireTarget((int)ref.getFlags()));
        SOAObjectTests.assertTrue((boolean)Flags.isPossibleWireTarget((int)es.getFlags()));
        SOAObjectTests.assertTrue((boolean)Flags.isPossibleWireTarget((int)serv.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isPossibleWireTarget((int)prop.getFlags()));
        SOAObjectTests.assertTrue((boolean)Flags.isBoundaryElement((int)ep.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isBoundaryElement((int)ref.getFlags()));
        SOAObjectTests.assertTrue((boolean)Flags.isBoundaryElement((int)es.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isBoundaryElement((int)serv.getFlags()));
        SOAObjectTests.assertFalse((boolean)Flags.isBoundaryElement((int)prop.getFlags()));
    }
}

