/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.saf;

import java.util.Hashtable;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.resources.CompositeScribblerDomain;
import org.eclipse.stp.core.saf.ISAFManager;
import org.eclipse.stp.core.saf.handler.IComponentHandler;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.tests.properties.PropertiesImplementation;
import org.eclipse.stp.core.tests.properties.PropsPackage;
import org.eclipse.stp.core.tests.util.TestWorkspace;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ComponentHandlerTests
extends TestCase {
    private ISAFManager manager;
    private IProject testProject;
    private IFile compositeFile;
    private IFile propertyComponentTypeFile;
    private final String cHandler1Type = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties());
    private final String abstracthandlerType = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract());

    public ComponentHandlerTests(String name) {
        super(name);
    }

    protected void printTestHeader(String msg) {
        System.out.println("");
        System.out.println("==========================================================================================");
        System.out.println("Test: " + msg);
        System.out.println("==========================================================================================");
    }

    protected void printPassed(String msg) {
        String text = "";
        if (msg != null && !msg.equals("")) {
            text = " (" + msg + ")";
        }
        System.out.println(">>>> Passed." + text);
        System.out.println("------------------------------------------------------------------------------------------");
    }

    protected void setUp() throws Exception {
        this.manager = ISAFManager.INSTANCE;
        TestWorkspace.init();
        this.testProject = TestWorkspace.getComponentTestProject();
        this.compositeFile = this.testProject.getFile("TheComposite.composite");
        this.propertyComponentTypeFile = this.testProject.getFile("MyValueComponent.properties");
    }

    protected void tearDown() throws Exception {
        try {
            TestWorkspace.getComponentTestProject().delete(true, null);
        }
        catch (Exception exception) {}
    }

    private IComponentHandler getHandlerFor(String kind) {
        IComponentHandler[] handlers = this.manager.getAllComponentHandlers(null);
        IComponentHandler compHandler = null;
        int i = handlers.length;
        while (--i >= 0) {
            IComponentHandler handler = handlers[i];
            if (!handler.getKind().equals(kind)) continue;
            compHandler = handler;
            break;
        }
        return compHandler;
    }

    private Component createComponent() {
        Component component = null;
        try {
            IComponentHandler compHandler = this.getHandlerFor(this.cHandler1Type);
            if (compHandler != null) {
                component = compHandler.createComponent();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return component;
    }

    public void testGetComponentKindsFor() {
        this.printTestHeader("testGetComponentKindsFor");
        IComponentHandler[] handlers = this.manager.getComponentHandlersFor(null, (Object)this.propertyComponentTypeFile);
        Hashtable<String, IComponentHandler> descriptorMap = new Hashtable<String, IComponentHandler>();
        int i = 0;
        while (i < handlers.length) {
            IComponentHandler d = handlers[i];
            String type = d.getKind();
            descriptorMap.put(type, d);
            ++i;
        }
        ComponentHandlerTests.assertTrue((String)"%%!! Expected component type not found.", (boolean)descriptorMap.containsKey(this.cHandler1Type));
        this.printPassed("Test Component handler available");
    }

    public void testSetImplementation() {
        this.printTestHeader("testSetImplementation");
        Component component = this.createComponent();
        ComponentHandlerTests.assertTrue((String)"%%!! component is null.", (component != null ? 1 : 0) != 0);
        Throwable exception = null;
        try {
            IComponentHandler handler = this.getHandlerFor(this.cHandler1Type);
            IDataModelOperation op = handler.setImplementation(component, (Object)this.propertyComponentTypeFile, null);
            this.checkStatus(op.execute((IProgressMonitor)new NullProgressMonitor(), null));
        }
        catch (Throwable e) {
            e.printStackTrace();
            exception = e;
        }
        ComponentHandlerTests.assertTrue((String)("%%!! exception while setting implementation: " + exception), (exception == null ? 1 : 0) != 0);
        String type = this.manager.getHandlerFor(component).getKind();
        ComponentHandlerTests.assertTrue((String)"%%!! Not the expected component type", (boolean)type.equals(this.cHandler1Type));
        ComponentHandlerTests.assertTrue((String)"%%!! Implementation is null.", (component.getImplementation() != null ? 1 : 0) != 0);
        ComponentHandlerTests.assertTrue((String)"%%!! Implementation is not specialized type.", (boolean)(component.getImplementation() instanceof PropertiesImplementation));
        ComponentHandlerTests.assertTrue((String)"%%!! Incorrect properties file referenced by implementation.", (boolean)((PropertiesImplementation)component.getImplementation()).getProperties().equals(this.propertyComponentTypeFile.getProjectRelativePath().toString()));
        this.printPassed("Set implementation successful.");
    }

    private void setType(Component component, String kind) throws Throwable {
        IComponentHandler handler = this.getHandlerFor(kind);
        IDataModelOperation op = handler.setKind(component);
        this.checkStatus(op.execute((IProgressMonitor)new NullProgressMonitor(), null));
    }

    private void resetType(Component component) throws Throwable {
        IComponentHandler handler = this.manager.getHandlerFor(component);
        IDataModelOperation op = handler.resetKind(component);
        this.checkStatus(op.execute((IProgressMonitor)new NullProgressMonitor(), null));
    }

    private void checkStatus(IStatus status) throws Throwable {
        ComponentHandlerTests.assertTrue((String)"%%!! operation status is null.", (status != null ? 1 : 0) != 0);
        if (status.getSeverity() != 0) {
            throw status.getException();
        }
    }

    public void testSetTypeOnEmptyComponent() {
        Throwable exception;
        block13: {
            this.printTestHeader("testSetTypeOnEmptyComponent");
            CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
            exception = null;
            IEditModelScribbler scribbler = null;
            try {
                try {
                    scribbler = compositeScribblerDomain.createScribblerForWrite();
                    Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
                    SCACoreRoot coreRoot = (SCACoreRoot)resource.getContents().get(0);
                    Composite composite = coreRoot.getComposite();
                    ComponentHandlerTests.assertNotNull((Object)composite);
                    Component component = SCAFactory.eINSTANCE.createComponent();
                    composite.getComponents().add(component);
                    try {
                        this.setType(component, this.cHandler1Type);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        exception = e;
                    }
                    ComponentHandlerTests.assertTrue((String)("%%!! exception while setting type: " + exception), (exception == null ? 1 : 0) != 0);
                    ComponentHandlerTests.assertTrue((String)"%%!! component type not set.", (component.getType() != null ? 1 : 0) != 0);
                    ComponentHandlerTests.assertTrue((String)"%%!! component implementation is not an AbstractImplementation.", (boolean)(component.getImplementation() instanceof AbstractImplementation));
                    ComponentHandlerTests.assertTrue((String)"%%!! component type incorrect.", (boolean)component.getType().equals(this.cHandler1Type));
                }
                catch (EditModelException e) {
                    e.printStackTrace();
                    exception = e;
                    try {
                        scribbler.close(null);
                    }
                    catch (EditModelException e2) {
                        e2.printStackTrace();
                        exception = e2;
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    scribbler.close(null);
                }
                catch (EditModelException e) {
                    e.printStackTrace();
                    exception = e;
                }
                throw throwable;
            }
            try {
                scribbler.close(null);
            }
            catch (EditModelException e) {
                e.printStackTrace();
                exception = e;
            }
        }
        ComponentHandlerTests.assertTrue((String)("%%!! exception in scribbler: " + exception), (exception == null ? 1 : 0) != 0);
        this.printPassed("Set type successful.");
    }

    public void testSetResetTypeOnAbstractComponent() {
        this.printTestHeader("testSetResetTypeOnAbstractComponent");
        Component component = this.createComponent();
        ComponentHandlerTests.assertTrue((String)"%%!! component is null.", (component != null ? 1 : 0) != 0);
        component.setAbstractImplementation(SCAFactory.eINSTANCE.createComponentType());
        Throwable exception = null;
        try {
            this.setType(component, this.cHandler1Type);
        }
        catch (Throwable e) {
            e.printStackTrace();
            exception = e;
        }
        ComponentHandlerTests.assertTrue((String)("%%!! exception while setting type: " + exception), (exception == null ? 1 : 0) != 0);
        ComponentHandlerTests.assertTrue((String)"%%!! component type not set.", (component.getType() != null ? 1 : 0) != 0);
        ComponentHandlerTests.assertTrue((String)"%%!! component implementation is not an AbstractImplementation.", (boolean)(component.getImplementation() instanceof AbstractImplementation));
        ComponentHandlerTests.assertTrue((String)"%%!! component type incorrect.", (boolean)component.getType().equals(this.cHandler1Type));
        try {
            this.resetType(component);
        }
        catch (Throwable e) {
            e.printStackTrace();
            exception = e;
        }
        ComponentHandlerTests.assertTrue((String)("%%!! exception while resetting type: " + exception), (exception == null ? 1 : 0) != 0);
        ComponentHandlerTests.assertTrue((String)"%%!! component implementation is not an AbstractImplementation.", (boolean)(component.getImplementation() instanceof AbstractImplementation));
        ComponentHandlerTests.assertTrue((String)"%%!! component type incorrect.", (boolean)component.getType().equals(this.abstracthandlerType));
        this.printPassed("Implementation files listed.");
    }

    public void testResetTypeOnImplementedComponent() {
        Throwable exception;
        block15: {
            this.printTestHeader("testResetTypeOnImplementedComponent");
            Component component = this.createComponent();
            ComponentHandlerTests.assertTrue((String)"%%!! component is null.", (component != null ? 1 : 0) != 0);
            exception = null;
            try {
                IComponentHandler handler = this.getHandlerFor(this.cHandler1Type);
                IDataModelOperation op = handler.setImplementation(component, (Object)this.propertyComponentTypeFile, null);
                this.checkStatus(op.execute((IProgressMonitor)new NullProgressMonitor(), null));
            }
            catch (Throwable e) {
                e.printStackTrace();
                exception = e;
            }
            ComponentHandlerTests.assertTrue((String)("%%!! exception while setting implementation: " + exception), (exception == null ? 1 : 0) != 0);
            CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
            IEditModelScribbler scribbler = null;
            try {
                try {
                    scribbler = compositeScribblerDomain.createScribblerForWrite();
                    Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
                    SCACoreRoot coreRoot = (SCACoreRoot)resource.getContents().get(0);
                    Composite composite = coreRoot.getComposite();
                    ComponentHandlerTests.assertNotNull((Object)composite);
                    composite.getComponents().add(component);
                    Throwable e2 = null;
                    try {
                        this.resetType(component);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        e2 = e;
                    }
                    ComponentHandlerTests.assertTrue((String)("%%!! exception while resetting type: " + e2), (e2 == null ? 1 : 0) != 0);
                    ComponentHandlerTests.assertTrue((String)"%%!! component implementation is not an AbstractImplementation.", (boolean)(component.getImplementation() instanceof AbstractImplementation));
                    ComponentHandlerTests.assertTrue((String)"%%!! component type incorrect.", (boolean)component.getType().equals(this.abstracthandlerType));
                }
                catch (EditModelException e) {
                    e.printStackTrace();
                    exception = e;
                    try {
                        scribbler.close(null);
                    }
                    catch (EditModelException e2) {
                        e2.printStackTrace();
                        exception = e2;
                    }
                    component = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    scribbler.close(null);
                }
                catch (EditModelException e) {
                    e.printStackTrace();
                    exception = e;
                }
                component = null;
                throw throwable;
            }
            try {
                scribbler.close(null);
            }
            catch (EditModelException e) {
                e.printStackTrace();
                exception = e;
            }
            component = null;
        }
        ComponentHandlerTests.assertTrue((String)("%%!! exception in scribbler: " + exception), (exception == null ? 1 : 0) != 0);
        this.printPassed("Reset type on implemented component successful.");
    }
}

