/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.introspection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.introspection.AbstractComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.tests.introspection.PropertiesSharedModel;
import org.eclipse.stp.core.tests.introspection.ShareablePropertyComponentTypeFactory;

public class PropertiesComponentTypeIntrospector
extends AbstractComponentTypeIntrospector
implements IComponentTypeIntrospector,
PropertiesSharedModel.Listener {
    public static final String PLATFORM_RESOURCE = "resource";
    public static final String PLATFORM_PROTOCOL = "platform";
    private static final Object ON_PROPCHANGE_LOCK = new Object();
    private static final Object ON_EMFCHANGE_LOCK = new Object();
    private boolean updatingEMFModel = false;
    private boolean updatingPropertiesModel = false;
    private PropertiesSharedModel.NotifyingProperties properties;

    protected synchronized void doInit() {
        if (this.properties == null) {
            IFile propertiesFile = this.getPropertiesFile();
            Assert.isNotNull((Object)propertiesFile);
            try {
                this.properties = PropertiesSharedModel.getProperties(propertiesFile);
                if (ShareablePropertyComponentTypeFactory.isTestingIncremental) {
                    this.properties.addListener(this);
                }
            }
            catch (Exception e) {
                this.getComponentType().addStatus((IStatus)new Status(4, "org.eclipse.stp.core.tests", 0, "Could not load shared properties model!", (Throwable)e));
                e.printStackTrace();
            }
        }
    }

    public IStatus doIntrospection(int theFieldType, List theCurrentValues) {
        switch (theFieldType) {
            case 0: {
                this.introspectServices(theCurrentValues);
                break;
            }
            case 2: {
                this.introspectProperties(theCurrentValues);
                break;
            }
            case 1: {
                this.introspectReferences(theCurrentValues);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus onModelChange(int theFieldType, int theChangeType, Object theChangedObject) {
        if (this.updatingEMFModel) {
            return Status.OK_STATUS;
        }
        try {
            Object object = ON_EMFCHANGE_LOCK;
            synchronized (object) {
                this.updatingPropertiesModel = true;
                block3 : switch (theFieldType) {
                    case 0: {
                        Service s = (Service)theChangedObject;
                        switch (theChangeType) {
                            case 3: {
                                PropertiesSharedModel.createNewService(this.getProperties(), s.getName(), ((JavaInterface)s.getInterface()).getInterface());
                                break block3;
                            }
                            case 4: {
                                this.getProperties().remove(PropertiesSharedModel.serviceKey(s.getName()));
                            }
                        }
                        break;
                    }
                    case 1: {
                        Reference r = (Reference)theChangedObject;
                        switch (theChangeType) {
                            case 3: {
                                PropertiesSharedModel.createNewReference(this.getProperties(), r.getName(), ((JavaInterface)r.getInterface()).getInterface());
                                break block3;
                            }
                            case 4: {
                                this.getProperties().remove(PropertiesSharedModel.serviceKey(r.getName()));
                            }
                        }
                        break;
                    }
                    case 2: {
                        Property p = (Property)theChangedObject;
                        switch (theChangeType) {
                            case 3: {
                                PropertiesSharedModel.createNewProperty(this.getProperties(), p.getName(), p.getDefault());
                                break block3;
                            }
                            case 4: {
                                this.getProperties().remove(PropertiesSharedModel.serviceKey(p.getName()));
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.updatingPropertiesModel = false;
        }
        return Status.OK_STATUS;
    }

    public IStatus save() {
        if (this.properties != null) {
            try {
                PropertiesSharedModel.saveProperties(this.properties);
            }
            catch (Exception e) {
                return new Status(4, "org.eclipse.stp.core.tests", 0, e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus dispose() {
        if (this.properties != null) {
            if (ShareablePropertyComponentTypeFactory.isTestingIncremental) {
                this.properties.removeListener(this);
            }
            PropertiesSharedModel.dispose(this.properties);
        }
        return Status.OK_STATUS;
    }

    protected void introspectServices(List list) {
        this.updatingEMFModel = true;
        try {
            Properties theProperties = this.getProperties();
            Enumeration<?> nameEnum = theProperties.propertyNames();
            ArrayList<Service> itemsToAdd = new ArrayList<Service>();
            while (nameEnum.hasMoreElements()) {
                Service s;
                String name = nameEnum.nextElement().toString();
                if (!name.startsWith("service.") || list.contains(s = PropertiesSharedModel.parseService(theProperties, name))) continue;
                itemsToAdd.add(s);
            }
            list.addAll(itemsToAdd);
        }
        finally {
            this.updatingEMFModel = false;
        }
    }

    protected void introspectReferences(List list) {
        this.updatingEMFModel = true;
        try {
            Properties theProperties = this.getProperties();
            Enumeration<?> nameEnum = theProperties.propertyNames();
            ArrayList<Reference> itemsToAdd = new ArrayList<Reference>();
            while (nameEnum.hasMoreElements()) {
                Reference ref;
                String name = nameEnum.nextElement().toString();
                if (!name.startsWith("reference.") || list.contains(ref = PropertiesSharedModel.parseReference(theProperties, name))) continue;
                itemsToAdd.add(ref);
            }
            list.addAll(itemsToAdd);
        }
        finally {
            this.updatingEMFModel = false;
        }
    }

    protected void introspectProperties(List list) {
        this.updatingEMFModel = true;
        try {
            Properties theProperties = this.getProperties();
            Enumeration<?> nameEnum = theProperties.propertyNames();
            while (nameEnum.hasMoreElements()) {
                Property prop;
                String name = nameEnum.nextElement().toString();
                if (!name.startsWith("property.") || list.contains(prop = PropertiesSharedModel.parseProperty(theProperties, name))) continue;
                list.add(prop);
            }
        }
        finally {
            this.updatingEMFModel = false;
        }
    }

    protected Properties getProperties() {
        return this.properties;
    }

    private IFile getPropertiesFile() {
        if (PLATFORM_PROTOCOL.equals(this.getImplementationURI().scheme()) && PLATFORM_RESOURCE.equals(this.getImplementationURI().segment(0))) {
            String fileString = URI.decode((String)this.getImplementationURI().path());
            fileString = fileString.substring(PLATFORM_RESOURCE.length() + 1);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getImplementationURI().path()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPropertyChange(String key, String value) {
        if (this.updatingPropertiesModel) {
            return;
        }
        try {
            this.updatingEMFModel = true;
            Object object = ON_PROPCHANGE_LOCK;
            synchronized (object) {
                if (value != null) {
                    if (key.startsWith("service.")) {
                        Service service = SCAFactory.eINSTANCE.createService();
                        service.setName(PropertiesSharedModel.parseServiceName(key));
                        JavaInterface jInterface = SCAFactory.eINSTANCE.createJavaInterface();
                        jInterface.setInterface(value);
                        service.setInterface((Interface)jInterface);
                        this.doUpdateModel(0, 3, Collections.singletonList(service));
                    } else if (key.startsWith("reference.")) {
                        Reference reference = SCAFactory.eINSTANCE.createReference();
                        reference.setName(PropertiesSharedModel.parseReferenceName(key));
                        JavaInterface jInterface = SCAFactory.eINSTANCE.createJavaInterface();
                        jInterface.setInterface(value);
                        reference.setInterface((Interface)jInterface);
                        this.doUpdateModel(1, 3, Collections.singletonList(reference));
                    } else if (key.startsWith("property.")) {
                        Property property = SCAFactory.eINSTANCE.createProperty();
                        property.setName(PropertiesSharedModel.parsePropertyName(key));
                        property.setDefault(value);
                        this.doUpdateModel(2, 3, Collections.singletonList(property));
                    }
                } else if (key.startsWith("service.")) {
                    Service service = this.getComponentType().getService(PropertiesSharedModel.parseServiceName(key));
                    this.doUpdateModel(0, 4, Collections.singletonList(service));
                } else if (key.startsWith("reference.")) {
                    Reference reference = this.getComponentType().getReference(PropertiesSharedModel.parseReferenceName(key));
                    this.doUpdateModel(1, 4, Collections.singletonList(reference));
                } else if (key.startsWith("property.")) {
                    Property property = this.getComponentType().getProperty(PropertiesSharedModel.parsePropertyName(key));
                    this.doUpdateModel(2, 4, Collections.singletonList(property));
                }
            }
        }
        finally {
            this.updatingEMFModel = false;
        }
    }

    public IStatus hasValidComponentType() {
        return Status.OK_STATUS;
    }

    public Object resolveImplementation() {
        return this.properties;
    }
}

