/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.introspection;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IModelIntrospectionManager;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;

public class AbstractComponentTypeResource
extends ResourceImpl {
    protected AbstractComponentTypeResource(URI uri) {
        super(uri);
    }

    public void load(Map options) {
        SCACoreRoot root = SCAFactory.eINSTANCE.createSCACoreRoot();
        ComponentType componentType = SCAFactory.eINSTANCE.createComponentType();
        root.setComponentType(componentType);
        this.getContents().add((Object)((EObject)root));
        IModelIntrospectionManager.eINSTANCE.bind(componentType, this.getURI());
    }

    public void save(Map options) throws IOException {
        IComponentTypeIntrospector introspector;
        SCACoreRoot root;
        ComponentType cType;
        if (this.getContents().size() == 1 && (cType = (root = (SCACoreRoot)this.getContents().get(0)).getComponentType()) != null && (introspector = (IComponentTypeIntrospector)EcoreUtil.getAdapter((List)cType.getEObject().eAdapters(), (Object)IComponentTypeIntrospector.ADAPTER_TYPE)) != null) {
            IStatus status = introspector.save();
            if (status.isOK()) {
                this.setModified(false);
            } else {
                throw new IOException(status.getMessage());
            }
        }
    }

    protected void doUnload() {
        SCACoreRoot root;
        if (this.contents != null && this.contents.size() > 0 && (root = (SCACoreRoot)this.contents.get(0)).getComponentType() != null) {
            IModelIntrospectionManager.eINSTANCE.unbind(root.getComponentType());
        }
        super.doUnload();
    }
}

