/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.annvalidator.nature;

import java.util.ArrayList;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.stp.sc.annvalidator.AnnValidatorPlugin;
import org.eclipse.stp.sc.annvalidator.builder.AnnValidator;

/**
 * @author jma
 *
 */
public class AnnValidatorNature implements IProjectNature {
	
	public static final String NATURE_ID = AnnValidatorPlugin.PLUGIN_ID + ".validatorNature"; //$NON-NLS-1$

    private IProject annProject;


	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IProjectNature#configure()
	 */
	public void configure() throws CoreException {
		IProjectDescription description = annProject.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        for (ICommand command : commands) {
        	if (command.getBuilderName().equals(AnnValidator.BUILDER_ID)) {
                found = true;
                break;
            }
        }
        
        if (!found)
        {
            ICommand command = description.newCommand();
            command.setBuilderName(AnnValidator.BUILDER_ID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[commands.length] = command;
            description.setBuildSpec(newCommands);
            annProject.setDescription(description, null);
        }

	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IProjectNature#deconfigure()
	 */
	public void deconfigure() throws CoreException {
        //remove the ann builder
		IProjectDescription description = annProject.getDescription();
        ICommand[] commands = description.getBuildSpec();
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
        for (ICommand command : commands) {
        	if (command.getBuilderName().equals(AnnValidator.BUILDER_ID)) {
        		continue;
        	}
        	newCommands.add(command);
        }
        description.setBuildSpec(newCommands.toArray(new ICommand[0]));
        annProject.setDescription(description, new NullProgressMonitor());
        getProject().deleteMarkers(AnnValidator.MARKER_ID, true, IResource.DEPTH_INFINITE);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IProjectNature#getProject()
	 */
	public IProject getProject() {
		return annProject;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IProjectNature#setProject(org.eclipse.core.resources.IProject)
	 */
	public void setProject(IProject project) {
		annProject = project;

	}

}
