/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder;

import java.lang.reflect.Modifier;

/**
 * @author jma
 *
 */
public abstract class JMember extends JElement {
    int modifiers;
    
    public JMember(String nameValue) {
    	this(nameValue, Modifier.PUBLIC);
    }
    
    public JMember(String nameValue, int modifiersValue) {
    	super(nameValue);
    	modifiers = modifiersValue;
    }
    
    public int getModifiers() {
    	return modifiers;
    }
    
    public void setModifiers(int value) {
    	modifiers = value;
    }
    
    abstract public void accept(JVisitor v) throws Exception;
    
}
