/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * @author jma
 *
 */
 class JMethod extends JMember {
	ArrayList<JParam> parameters = new ArrayList<JParam>();
	Class<?> returnType = null;
	ArrayList<Class<?>> exceptions = new ArrayList<Class<?>>();

    LinkedList<JCodeStep> code = new LinkedList<JCodeStep>();
	
	public JMethod(String methodName) {
		super(methodName);
	}
	
	public ArrayList<JParam> getParameters() {
		return parameters;
	}
	
	public void addParameter(JParam param) {
		parameters.add(param);
	}
	
	public ArrayList<Class<?>> getExceptions() {
		return exceptions;
	}
	
	public void addException(Class<?> exp) {
		exceptions.add(exp);
	}
	
	public void setReturnType(Class<?> type) {
		returnType = type;
	}
	
	public Class<?> getReturnType() {
		return returnType;
	}

        public void addCode(JCodeStep step) {
            code.add(step);
        }

        public void addCodes(JCodeStep[] steps) {
        	for (JCodeStep step : steps) {
                code.add(step);
        	}
        }
        
        public List<JCodeStep> getCode() {
            return code;
        }
        
        

    public void accept(JVisitor visitor) throws Exception{
    	//visit each code step first
        for(JCodeStep step : code) {
            step.accept(visitor);
        }
        visitor.visitMethod(this);
    }
    
    public String toString() {
    	StringBuffer sb = new StringBuffer();
    	sb.append("  method " + name);
    	sb.append(LINE_END);
    	sb.append("      params:");
    	for (JParam param : parameters) {
    		sb.append(param.toString());
    		sb.append(LINE_END);;
    	}
    	
    	sb.append("      return:");
    	if (returnType != null) {
    		sb.append(returnType.getName());
    	} 
    	sb.append(LINE_END);;
    	sb.append("      exceptions:");
    	for (Class<?> exp : exceptions) {
    		sb.append(exp.getName());
    	}
    	sb.append(LINE_END);
    	for(JCodeStep step : code) {
            sb.append(step.toString());
            sb.append(LINE_END);;
        }
    	
    	return sb.toString();
    }

}
