/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder.inst;

/**
 * @author jma
 * mapping all Arithmetic instructions
 */
public interface JArithmeticInst {
    public final static short IADD = 0x60;
    public final static short LADD = 0x61;
    public final static short FADD = 0x62;
    public final static short DADD = 0x63;
    
    public final static short ISUB = 0x64;
    public final static short LSUB = 0x65;
    public final static short FSUB = 0x66;
    public final static short DSUB = 0x67;
    
    public final static short IMUL = 0x68;
    public final static short LMUL = 0x69;
    public final static short FMUL = 0x6a;
    public final static short DMUL = 0x6b;
    
    public final static short IDIV = 0x6c;
    public final static short LDIV = 0x6d;
    public final static short FDIV = 0x6e;
    public final static short DDIV = 0x6f;
    
    public final static short IREM = 0x70;
    public final static short LREM = 0x71;
    public final static short FREM = 0x72;
    public final static short DREM = 0x73;
    
    public final static short INEG = 0x74;
    public final static short LNEG = 0x75;
    public final static short FNEG = 0x76;
    public final static short DNEG = 0x77;
    
    public final static short IINC = 0x84;
    
    public final static short DCMP = 0x98;
    public final static short FCMP = 0x96;
    public final static short LCMP = 0x94;
    
    public final static short IOR = 0x80;
    public final static short ISHL = 0x78;
    public final static short ISHR = 0x7a;
    public final static short IUSHR = 0x7c;
    public final static short IXOR = 0x82;
    public final static short LOR = 0x81;
    public final static short LSHL = 0x79;
    public final static short LSHR = 0x7b;
    public final static short LUSHR = 0x7d;
    public final static short LXOR = 0x83;
    
    
    
    public final static short LAND = 0x7f;
    
}
