/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder.inst;

/**
 * @author jma
 * mapping all Control Flow instructions
 */
public interface JControlInst {
	public final static short IFEQ = 0x99;
	public final static short IFLT = 0x9b;
	public final static short IFLE = 0x9e;
	public final static short IFNE = 0x9a;
	public final static short IFGT = 0x9d;
	public final static short IFGE = 0x9c;
	public final static short IFNULL = 0xc6;
	public final static short IFNONNULL = 0xc7;
	
	public final static short IF_ICMPEQ = 0x9f;
	public final static short IF_ICMPNE = 0xa0;
	public final static short IF_ICMPLT = 0xa1;
	public final static short IF_ICMPGT = 0xa3;
	public final static short IF_ICMPLE = 0xa4;
	public final static short IF_ICMPGE = 0xa2;
	public final static short IF_ACMPEQ = 0xa5;
	public final static short IF_ACMPNE = 0xa6;
	
	public final static short LOOKUPSWITCH = 0xab;
	
	public final static short TABLESWITCH = 0xaa;
	
	public final static short GOTO = 0xa7;
	
	public final static short GOTO_W = 0xc8;
	
	//public final static short JSR;
	
	public final static short JSR_W = 0xc9;
	
	public final static short RET = 0xa9;
	
	public final static short ATHROW = 0xbf;
	
    public final static short MONITORENTER = 0xc2;
    
    public final static short MONITOREXIT = 0xc3;
    
    public final static short NOP = 0x0;
}
