package org.eclipse.stp.sc.xmlvalidator.preferences;

import java.util.Collection;

import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RuleSetTable extends Table {
	
	public RuleSetTable(Composite parent, int style) {
		super(parent, style);
	}
	
	public RuleSetTable(Composite parent, int style, Object[] columns) {
		super(parent, style);
		this.setHeaderVisible(true);
		for (Object column : columns) {
		    TableColumn tabColumn = new TableColumn(this, SWT.NONE);
		    if (column instanceof String) {
		        tabColumn.setText((String)column);     	
		    } else if (column instanceof Image) {
		    	tabColumn.setImage((Image)column);
		    }
		    tabColumn.pack();
		}
		setLinesVisible(true);
		TableLayout layout = new TableLayout();
		layout.addColumnData(new ColumnWeightData(20, 20, true));
		layout.addColumnData(new ColumnWeightData(20, 20, true));
		layout.addColumnData(new ColumnWeightData(60, 30, true));
		setLayout(layout);
	}
	
	protected void checkSubclass() {
	}
	
	public void setData(Collection data) {
		this.removeAll();
	    for (Object obj : data) {
	        //deal with each row
	    	
	    	TableItem item = new TableItem(this, SWT.BORDER);
	    	for (int column = 0 ; column < getColumnCount(); column++) {
	    	    item.setText(column, 
	    	    		getLabel(obj, column));
	    	}
	    }
		
	}
	
		
	
	public String getLabel(Object item, int index) {
		 VRuleSet ruleSet = (VRuleSet)item;
		 switch (index) {
		 case 0:
			 return ruleSet.getName();
		 case 1:
			 return ruleSet.getSimpleLocation();
		 default:
           return ruleSet.getDesc(); 				 
		 }
	}
	
	

	
}


