/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.rule.model;

import java.util.ArrayList;

/**
 * @author jma
 * Mapping to a rule file on the disk
 */
public class VRuleSet {
	
	/**
	 * the rule set name
	 */
	String name;
	
	/**
	 * the description of the rule set 
	 */
	String desc;
	
	/**
	 * the full path of the rule file
	 */
	String location;
	
	/**
	 * rules defined in this rule set
	 */
	ArrayList<VRuleDef> rules = new ArrayList<VRuleDef>();
	
	public VRuleSet() {
	}
	
	public VRuleSet(String nameValue, String descValue) {
		name = nameValue;
		desc = descValue;
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("rule set:" + name);
		sb.append(" desc:" + desc);
		sb.append(" location:" + location);
		sb.append(" rules:" + rules.size());
		return sb.toString();
	}


	public String getDesc() {
		return desc;
	}


	public void setDesc(String desc) {
		this.desc = desc;
	}


	public String getLocation() {
		return location;
	}


	public void setLocation(String location) {
		this.location = location;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public ArrayList<VRuleDef> getRules() {
		return rules;
	}


	public void setRules(ArrayList<VRuleDef> rules) {
		this.rules = rules;
	}
	
	public void addRule(VRuleDef ruleDef) {
		rules.add(ruleDef);
	}
	
	public boolean equals(Object obj) {
		return ((VRuleSet)obj).getName().equals(name);
	}
	
	public String getSimpleLocation() {
		if (location.lastIndexOf(java.io.File.separator) < 0) {
			return location;
		}
		return location.substring(location.lastIndexOf(java.io.File.separator) + 1,
				location.length());
	}
}
