/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.generators.types;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.generators.types.JaxBindTypeGenerator;
import org.eclipse.stp.sc.jaxws.tests.ScProjectBaseTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxBindTypeGeneratorTest
extends ScProjectBaseTest {
    public static final String PROJECT_NAME = "JaxBindTypeGeneratorTestProject";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxBindTypeGeneratorTest.class);
    protected String[] projectFiles = new String[]{"/src/org/objectweb/hello_world_soap_http/Greeter.java", "/src/complextest/Greeter.java", "/src/complextest/MyComplexType.java"};
    protected String[] resourceFiles = new String[]{"/resources/GreeterWrap.java_resource", "/resources/GreeterInout.java_resource", "/resources/MyComplexType.java_resource"};

    @Override
    protected String getProjectName() {
        return PROJECT_NAME;
    }

    @Override
    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    @Override
    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        WorkspaceManager.setWorkspaceAutoBuild((boolean)false);
        ICompilationUnit compUnit = JDTUtils.getJavaUnitFromFile((IFile)this.files[0]);
        JaxBindTypeGenerator generator = new JaxBindTypeGenerator();
        generator.createWrapperCls(compUnit);
        this.project.refreshLocal(0, null);
        compUnit = JDTUtils.getJavaUnitFromFile((IFile)this.files[1]);
        generator = new JaxBindTypeGenerator();
        generator.createWrapperCls(compUnit);
        this.project.refreshLocal(0, null);
        compUnit = JDTUtils.getJavaUnitFromFile((IFile)this.files[2]);
        generator = new JaxBindTypeGenerator();
        generator.createWrapperCls(compUnit);
        this.project.refreshLocal(0, null);
    }

    @Override
    protected void tearDown() throws Exception {
        WorkspaceManager.setWorkspaceAutoBuild((boolean)true);
    }

    public void testCreateWrapperClass() throws Exception {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("org/objectweb/hello_world_soap_http/types");
        JaxBindTypeGeneratorTest.assertTrue((String)"types dir should be created.", (boolean)folder.exists());
        IFile greetMeFile = folder.getFile("GreetMe.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"GeeetMe.java should been generated", (boolean)greetMeFile.exists());
        IFile greetMeOneWayFile = folder.getFile("GreetMeOneWay.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"GreetMeOneWayFile.java should been generated", (boolean)greetMeOneWayFile.exists());
        IFile greetMeResponseFile = folder.getFile("GreetMeResponse.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"GreetMeResponse.java should been generated", (boolean)greetMeResponseFile.exists());
        IFile pingMeFile = folder.getFile("PingMe.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"PingMe.java should been generated", (boolean)pingMeFile.exists());
        IFile pingMeResponseFile = folder.getFile("PingMeResponse.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"PingMeResponse.java should been generated", (boolean)pingMeResponseFile.exists());
        IFile sayHiFile = folder.getFile("SayHi.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"SayHi.java should been generated", (boolean)sayHiFile.exists());
        IFile sayHiResponseFile = folder.getFile("SayHiResponse.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"SayHiResponse.java should been generated", (boolean)sayHiResponseFile.exists());
    }

    public void testInoutParameter() throws Exception {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("complextest/types");
        JaxBindTypeGeneratorTest.assertTrue((String)"types dir should be created.", (boolean)folder.exists());
        IFile greetMeFile = folder.getFile("GreetMe.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"GeeetMe.java should been generated", (boolean)greetMeFile.exists());
        ICompilationUnit greetMeUnit = JDTUtils.getJavaUnitFromFile((IFile)greetMeFile);
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains inout type", (Object)greetMeUnit.findPrimaryType().getField("inoutType"));
        IFile greetMeResponseFile = folder.getFile("GreetMeResponse.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"GreetMeResponse.java should been generated", (boolean)greetMeResponseFile.exists());
        ICompilationUnit greetMeResponseUnit = JDTUtils.getJavaUnitFromFile((IFile)greetMeResponseFile);
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains inout type", (Object)greetMeResponseUnit.findPrimaryType().getField("inoutType"));
    }

    public void testComplexTypeParameter() throws Exception {
        IImportDeclaration[] imports;
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("complextest/types");
        JaxBindTypeGeneratorTest.assertTrue((String)"types dir should be created.", (boolean)folder.exists());
        IFile greetMeFile = folder.getFile("GreetMe.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"GeeetMe.java should been generated", (boolean)greetMeFile.exists());
        IFile greetMeResponseFile = folder.getFile("GreetMeResponse.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"GreetMeResponse.java should been generated", (boolean)greetMeResponseFile.exists());
        boolean foundTypeImport = false;
        ICompilationUnit greetMeFileUnit = JDTUtils.getJavaUnitFromFile((IFile)greetMeFile);
        IImportDeclaration[] iImportDeclarationArray = imports = greetMeFileUnit.getImports();
        int n = 0;
        int n2 = iImportDeclarationArray.length;
        while (n < n2) {
            IImportDeclaration importStat = iImportDeclarationArray[n];
            LOG.info((Object)("import stat:" + importStat.getElementName()));
            if (importStat.getElementName().equals("complextest.MyComplexType")) {
                foundTypeImport = true;
                break;
            }
            ++n;
        }
        JaxBindTypeGeneratorTest.assertTrue((String)"should have 'import complextest.MyComplexType;'", (boolean)foundTypeImport);
        String typeSignature = greetMeFileUnit.findPrimaryType().getField("complexType").getTypeSignature();
        JaxBindTypeGeneratorTest.assertTrue((String)"field should be MyComplexType type.", (boolean)Signature.getSignatureSimpleName((String)typeSignature).equals("MyComplexType"));
    }

    private Annotation getAnnotationByName(List<Annotation> annList, String name) {
        for (Annotation ann : annList) {
            String annName = ann.getTypeName().getFullyQualifiedName();
            if (!annName.equals(name)) continue;
            return ann;
        }
        return null;
    }

    public void testJaxbAnnotaion() throws Exception {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("complextest/types");
        IFile greetMeFile = folder.getFile("GreetMe.java");
        ICompilationUnit greetMeUnit = JDTUtils.getJavaUnitFromFile((IFile)greetMeFile);
        List annList = JDTUtils.getAnnotations((IMember)greetMeUnit.findPrimaryType());
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains @XmlType annotation.", (Object)this.getAnnotationByName(annList, "XmlType"));
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains @XmlRootElement annotation", (Object)this.getAnnotationByName(annList, "XmlRootElement"));
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains @XmlAccessorType annotation", (Object)this.getAnnotationByName(annList, "XmlAccessorType"));
        IField requestTypeField = greetMeUnit.findPrimaryType().getField("requestType");
        annList = JDTUtils.getAnnotations((IMember)requestTypeField);
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains @XmlElement annotation on requestType.", (Object)this.getAnnotationByName(annList, "XmlElement"));
        IField complexTypeField = greetMeUnit.findPrimaryType().getField("complexType");
        annList = JDTUtils.getAnnotations((IMember)complexTypeField);
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains @XmlElement annotation on complexType.", (Object)this.getAnnotationByName(annList, "XmlElement"));
        IField inoutTypeField = greetMeUnit.findPrimaryType().getField("inoutType");
        annList = JDTUtils.getAnnotations((IMember)inoutTypeField);
        JaxBindTypeGeneratorTest.assertNotNull((String)"should contains @XmlElement annotation on requestType.", (Object)this.getAnnotationByName(annList, "XmlElement"));
    }

    public void testBug176347_OnewayResponse() {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("org/objectweb/hello_world_soap_http/types");
        JaxBindTypeGeneratorTest.assertTrue((String)"types dir should be created.", (boolean)folder.exists());
        IFile greetMeOneWayFile = folder.getFile("GreetMeOneWayResponse.java");
        JaxBindTypeGeneratorTest.assertFalse((String)"GreetMeOneWayResponse.java shouldn't been generated", (boolean)greetMeOneWayFile.exists());
    }

    public void testBug176464_SimpleType() {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("org/objectweb/hello_world_soap_http/types");
        IFile typeFile = folder.getFile("TypeTestFloat.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"TypeTestFloat.java should exists", (boolean)typeFile.exists());
        ICompilationUnit typeFileUnit = JDTUtils.getJavaUnitFromFile((IFile)typeFile);
        IField requestTypeField = typeFileUnit.findPrimaryType().getField("floatType");
        JaxBindTypeGeneratorTest.assertNotNull((Object)requestTypeField);
    }

    public void testBug176346_defaultClassName() {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("org/objectweb/hello_world_soap_http/jaxws");
        JaxBindTypeGeneratorTest.assertTrue((String)"should generate default package as jaxws", (boolean)folder.exists());
        IFile reqFile = folder.getFile("DefaultJaxwsPackageTest.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"DefaultJaxwsPackageTest.java should exists", (boolean)reqFile.exists());
        IFile respFile = folder.getFile("DefaultJaxwsPackageTestResponse.java");
        JaxBindTypeGeneratorTest.assertTrue((String)"DefaultJaxwsPackageTestResponse.java", (boolean)respFile.exists());
    }
}

