/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public final class TestUtilities
extends WorkbenchUtils {
    private TestUtilities() {
    }

    public static void checkTable(Table table, String[] columns) {
        Assert.assertEquals((String)"Wrong number of columns", (int)columns.length, (int)table.getColumns().length);
        Assert.assertTrue((String)"Table should be visible", (boolean)table.getVisible());
        int expectedColumnWidth = table.getSize().x / columns.length;
        int i = 0;
        while (i < columns.length) {
            Assert.assertEquals((String)("Wrong title for column " + i), (String)columns[i], (String)table.getColumn(i).getText());
            Assert.assertTrue((String)("Column " + i + " should be resizeable"), (boolean)table.getColumn(i).getResizable());
            Assert.assertTrue((String)("Column " + i + " width " + table.getColumn(i).getWidth() + " not within +/- 25% of " + expectedColumnWidth), ((double)table.getColumn(i).getWidth() >= (double)expectedColumnWidth * 0.8 && (double)table.getColumn(i).getWidth() <= (double)expectedColumnWidth * 1.4 ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((String)"Header should be visible", (boolean)table.getHeaderVisible());
        Assert.assertTrue((String)"Grid lines should be visible", (boolean)table.getLinesVisible());
    }

    public static void checkVisible(Control control, String name) {
        TestUtilities.checkVisible(control, name, true);
    }

    public static void checkNotVisible(Control control, String name) {
        TestUtilities.checkVisible(control, name, false);
    }

    public static void checkVisible(Control control, String name, boolean visible) {
        Assert.assertNotNull((String)("Control " + name + " should not be null"), (Object)control);
        if (visible) {
            Assert.assertTrue((String)("Control " + name + " should  be visible"), (boolean)control.isVisible());
            Assert.assertTrue((String)("Control " + name + " should not be disposed"), (!control.isDisposed() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Control " + name + " should not be visible"), (control.isDisposed() || !control.isVisible() ? 1 : 0) != 0);
        }
    }

    public static void setupJavaProject(IProject project) throws Exception {
        TestUtilities.setupBasicJavaProject((IProject)project);
        if (!project.hasNature("org.eclipse.stp.sc.jaxws.nature")) {
            ScNature.addToProject((IProject)project, (String)"JavaFrist");
        }
    }
}

