/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.runtimeprovider;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessorTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeKitProcessor
implements IRuntimeKitProcessor {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeKitProcessor.class);
    private static final String RUNTIME_VAR_NAME_PROP = "runtimePathVarName";
    private static final QualifiedName VAR_NAME_PROP_KEY = new QualifiedName("org.eclipse.stp.sc.jaxws", "runtimePathVarName");
    private IRuntimeKitProcessorTemplate template;
    private IPath kitRootDirectory;

    public RuntimeKitProcessor(IRuntimeKitProcessorTemplate aTemplate, IPath aKitRootDirectory) {
        this.template = aTemplate;
        this.kitRootDirectory = aKitRootDirectory;
    }

    @Override
    public List<IPath> getDefaultBuildPathEntries(IProject project) {
        return this.template.getDefaultBuildPathEntries(project);
    }

    @Override
    public IPath getInstallationDirectory() {
        return this.kitRootDirectory != null && this.kitRootDirectory.toFile().exists() && this.kitRootDirectory.toFile().isDirectory() ? this.kitRootDirectory : this.getDefaultInstallationDirectory();
    }

    public IPath getKitRootDirectory(IProject prj) {
        Object kitPath = null;
        String kitVar = null;
        try {
            kitVar = prj.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT);
        }
        catch (CoreException e) {
            LOG.debug((Object)"Exception getting project kit path", (Throwable)e);
        }
        kitPath = kitVar != null && !kitVar.trim().equals("") ? new Path(kitVar) : this.getInstallationDirectory();
        return kitPath;
    }

    @Override
    public IPath getDefaultInstallationDirectory() {
        return this.template.getDefaultInstallDirectory();
    }

    @Override
    public String getSubstitutionVarName() {
        return this.template.getDefaultSubstitutionVarName();
    }

    @Override
    public String getDefaultSubstitutionVarName() {
        return this.template.getDefaultSubstitutionVarName();
    }

    @Override
    public List<IPath> validateBuildPathEntries(List<IPath> proposedBuildPath) {
        return this.template.validateBuildPathEntries(proposedBuildPath);
    }

    @Override
    public void completeJavaProjectBuildPath(IJavaProject jProject) throws CoreException {
        String projectSubstitutionVarName = this.registerInstallVarWithJavaProject(jProject);
        WorkspaceManager.addEntriesToClassPath((IJavaProject)jProject, (List)WorkspaceManager.convertFilesToPathEnries(this.getDefaultBuildPathEntries(jProject.getProject()), (String)projectSubstitutionVarName));
    }

    @Override
    public void clearJavaProjectBuildPath(IJavaProject jProject) throws CoreException {
        String varName = jProject.getProject().getPersistentProperty(VAR_NAME_PROP_KEY);
        WorkspaceManager.removeEntriesFromClassPath((IJavaProject)jProject, (String)varName);
        this.removeInstallVarFromJavaProject(jProject, varName);
    }

    private String registerInstallVarWithJavaProject(IJavaProject jProject) throws CoreException {
        String projectSubstitutionVarName = String.valueOf(this.getSubstitutionVarName()) + "_" + jProject.getProject().getName();
        JavaCore.setClasspathVariable((String)projectSubstitutionVarName, (IPath)this.getKitRootDirectory(jProject.getProject()), null);
        jProject.getProject().setPersistentProperty(VAR_NAME_PROP_KEY, projectSubstitutionVarName);
        return projectSubstitutionVarName;
    }

    private void removeInstallVarFromJavaProject(IJavaProject jProject, String varName) throws CoreException {
        jProject.getProject().setPersistentProperty(VAR_NAME_PROP_KEY, null);
        JavaCore.removeClasspathVariable((String)varName, null);
    }

    @Override
    public boolean isInstallationDirectoryValid(IPath installationPath) {
        return this.template.isInstallDirectoryValid(installationPath);
    }
}

