/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.workspace;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IProjectDirTemplate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;

public class JaxWsWorkspaceManager
extends WorkspaceManager {
    public static final String WEB_DEPLOY_FOLDER = "WebContent";
    public static final String SERVLET_CONFIG_FILENAME = "cxf-servlet.xml";
    public static final String WEB_XML_FILENAME = "web.xml";
    public static final String SPRING_CONFIG_FILENAME = "spring.xml";
    public static final String WEB_INF_DIR = "WEB-INF";
    public static final String WEB_WSDL_DIR = "wsdl";
    public static final String WEB_CLASS_DIR = "classes";
    public static final String WEB_LIB_DIR = "lib";
    public static final boolean COPY_NO_OVERWRITE = false;
    public static final boolean COPY_OVERWRITE = true;
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxWsWorkspaceManager.class);

    protected JaxWsWorkspaceManager() {
    }

    public static IProject createProject(IProgressMonitor monitor, String projectName, IPath locationPath, String projectMode) {
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        monitor.beginTask(ScJaxWsResources.getString("jaxws.project.creation.progress.proj"), 50);
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            monitor.worked(10);
            monitor.subTask(ScJaxWsResources.getString("jaxws.project.creation.progress.dir"));
            monitor.worked(20);
            IProject theProject = root.getProject(projectName);
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(theProject.getName());
            if (locationPath != null && !Platform.getLocation().equals((Object)locationPath)) {
                description.setLocation(locationPath);
            }
            theProject.create(description, monitor);
            theProject.open(monitor);
            if (projectMode.equals("JavaFrist")) {
                JaxWsWorkspaceManager.setupJavaNature(theProject);
                monitor.worked(30);
                ScNature.addToProject(theProject, projectMode);
                monitor.worked(35);
            }
            monitor.worked(40);
            IProject iProject = theProject;
            return iProject;
        }
        catch (Exception e) {
            LOG.error((Object)"Error in creating project. ", (Throwable)e);
            return null;
        }
        finally {
            monitor.done();
        }
    }

    public static void setupProjectNature(IProject project, String projectMode) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            JaxWsWorkspaceManager.setupJavaNature(project);
        }
        ScNature.addToProject(project, projectMode);
    }

    public static void createWebDeployFolders(IProject hostProject, IProgressMonitor monitor) {
        try {
            IFolder deployFolder = JaxWsWorkspaceManager.getWebDeployFolder(hostProject);
            JaxWsWorkspaceManager.createFolder((IFolder)deployFolder, (IProgressMonitor)monitor);
            IFolder webInfFolder = deployFolder.getFolder(WEB_INF_DIR);
            JaxWsWorkspaceManager.createFolder((IFolder)webInfFolder, (IProgressMonitor)monitor);
            IFolder metaInfFolder = deployFolder.getFolder("META-INF");
            JaxWsWorkspaceManager.createFolder((IFolder)metaInfFolder, (IProgressMonitor)monitor);
            IFolder wsdlFolder = webInfFolder.getFolder(WEB_WSDL_DIR);
            JaxWsWorkspaceManager.createFolder((IFolder)wsdlFolder, (IProgressMonitor)monitor);
            IFolder libFolder = webInfFolder.getFolder(WEB_LIB_DIR);
            JaxWsWorkspaceManager.createFolder((IFolder)libFolder, (IProgressMonitor)monitor);
            IFolder clsFolder = webInfFolder.getFolder(WEB_CLASS_DIR);
            JaxWsWorkspaceManager.createFolder((IFolder)clsFolder, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public static IFolder getWebDeployFolder(IProject hostProject) {
        return hostProject.getFolder(WEB_DEPLOY_FOLDER);
    }

    public static IFolder getWebInfFolder(IProject hostProject) {
        return JaxWsWorkspaceManager.getWebDeployFolder(hostProject).getFolder(WEB_INF_DIR);
    }

    public static IFolder getWebWSDLFolder(IProject hostProject) {
        return JaxWsWorkspaceManager.getWebDeployFolder(hostProject).getFolder(WEB_INF_DIR).getFolder(WEB_WSDL_DIR);
    }

    public static IFolder getWebClsFolder(IProject hostProject) {
        return JaxWsWorkspaceManager.getWebDeployFolder(hostProject).getFolder(WEB_INF_DIR).getFolder(WEB_CLASS_DIR);
    }

    public static IFolder getWebLibFolder(IProject hostProject) {
        return JaxWsWorkspaceManager.getWebDeployFolder(hostProject).getFolder(WEB_INF_DIR).getFolder(WEB_LIB_DIR);
    }

    public static IFile getServletConfigFile(IProject project) {
        IContainer container = JaxWsWorkspaceManager.getWSDLFolder(project);
        return ScJDTUtils.getFileFromContainer(container, SERVLET_CONFIG_FILENAME);
    }

    public static IFile getSpringConfigFile(IProject project) {
        IContainer container = JaxWsWorkspaceManager.getWSDLFolder(project);
        return ScJDTUtils.getFileFromContainer(container, SPRING_CONFIG_FILENAME);
    }

    public static IFile getWebXmlFile(IProject project) {
        IFolder folder = JaxWsWorkspaceManager.getWebInfFolder(project);
        return folder.getFile(WEB_XML_FILENAME);
    }

    public static IContainer getWSDLFolder(IProject hostProject) {
        IProjectDirTemplate temp = RuntimeProviderManager.getInstance().getProjectDirTemplate(hostProject);
        if (temp.getWsdlDir(hostProject) == null) {
            return hostProject;
        }
        return temp.getWsdlDir(hostProject);
    }

    public static IFolder getSrcFolder(IProject hostProject) {
        IProjectDirTemplate temp = RuntimeProviderManager.getInstance().getProjectDirTemplate(hostProject);
        return temp.getSrcDir(hostProject);
    }

    public static IFolder getClassesFolder(IProject hostProject) {
        IProjectDirTemplate temp = RuntimeProviderManager.getInstance().getProjectDirTemplate(hostProject);
        return temp.getClassFolder(hostProject);
    }

    public static IContainer getWSDLGenFolder(IPath path, IProject project) throws Exception {
        IContainer wsdlRoot = JaxWsWorkspaceManager.getWSDLFolder(project);
        if (!wsdlRoot.exists() && wsdlRoot instanceof IFolder) {
            ((IFolder)wsdlRoot).create(false, true, null);
        }
        return wsdlRoot;
    }

    public static void setupJavaNature(IProject project) throws CoreException {
        IFolder classesFolder;
        JaxWsWorkspaceManager.addProjectNature((IProject)project, (String)"org.eclipse.jdt.core.javanature");
        IFolder srcFolder = JaxWsWorkspaceManager.getSrcFolder(project);
        if (!srcFolder.exists()) {
            srcFolder.create(false, true, null);
        }
        if (!(classesFolder = JaxWsWorkspaceManager.getClassesFolder(project)).exists()) {
            classesFolder.create(false, true, null);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        JaxWsWorkspaceManager.setupJavaNatureClasspath(javaProject);
        javaProject.setOutputLocation(JaxWsWorkspaceManager.getClassesFolder(project).getFullPath(), null);
    }

    protected static void setupJavaNatureClasspath(IJavaProject javaProj) throws JavaModelException {
        ArrayList<IClasspathEntry> libraryEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry jreEntry = JavaRuntime.getJREVariableEntry();
        libraryEntries.add(jreEntry);
        IClasspathEntry srccpe = JavaCore.newSourceEntry((IPath)JaxWsWorkspaceManager.getSrcFolder(javaProj.getProject()).getFullPath());
        libraryEntries.add(srccpe);
        javaProj.setRawClasspath(libraryEntries.toArray(new IClasspathEntry[0]), null);
    }
}

