/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;

public class PreferencesAccessor {
    private static final IPreferenceStore PREFERENCE_STORE = ScJaxWsPlugin.getDefault().getPreferenceStore();

    public static String resolvePrefKey(String keyPrefix, String providerExtensionId) {
        return String.valueOf(keyPrefix) + "_" + providerExtensionId;
    }

    protected static String getPrefValue(String keyPrefix, String providerExtensionId) {
        return PREFERENCE_STORE.getString(PreferencesAccessor.resolvePrefKey(keyPrefix, providerExtensionId));
    }

    protected static void setPrefValue(String keyPrefix, String providerExtensionId, String value) {
        PREFERENCE_STORE.setValue(PreferencesAccessor.resolvePrefKey(keyPrefix, providerExtensionId), value);
    }

    public static String getKitInstallLocation(String providerExtUID) {
        return PreferencesAccessor.getPrefValue("jaxws_kit_location", providerExtUID);
    }

    public static boolean areAnnWizardsDisplaied() {
        String prefValue = PREFERENCE_STORE.getString("annWizEnabled");
        return prefValue.equals("enabled");
    }

    public static boolean getSoap12Option() {
        String pref = PREFERENCE_STORE.getString("KEY_SOAP_OPTION");
        return "SOAP 1.2".equals(pref);
    }
}

