/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public abstract class BaseDeployStatusDialogPage
extends DialogPage {
    public static final String PROP_PACKAGE = "package";
    public static final String PROP_SERVER_PROBLEM = "server/problem";
    protected static final int NUM_ROWS = 6;
    protected static final String[] COLUMN_PROPERTIES = new String[]{"package", "server/problem"};
    protected Map mProblemsMap;
    protected boolean mAllowOk;

    protected BaseDeployStatusDialogPage(String title, Map problemsMap, boolean allowOk) {
        super(title);
        this.setNeedsApplyButton(false);
        this.mProblemsMap = problemsMap;
        this.mAllowOk = allowOk;
    }

    public final void createControl(Composite parent) {
        final Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(1808));
        final TableTreeViewer viewer = new TableTreeViewer(content, 68352);
        viewer.getTableTree().getTable().setHeaderVisible(true);
        viewer.getTableTree().getTable().setLinesVisible(true);
        viewer.setColumnProperties(COLUMN_PROPERTIES);
        GridData data = new GridData(1808);
        data.heightHint = viewer.getTableTree().getItemHeight() * 6 + viewer.getTableTree().getTable().getHeaderHeight();
        viewer.getTableTree().setLayoutData((Object)data);
        final TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(viewer.getTableTree().getTable(), 16384);
        column.setText(DeployCorePlugin.getDefault().getResourceString("DeployCheckProblemsTable.column.package"));
        column.pack();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, column.getWidth(), true));
        column = new TableColumn(viewer.getTableTree().getTable(), 16384);
        column.setText(DeployCorePlugin.getDefault().getResourceString("DeployCheckProblemsTable.column.server_problem"));
        column.pack();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, column.getWidth(), true));
        viewer.setContentProvider((IContentProvider)new ProblemsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ProblemsLabelProvider());
        viewer.setSorter((ViewerSorter)new ProblemsViewerSorter());
        viewer.setInput((Object)this.mProblemsMap);
        viewer.expandAll();
        this.setIsValid(this.mAllowOk);
        this.setStatusMessage();
        content.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (viewer.getTableTree().getTable().getLayout() == null) {
                    viewer.getTableTree().getTable().setLayout((Layout)layout);
                    content.layout();
                }
            }
        });
        this.setControl((Control)content);
    }

    protected abstract void setStatusMessage();

    public boolean performOk() {
        return true;
    }

    private static class ProblemsContentProvider
    implements ITreeContentProvider {
        private ProblemsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] kids;
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                kids = map.entrySet().toArray(new Map.Entry[map.size()]);
            } else {
                kids = parentElement instanceof Map.Entry ? (IStatus[])((Map.Entry)parentElement).getValue() : new Object[]{};
            }
            return kids;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ProblemsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProblemsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Object image;
            if (columnIndex < COLUMN_PROPERTIES.length) {
                if (COLUMN_PROPERTIES[columnIndex].equals(BaseDeployStatusDialogPage.PROP_PACKAGE)) {
                    if (element instanceof Map.Entry) {
                        IStatus[] statuses = (IStatus[])((Map.Entry)element).getValue();
                        int severity = 0;
                        int index = 0;
                        int count = statuses.length;
                        while ((severity & 4) == 0 && index < count) {
                            severity |= statuses[index].getSeverity();
                            ++index;
                        }
                        image = (severity & 4) == 4 ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK") : ((severity & 2) == 2 ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK") : ((severity & 1) == 1 ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK") : null));
                    } else {
                        image = null;
                    }
                } else if (element instanceof Map.Entry) {
                    image = null;
                } else {
                    switch (((IStatus)element).getSeverity()) {
                        case 4: {
                            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                            break;
                        }
                        case 2: {
                            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                            break;
                        }
                        case 1: {
                            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                            break;
                        }
                        default: {
                            image = null;
                            break;
                        }
                    }
                }
            } else {
                image = this.getImage(element);
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = columnIndex < COLUMN_PROPERTIES.length ? (COLUMN_PROPERTIES[columnIndex].equals(BaseDeployStatusDialogPage.PROP_PACKAGE) ? (element instanceof Map.Entry ? ((DeployConfiguration)((Map.Entry)element).getKey()).getSourcePackage().getPackageFile() : new String()) : (element instanceof Map.Entry ? ((DeployConfiguration)((Map.Entry)element).getKey()).getTargetServer().getProfileName() : ((IStatus)element).getMessage())) : new String();
            return text;
        }
    }

    private static class ProblemsViewerSorter
    extends ViewerSorter {
        private ProblemsViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int retVal;
            if (e1 instanceof Map.Entry && e2 instanceof Map.Entry) {
                DeployConfiguration dc1 = (DeployConfiguration)((Map.Entry)e1).getKey();
                DeployConfiguration dc2 = (DeployConfiguration)((Map.Entry)e2).getKey();
                retVal = dc1.getSourcePackage().getPackageFile().compareTo(dc2.getSourcePackage().getPackageFile());
                if (retVal == 0) {
                    retVal = dc1.getTargetServer().getProfileName().compareTo(dc2.getTargetServer().getProfileName());
                }
            } else {
                retVal = 0;
            }
            return retVal;
        }
    }
}

