/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.EmptyContainerFilter;
import org.eclipse.stp.soas.internal.deploy.ui.PackagesFilter;
import org.eclipse.stp.soas.internal.deploy.ui.ProjectsFilter;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PackageSelectionDialogPage
extends DialogPage {
    public static final String TITLE = DeployCorePlugin.getDefault().getResourceString("PackageSelectionDialogPage.title.selectPackages");
    public static final String ICON_PATH = "icons/blank_wizard_graphic.gif";
    public static final ImageDescriptor ICON_DESC;
    public static final String LABEL_SELECT_PACKAGES;
    public static final int MIN_TREE_HEIGHT;
    private IProject mSourceProject;
    private List mExistingPackages;
    private CheckboxTreeViewer mPackageViewer;
    private IResource[] mSelection = new IResource[0];

    static {
        URL url = null;
        try {
            url = DeployCorePlugin.getDefault().getBundle().getEntry(ICON_PATH);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        ICON_DESC = url == null ? ImageDescriptor.getMissingImageDescriptor() : ImageDescriptor.createFromURL((URL)url);
        LABEL_SELECT_PACKAGES = DeployCorePlugin.getDefault().getResourceString("PackageSelectionDialogPage.LABEL.selectPackages");
        MIN_TREE_HEIGHT = 15;
    }

    public PackageSelectionDialogPage() {
        this(TITLE, ICON_DESC);
    }

    public PackageSelectionDialogPage(String title, ImageDescriptor image) {
        super(title, image);
        this.setNeedsApplyButton(false);
    }

    public void init(IProject sourceProject, Root root) {
        this.mSourceProject = sourceProject;
        EList packages = root.getPackage();
        this.mExistingPackages = new Vector(packages.size());
        for (DeployPackage dp : packages) {
            this.mExistingPackages.add(dp.getPackageFile());
        }
        Collections.sort(this.mExistingPackages);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(1808));
        Label label = new Label(content, 0);
        label.setText(LABEL_SELECT_PACKAGES);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.mPackageViewer = new CheckboxTreeViewer(content, 2816);
        this.mPackageViewer.setAutoExpandLevel(3);
        this.mPackageViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.mPackageViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.mPackageViewer.addFilter((ViewerFilter)new PackagesFilter());
        this.mPackageViewer.addFilter((ViewerFilter)new ProjectsFilter(this.mSourceProject));
        this.mPackageViewer.addFilter((ViewerFilter)new EmptyContainerFilter());
        this.mPackageViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean retVal = element instanceof IFile ? Collections.binarySearch(PackageSelectionDialogPage.this.mExistingPackages, ((IFile)element).getProjectRelativePath().toString()) < 0 : true;
                return retVal;
            }
        });
        data = new GridData(1808);
        data.heightHint = this.mPackageViewer.getTree().getItemHeight() * MIN_TREE_HEIGHT;
        this.mPackageViewer.getTree().setLayoutData((Object)data);
        this.mPackageViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PackageSelectionDialogPage.this.handleCheckStateChanged();
            }
        });
        this.initControls();
        this.setControl((Control)content);
    }

    public boolean performOk() {
        Object[] selection = this.mPackageViewer.getCheckedElements();
        Vector<IResource> files = new Vector<IResource>(selection.length);
        int index = 0;
        int count = selection.length;
        while (index < count) {
            IResource res = (IResource)selection[index];
            if (res.getType() == 1) {
                files.add(res);
            }
            ++index;
        }
        this.mSelection = files.toArray(new IResource[files.size()]);
        return true;
    }

    public IResource[] getSelection() {
        return this.mSelection;
    }

    private void initControls() {
        this.mPackageViewer.setInput((Object)DeployCorePlugin.getWorkspace().getRoot());
        this.updateControls();
        this.validate();
    }

    private void updateControls() {
    }

    private void validate() {
        if (this.mPackageViewer.getCheckedElements().length > 0) {
            this.setErrorMessage(null);
            this.setIsValid(true);
        } else {
            this.setErrorMessage(DeployCorePlugin.getDefault().getResourceString("PackageSelectionDialogPage.error.noPackagesSelected"));
            this.setIsValid(false);
        }
    }

    private void handleCheckStateChanged() {
        this.setIsModified(true);
        this.updateControls();
        this.validate();
    }
}

