/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.AdapterFactoryContentProvider;
import org.eclipse.stp.soas.internal.deploy.ui.TargetMapTreeViewer;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditorSectionPart;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ServersSection
extends DeployEditorSectionPart
implements IPartSelectionListener {
    public static final String SECTION_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECTITLE.Servers");
    public static final String SECTION_DESC = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECDESC.Servers");
    private TableViewer mServers;
    private boolean mProcessingSelectionChanged = false;

    public ServersSection(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.getSection().setText(SECTION_TITLE);
        this.getSection().setDescription(SECTION_DESC);
    }

    public void createClient(FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)this.getSection());
        GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Table table = toolkit.createTable(container, 66304);
        this.mServers = new TableViewer(table);
        GridData gd = new GridData(1808);
        gd.heightHint = table.getItemHeight() * 5;
        this.mServers.getControl().setLayoutData((Object)gd);
        this.mServers.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mServers.setLabelProvider((IBaseLabelProvider)new ServersLabelProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mServers.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof DeployServer;
            }
        });
        this.mServers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServersSection.this.mProcessingSelectionChanged = true;
                try {
                    ServersSection.this.fireSelectionChanged(event.getSelection());
                }
                finally {
                    ServersSection.this.mProcessingSelectionChanged = false;
                }
            }
        });
        this.getSection().setClient((Control)container);
        toolkit.paintBordersFor(container);
    }

    protected void helpActivated(HyperlinkEvent event) {
        HelpUtilities.displayHelp((String)IHelpConstants.CONTEXT_ID_OVERVIEW_PAGE_SERVERS_SECTION);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (this.mProcessingSelectionChanged) {
            return;
        }
        if (!selection.isEmpty()) {
            DeployServer server;
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof DeployPackage) {
                HashSet<DeployServer> servers = new HashSet<DeployServer>();
                Iterator it = ((DeployPackage)obj).getTargetConfiguration().iterator();
                while (it.hasNext()) {
                    servers.add(((DeployConfiguration)it.next()).getTargetServer());
                }
                this.mServers.setSelection((ISelection)new StructuredSelection(servers.toArray()));
            } else if (obj instanceof DeployConfiguration && (server = ((DeployConfiguration)obj).getTargetServer()) != null) {
                this.mServers.setSelection((ISelection)new StructuredSelection((Object)server));
            }
        }
    }

    protected void setModelRoot(EObject modelRoot) {
        if (!(modelRoot instanceof Root)) {
            throw new IllegalArgumentException("modelRoot must be of type " + Root.class);
        }
        this.mServers.setInput((Object)((Root)modelRoot));
    }

    private static class ServersLabelProvider
    extends AdapterFactoryLabelProvider {
        public ServersLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return this.getImage(object);
        }

        public String getColumnText(Object object, int columnIndex) {
            return this.getText(object);
        }

        public Image getImage(Object element) {
            DeployServer server;
            IConnectionProfile cp;
            Image image = null;
            image = element instanceof DeployServer ? ((cp = Utilities.adaptToIConnectionProfile((EObject)(server = (DeployServer)element))) == null ? super.getImage((Object)server) : ProfileImageRegistry.getInstance().getProfileImage(cp.getProvider())) : super.getImage(element);
            return image;
        }

        public String getText(Object element) {
            DeployServer server;
            IConnectionProfile cp;
            this.adapterFactory.adapt(element, IItemLabelProvider.class);
            String text = element instanceof DeployServer ? ((cp = Utilities.adaptToIConnectionProfile((EObject)(server = (DeployServer)element))) == null ? (server.getProfileName() == null ? TargetMapTreeViewer.LABEL_UNSPECIFIED_TARGET : server.getProfileName()) : cp.getName()) : super.getText(element);
            return text;
        }
    }
}

