/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFileFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.TargetMapTableViewer;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.ServerSelectionDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.DeployFileNewWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class PackageTargetWizardPage
extends WizardPage
implements ISummaryDataSource {
    public static final String LABEL_TARGETS = DeployCorePlugin.getDefault().getResourceString("LABEL.PackageTargets");
    public static final String LABEL_SELECT_TARGET = DeployCorePlugin.getDefault().getResourceString("BUTTON.SelectTarget");
    public static final String LABEL_EXECUTE = DeployCorePlugin.getDefault().getResourceString("BUTTON.ExecuteDeployment");
    public static final int MIN_TREE_HEIGHT = 15;
    private TargetMapTableViewer mTargetMap;
    private Button mSelectTargetButton;
    private Button mExecuteButton;
    private Root mRoot;
    private Map mFileToPackageMap = new HashMap();
    private boolean mTargetsSpecified = false;

    public PackageTargetWizardPage(String pageName) {
        super(pageName);
    }

    public PackageTargetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void init(Root root) {
        this.mRoot = root;
    }

    public boolean getExecuteDeployment() {
        boolean retVal = this.mExecuteButton != null && this.mExecuteButton.isEnabled() ? this.mExecuteButton.getSelection() : false;
        return retVal;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IFile[] packages = ((DeployFileNewWizard)this.getWizard()).getSelectedPackages();
            this.updatePackages(packages);
            this.mExecuteButton.setEnabled(packages.length == 0);
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(1808));
        Label label = new Label(content, 0);
        label.setText(LABEL_TARGETS);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.mTargetMap = new TargetMapTableViewer(new Table(content, 68356));
        data = new GridData(1808);
        data.heightHint = this.mTargetMap.getViewer().getTable().getItemHeight() * MIN_TREE_HEIGHT;
        this.mTargetMap.getViewer().getTable().setLayoutData((Object)data);
        this.mTargetMap.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackageTargetWizardPage.this.handleTargetMapSelectionChanged();
            }
        });
        this.mSelectTargetButton = new Button(content, 8);
        this.mSelectTargetButton.setText(LABEL_SELECT_TARGET);
        data = new GridData(2);
        GC gc = new GC((Drawable)this.mSelectTargetButton);
        gc.setFont(this.mSelectTargetButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int buttonHeight = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
        int buttonWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        data.heightHint = buttonHeight;
        data.widthHint = Math.max(buttonWidth, this.mSelectTargetButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.mSelectTargetButton.setLayoutData((Object)data);
        this.mSelectTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageTargetWizardPage.this.handleSelectTarget();
            }
        });
        this.mExecuteButton = new Button(content, 32);
        this.mExecuteButton.setText(LABEL_EXECUTE);
        data = new GridData();
        this.mExecuteButton.setLayoutData((Object)data);
        this.mExecuteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageTargetWizardPage.this.handleExecuteSelected();
            }
        });
        this.initControls();
        this.setControl((Control)content);
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>(this.mRoot.getPackage().size() + 2);
        summaryData.add(new String[]{DeployCorePlugin.getDefault().getResourceString("PackageTargetWizardPage.summary.targetServers"), new String()});
        for (DeployPackage dp : this.mRoot.getPackage()) {
            DeployConfiguration dc;
            IPackage ip = Utilities.adaptToIPackage((EObject)dp);
            String target = new String();
            if (dp.getTargetConfiguration().size() > 0 && (dc = (DeployConfiguration)dp.getTargetConfiguration().get(0)).getTargetServer() != null) {
                target = dc.getTargetServer().getProfileName();
            }
            summaryData.add(new String[]{"   " + ip.getFile().getFullPath().toString(), target});
        }
        summaryData.add(new String[]{DeployCorePlugin.getDefault().getResourceString("PackageTargetWizardPage.summary.executeDeployment"), String.valueOf(this.getExecuteDeployment())});
        return summaryData;
    }

    private void initControls() {
        this.mTargetMap.getViewer().setInput((Object)this.mRoot);
        this.validate();
        this.updateControls();
    }

    private void updateControls() {
        this.mExecuteButton.setEnabled(this.mTargetsSpecified);
        this.mSelectTargetButton.setEnabled(((IStructuredSelection)this.mTargetMap.getViewer().getSelection()).size() == 1);
    }

    private void validate() {
        this.mTargetsSpecified = true;
        Iterator it = this.mRoot.getPackage().iterator();
        while (this.mTargetsSpecified && it.hasNext()) {
            DeployPackage pkg = (DeployPackage)it.next();
            boolean bl = this.mTargetsSpecified = this.mTargetsSpecified && pkg.getTargetConfiguration().size() > 0;
        }
        if (this.mTargetsSpecified) {
            this.setMessage(null, 2);
        } else {
            this.setMessage(DeployCorePlugin.getDefault().getResourceString("PackageTargetWizardPage.summary.targetServers"), 2);
        }
        this.setPageComplete(true);
    }

    private void handleTargetMapSelectionChanged() {
        this.validate();
        this.updateControls();
    }

    private void handleSelectTarget() {
        DeployPackage pkg = (DeployPackage)((IStructuredSelection)this.mTargetMap.getViewer().getSelection()).getFirstElement();
        DeployServer target = null;
        DeployConfiguration config = null;
        if (pkg.getTargetConfiguration().size() > 0) {
            config = (DeployConfiguration)pkg.getTargetConfiguration().get(0);
            target = config.getTargetServer();
        }
        ServerSelectionDialogPage page = new ServerSelectionDialogPage();
        page.init(pkg, target);
        Dialog dialog = new Dialog(this.getShell(), (IDialogPage)page);
        if (dialog.open() == 0) {
            target = page.getSelectedDeployServer();
            if (target.getRoot() == null) {
                target.setRoot(this.mRoot);
            }
            if (config == null) {
                DeployFilePackage.eINSTANCE.getDeployFileFactory().createDeployConfiguration(target, pkg);
            } else {
                config.setTargetServer(target);
            }
            this.validate();
            this.updateControls();
        }
    }

    private void handleExecuteSelected() {
    }

    private void updatePackages(IFile[] packages) {
        DeployFileFactory factory = DeployFilePackage.eINSTANCE.getDeployFileFactory();
        Vector unseen = new Vector(this.mFileToPackageMap.values());
        int index = 0;
        int count = packages.length;
        while (index < count) {
            DeployPackage dp = (DeployPackage)this.mFileToPackageMap.get(packages[index]);
            if (dp == null) {
                dp = factory.createDeployPackage(this.mRoot, packages[index].getProjectRelativePath().toString());
                this.mFileToPackageMap.put(packages[index], dp);
            } else {
                dp.setRoot(this.mRoot);
                unseen.remove(dp);
            }
            ++index;
        }
        for (DeployPackage dp : unseen) {
            dp.setRoot(null);
        }
    }
}

