/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CheckboxTreeViewer
extends org.eclipse.jface.viewers.CheckboxTreeViewer {
    public CheckboxTreeViewer(Composite parent) {
        super(parent);
    }

    public CheckboxTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public CheckboxTreeViewer(Tree tree) {
        super(tree);
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        if (elements.length > 0) {
            int index = 0;
            int count = elements.length;
            while (index < count) {
                this.handleItemChecked(elements[index], true);
                ++index;
            }
        } else {
            super.setGrayedElements(new Object[0]);
        }
    }

    public Object[] getCheckedLeafElements() {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object element : Arrays.asList(this.getCheckedElements())) {
            Widget widget = this.internalExpand(element, false);
            Item[] kids = this.getChildren(widget);
            if (kids != null && kids.length != 0) continue;
            elements.add(element);
        }
        return elements.toArray();
    }

    protected void fireCheckStateChanged(CheckStateChangedEvent event) {
        this.setSelection((ISelection)new StructuredSelection(event.getElement()));
        this.handleItemChecked(event.getElement(), event.getChecked());
        super.fireCheckStateChanged(event);
    }

    public void handleItemChecked(Object element, boolean checked) {
        ITreeContentProvider tp = (ITreeContentProvider)this.getContentProvider();
        this.checkChildren(element, checked);
        this.grayChildren(element, false);
        this.grayParents(tp.getParent(element), true);
        this.setGrayed(element, false);
        if (checked) {
            this.checkParents(tp.getParent(element), true);
            this.determineParentGrayState(element);
        } else {
            this.determineParentCheckState(element);
        }
    }

    private void checkChildren(Object element, boolean state) {
        this.setSubtreeChecked(element, state);
    }

    private void checkParents(Object element, boolean state) {
        Widget widget = this.internalExpand(element, false);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            while (item != null) {
                item.setChecked(state);
                item = item.getParentItem();
            }
        }
    }

    private void grayParents(Object element, boolean state) {
        if (element != null) {
            this.setParentsGrayed(element, state);
        }
    }

    private void grayChildren(Object element, boolean grayed) {
        Widget widget = this.internalExpand(element, false);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            item.setGrayed(grayed);
            this.setGrayedChildren(item, grayed);
        }
    }

    private void determineParentGrayState(Object element) {
        ITreeContentProvider tp = (ITreeContentProvider)this.getContentProvider();
        Object parent = tp.getParent(element);
        Widget widget = this.internalExpand(parent, false);
        Item[] sibs = this.getChildren(widget);
        if (sibs == null) {
            return;
        }
        boolean checked = parent != null;
        int index = 0;
        int count = sibs.length;
        while (index < count && checked) {
            TreeItem sib = (TreeItem)sibs[index];
            checked = sib.getChecked() && !sib.getGrayed();
            ++index;
        }
        if (checked) {
            this.setGrayed(parent, false);
            this.determineParentGrayState(parent);
        }
    }

    private void determineParentCheckState(Object element) {
        ITreeContentProvider tp = (ITreeContentProvider)this.getContentProvider();
        Object parent = tp.getParent(element);
        Widget widget = this.internalExpand(parent, false);
        Item[] sibs = this.getChildren(widget);
        if (sibs == null) {
            return;
        }
        boolean notChecked = parent != null;
        int index = 0;
        int count = sibs.length;
        while (index < count && notChecked) {
            TreeItem sib = (TreeItem)sibs[index];
            notChecked = !sib.getChecked();
            ++index;
        }
        if (notChecked) {
            this.handleItemChecked(parent, false);
        }
    }

    private void setGrayedChildren(TreeItem item, boolean grayed) {
        this.createChildren((Widget)item);
        Item[] items = this.getChildren((Widget)item);
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Item it = items[i];
                if (it.getData() != null && it instanceof TreeItem) {
                    TreeItem treeItem = (TreeItem)it;
                    treeItem.setGrayed(grayed);
                    this.setGrayedChildren(treeItem, grayed);
                }
                ++i;
            }
        }
    }
}

